/* **************************************************************************
*                                                                           *
*  Resource.CPP                                                             *
*                                                                           *
*  13-03-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe genrica per a tots els recursos                                  *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "sys\resource.h"
#include "errors.h"
#include "sys\sys.h"
#include "sys\mailbox.h"
#include "sys\asm.h"

// **************************************************************************
// Constructor de la classe
CsysResource::CsysResource( PVOID pObject ) : CsysObject( pObject )
	{
	id = CID_Resource;
	}

// **************************************************************************
// Destructor de la classe
CsysResource::~CsysResource()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CsysResource::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Resource )
		return TRUE;
	else
		return CsysObject::ClassCheck( Cuid );
	}

// **************************************************************************
// Retorna l'estat del recurs
BYTE CsysResource::Status()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETSTATUS_RESOURCE;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BYTE) msg.dwParam1;
	}

// **************************************************************************
// Modifica l'estat del recurs
// Com a entrada ha de rebre:
// Status	  	- Nou estat del recurs
VOID CsysResource::Status( BYTE cStatus )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETSTATUS_RESOURCE;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) cStatus;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

// **************************************************************************
// Allibera el recurs
VOID CsysResource::Release()
	{
	::ReleaseResource( pobject );
	}

// **************************************************************************
// Espera l'alliberaci del recurs
VOID CsysResource::Wait()
	{
	::WaitResource( pobject );
	}

