/* **************************************************************************
*                                                                           *
*  Sem.CPP                                                                  *
*                                                                           *
*  15-06-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per a la gesti de semfors                                       *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "sys\sem.h"
#include "sys\mailbox.h"
#include "sys\asm.h"
#include "sys\sys.h"

CsysSemaphore::CsysSemaphore( DWORD dwValue, PCsysObject pParent, PSTR sName ) : CsysResource()
	{
	id = CID_Semaphore;

	PCsysMailBox box = new CsysMailBox();

	TData data;
	data.dwParam1	= (DWORD) sName;
	data.dwParam2	= dwValue;

	TMSG msg;

	msg.dwMessage	= SYS_CREATE_SEMAPHORE;

	if( pParent )
		msg.dwParam1	= (DWORD) pParent->GetInternalPointer();
	else
		msg.dwParam1	= 0;

	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	pobject = (PVOID) msg.dwParam1;
	}

CsysSemaphore::~CsysSemaphore()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_DESTROY_SEMAPHORE;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parametre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CsysSemaphore::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Semaphore )
		return TRUE;
	else
		return CsysResource::ClassCheck( Cuid );
	}

