/* **************************************************************************
*                                                                           *
*  Sys.CPP                                                                  *
*                                                                           *
*  14-03-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ pconsentiment per escrit de l'autor.        *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Nivell System de l'Eros ver 0.01                                         *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "sys\sys.h"
#include "errors.h"
#include "messages.h"
#include "sys\asm.h"
#include "sys\mailbox.h"
#include "string.h"
#include "sys\timer.h"
/*
VOID NULLThread();

extern PCsysModule SYSModule;
*/
CsysModule::CsysModule()
	{
	pbox = FindObject( SYS_MAILBOX );

	pnullbox = 	::CreateMailBox( NULL, NULL );
//	CreateThread( (DWORD) NULLThread, 0x2000, 0x1000 );
	}

CsysModule::~CsysModule()
	{
	}

PVOID CsysModule::MailBox()
	{
	return pbox;
	}

PVOID CsysModule::NULLMailBox()
	{
	return pnullbox;
	}

VOID CsysModule::RegisterDriver( PTDriver pDriver )
	{
	PCsysMailBox preply = new CsysMailBox();
	TMSG msg;

	pDriver->pnext = pDriver->pprev = NULL;
	pDriver->pReturn = preply->GetInternalPointer();

	msg.dwMessage	= SYS_REGISTERDRIVER_MOD;
	msg.dwParam1	= (DWORD) pDriver;
	msg.dwParam2	= 0;
	msg.pReply		= preply->GetInternalPointer();

	PostMessage( pbox, &msg );

	preply->WaitMessage( &msg );
	delete preply;
	}

VOID CsysModule::UnregisterDriver( PTDriver pDriver )
	{
	CsysMailBox reply;
	TMSG msg;

	msg.dwMessage	= SYS_UNREGISTERDRIVER_MOD;
	msg.dwParam1	= (DWORD) pDriver;
	msg.dwParam2	= 0;
	msg.pReply		= &reply;

	PostMessage( pbox, &msg );

	reply.WaitMessage( &msg );
	}

VOID CsysModule::GetComputerName( PSTR sName, DWORD dwMaxSize )
	{
	PCsysMailBox preply = new CsysMailBox();
	TMSG msg;

	msg.dwMessage	= SYS_GETCOMPUTERNAME_MOD;
	msg.dwParam1	= (DWORD) sName;
	msg.dwParam2	= dwMaxSize;
	msg.pReply		= (PVOID) preply->GetInternalPointer();

	PostMessage( pbox, &msg );

	TMSG msg2;

	preply->WaitMessage( &msg2 );
	delete preply;
	}

TTIME CsysModule::GetTime()
	{
	PCsysMailBox preply = new CsysMailBox();
	TMSG msg;

	msg.dwMessage	= SYS_GETTIME_MOD;
	msg.dwParam1	= 0;
	msg.dwParam2	= 0;
	msg.pReply		= preply->GetInternalPointer();

	PostMessage( pbox, &msg );

	preply->WaitMessage( &msg );
	delete preply;

	TTIME time;
	time.dwAll = msg.dwParam1;

	return time;
	}

TDATE CsysModule::GetDate()
	{
	PCsysMailBox preply = new CsysMailBox();
	TMSG msg;

	msg.dwMessage	= SYS_GETDATE_MOD;
	msg.dwParam1	= 0;
	msg.dwParam2	= 0;
	msg.pReply		= preply->GetInternalPointer();

	PostMessage( pbox, &msg );

	preply->WaitMessage( &msg );
	delete preply;

	TDATE date;
	date.dwAll = msg.dwParam1;

	return date;
	}

VOID CsysModule::SetTime( TTIME Time )
	{
	PCsysMailBox preply = new CsysMailBox();
	TMSG msg;

	msg.dwMessage	= SYS_SETTIME_MOD;
	msg.dwParam1	= Time.dwAll;
	msg.dwParam2	= 0;
	msg.pReply		= preply->GetInternalPointer();

	PostMessage( pbox, &msg );

	preply->WaitMessage( &msg );
	delete preply;
	}

VOID CsysModule::SetDate( TDATE Date )
	{
	PCsysMailBox preply = new CsysMailBox();
	TMSG msg;

	msg.dwMessage	= SYS_SETDATE_MOD;
	msg.dwParam1	= Date.dwAll;
	msg.dwParam2	= 0;
	msg.pReply		= preply->GetInternalPointer();

	PostMessage( pbox, &msg );

	preply->WaitMessage( &msg );
	delete preply;
	}

VOID CsysModule::RegisterShutdown( PVOID pAddress )
	{
	PCsysMailBox preply = new CsysMailBox();
	TMSG msg;

	msg.dwMessage	= SYS_REGISTERSHUTDOWN_MOD;
	msg.dwParam1	= (DWORD) pAddress;
	msg.dwParam2	= 0;
	msg.pReply		= preply->GetInternalPointer();

	PostMessage( pbox, &msg );

	preply->WaitMessage( &msg );
	delete preply;
	}

VOID CsysModule::UnregisterShutdown( PVOID pAddress )
	{
	PCsysMailBox preply = new CsysMailBox();
	TMSG msg;

	msg.dwMessage	= SYS_UNREGISTERSHUTDOWN_MOD;
	msg.dwParam1	= (DWORD) pAddress;
	msg.dwParam2	= 0;
	msg.pReply		= preply->GetInternalPointer();

	PostMessage( pbox, &msg );

	preply->WaitMessage( &msg );
	delete preply;
	}

VOID CsysModule::Shutdown( DWORD dwMode )
	{
	PCsysMailBox preply = new CsysMailBox();
	TMSG msg;

	msg.dwMessage	= SYS_SHUTDOWN_MOD;
	msg.dwParam1	= dwMode;
	msg.dwParam2	= 0;
	msg.pReply		= preply->GetInternalPointer();

	PostMessage( pbox, &msg );

	preply->WaitMessage( &msg );
	delete preply;
	}

VOID CsysModule::MemCopy( PBYTE pDest, PBYTE pSource, DWORD dwSize )
	{
	PCsysMailBox preply = new CsysMailBox();
	TMSG msg;

	TData data;
	data.dwParam1 = (DWORD) pDest;
	data.dwParam2 = (DWORD) pSource;
	data.dwParam3 = dwSize;

	msg.dwMessage	= SYS_MEMCOPY_MOD;
	msg.dwParam1	= (DWORD) &data;
	msg.dwParam2	= 0;
	msg.pReply		= preply->GetInternalPointer();

	PostMessage( pbox, &msg );

	preply->WaitMessage( &msg );
	delete preply;
	}

VOID CsysModule::MemMove( PBYTE pDest, PBYTE pSource, DWORD dwSize )
	{
	PCsysMailBox preply = new CsysMailBox();
	TMSG msg;

	TData data;
	data.dwParam1 = (DWORD) pDest;
	data.dwParam2 = (DWORD) pSource;
	data.dwParam3 = dwSize;

	msg.dwMessage	= SYS_MEMMOVE_MOD;
	msg.dwParam1	= (DWORD) &data;
	msg.dwParam2	= 0;
	msg.pReply		= preply->GetInternalPointer();

	PostMessage( pbox, &msg );

	preply->WaitMessage( &msg );
	delete preply;
	}

VOID CsysModule::MemSet( PBYTE pAddress, DWORD dwSize, BYTE cValue )
	{
	PCsysMailBox preply = new CsysMailBox();
	TMSG msg;

	TData data;
	data.dwParam1 = (DWORD) pAddress;
	data.dwParam2 = dwSize;
	data.dwParam3 = (DWORD) cValue;

	msg.dwMessage	= SYS_MEMSET_MOD;
	msg.dwParam1	= (DWORD) &data;
	msg.dwParam2	= 0;
	msg.pReply		= preply->GetInternalPointer();

	PostMessage( pbox, &msg );

	preply->WaitMessage( &msg );
	delete preply;
	}

LONG CsysModule::MemCompare( PBYTE pSource1, PBYTE pSource2, DWORD dwSize )
	{
	PCsysMailBox preply = new CsysMailBox();
	TMSG msg;

	TData data;
	data.dwParam1 = (DWORD) pSource1;
	data.dwParam2 = (DWORD) pSource2;
	data.dwParam3 = dwSize;

	msg.dwMessage	= SYS_MEMCOMPARE_MOD;
	msg.dwParam1	= (DWORD) &data;
	msg.dwParam2	= 0;
	msg.pReply		= preply->GetInternalPointer();

	PostMessage( pbox, &msg );

	preply->WaitMessage( &msg );
	delete preply;

	return msg.dwParam1;
	}

VOID CsysModule::ErrorCode( DWORD dwCode )
	{
	PCsysMailBox preply = new CsysMailBox();
	TMSG msg;

	msg.dwMessage	= SYS_SETERRORCODE_THREAD;
	msg.dwParam1	= (DWORD) GetInternalThread();
	msg.dwParam2	= dwCode;
	msg.pReply		= preply->GetInternalPointer();

	PostMessage( pbox, &msg );

	preply->WaitMessage( &msg );
	delete preply;
	}

DWORD CsysModule::ErrorCode()
	{
	PCsysMailBox preply = new CsysMailBox();
	TMSG msg;

	msg.dwMessage	= SYS_GETERRORCODE_THREAD;
	msg.dwParam1	= (DWORD) GetInternalThread();
	msg.dwParam2	= 0;
	msg.pReply		= preply->GetInternalPointer();

	PostMessage( pbox, &msg );

	preply->WaitMessage( &msg );
	delete preply;

	return msg.dwParam1;
	}

VOID CsysModule::Sleep( DWORD dwms )
	{
	PCsysMailBox preply = new CsysMailBox();
	TMSG msg;

	PCsysTimer alarm = new CsysTimer( dwms, preply, NULL );

	preply->WaitMessage( &msg );

	delete alarm;
	delete preply;
	}

VOID CsysModule::DriverReady()
	{
//	PCsysMailBox preply = new CsysMailBox();
	TMSG msg;

	msg.dwMessage	= SYS_DRIVERREADY;
	msg.dwParam1	= 0;
	msg.dwParam2	= 0;
	msg.pReply		= 0; //preply->GetInternalPointer();

	PostMessage( pbox, &msg );

//	preply->WaitMessage( &msg );
//	delete preply;
	}

PCsysThread CsysModule::CreateThread( DWORD dwEntryPoint, DWORD dwStackReserve, DWORD dwStackCommit )
	{
	PCsysMailBox preply = new CsysMailBox();

	TData data;

	data.dwParam1	= dwStackReserve;
	data.dwParam2	= dwStackCommit;

	TMSG msg;

	msg.dwMessage	= SYS_CREATE_THREAD;
	msg.dwParam1	= (DWORD) dwEntryPoint;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= preply->GetInternalPointer();

	PostMessage( pbox, &msg );

	preply->WaitMessage( &msg );
	delete preply;

	return new CsysThread( (PVOID) msg.dwParam1 );
	}

BOOL CsysModule::Exec( PSTR sName )
	{
	CsysMailBox preply;
	TMSG msg;

	msg.dwMessage	= SYS_EXEC_MOD;
	msg.dwParam1	= (DWORD) sName;
	msg.dwParam2	= 0;
	msg.pReply		= preply.GetInternalPointer();

	PostMessage( pbox, &msg );

	preply.WaitMessage( &msg );

	return (BOOL) msg.dwParam1;
	}

PCsysThread CsysModule::GetMe()
	{
	return NULL;
	}

PCsysProcess CsysModule::GetMyProcess()
	{
	return NULL;
	}
/*
VOID NULLThread()
	{
	PVOID box = SYSModule->NULLMailBox();
	TMSG msg;

	while( 1 )
		{
		WaitMessage( box, &msg );
		}
	}
*/
