/* **************************************************************************
*                                                                           *
*  CMOS.H                                                                   *
*                                                                           *
*  30-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Control de la CMOS                                                       *
*                                                                           *
************************************************************************** */

#ifndef _aalCMOS_H
#define _aalCMOS_H

#include "kernel\type.h"

_CLASSDEF( CCMOS )

// Registres de la CMOS
#define RTC_SECONDS			0
#define RTC_MINUTES			2
#define RTC_HOURS				4

#define RTC_DAY_OF_WEEK		6
#define RTC_DAY_OF_MONTH	7
#define RTC_MONTH				8
#define RTC_YEAR				9

// Registres de control - Nom habitual
#define RTC_REG_A				10
#define RTC_REG_B				11
#define RTC_REG_C				12
#define RTC_REG_D				13

// Detalls dels registres de control
#define RTC_FREQ_SELECT		RTC_REG_A
// 'Update-in-progress' actiu mentre s'actualitza el rellotge
#define RTC_UIP				0x80

#define RTC_CONTROL			RTC_REG_B
#define RTC_SET 				0x80	/* Desactiva actualitzaci per a posar l'hora/data */
#define RTC_PIE 				0x40	/* Activa la interrupci peridica */
#define RTC_AIE 				0x20	/* Activar la alarma */
#define RTC_UIE 				0x10	/* Activar la interrupci d'actualitzaci finalitzada */
#define RTC_SQWE 				0x08	/* Activar la sortida de forma d'ona quadrada */
#define RTC_DM_BINARY 		0x04	/* Si est a zero, la data i l'hora estan en format BCD */
#define RTC_24H 				0x02	/* Mode de 24 hores - sin el 'bit 7' de l'hora significa 'PM' */
#define RTC_DST_EN 			0x01	/* Canvia automticament l'hora en horari d'estiu/hivern */

// Transforma un valor BCD en binari
#ifndef BCD_TO_BIN
#define BCD_TO_BIN( val )	(BYTE) ((val & 15) + (val >> 4) * 10)
#endif

// Transforma un valor binari en BCD
#ifndef BIN_TO_BCD
#define BIN_TO_BCD( val )	(BYTE) (((val / 10) << 4) + val % 10)
#endif

// Indica el tipus de disquetera
#define NO_DRIVE				0
#define DRIVE_360K			1
#define DRIVE_1200K			2
#define DRIVE_720K			3
#define DRIVE_1440K			4

typedef struct _AAL_TIME
	{
	union
		{
		DWORD dwAll;
		struct
			{
			BYTE cHour;
			BYTE cMinute;
			BYTE cSecond;
			BYTE cpad;							// Per arrodonir a DWORD
			} Parts;
		};
	} TAAL_TIME, *PTAAL_TIME;

typedef struct _AAL_DATE
	{
	union
		{
		DWORD dwAll;
		struct
			{
			BYTE cDayOfWeek:3;
			BYTE cDay:5;
			BYTE cMonth;
			WORD wYear;
			} Parts;
		};
	} TAAL_DATE, *PTAAL_DATE;

class CCMOS : public CkeType
	{
	protected:
	public:
		CCMOS();
		virtual ~CCMOS();

		virtual BOOL ClassCheck( CUID );

		BOOL MathProcessor();

		BYTE Drive0Type();
		BYTE Drive1Type();

		TAAL_TIME Time();
		TAAL_DATE Date();

		VOID Time( TAAL_TIME );
		VOID Date( TAAL_DATE );
	};

#endif

