/* **************************************************************************
*                                                                           *
*  DMA.H                                                                    *
*                                                                           *
*  30-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Manipulaci del xip Direct Memory Access                                 *
*                                                                           *
************************************************************************** */

#ifndef _aalDMA_H
#define _aalDMA_H

#include "kernel\type.h"

_CLASSDEF( CDMA )

#include "kernel\pcb.h"

#define DMA_CHANNELS			8

// Adrea fsica mxima a la que pot accedir el DMA en aquesta plataforma
#define MAX_DMA_ADDRESS		0x1000000

// 8237 Controladors del DMA
#define IO_DMA1_BASE			0x00	/* 8 'bit' DMA esclau, canals 0..3 */
#define IO_DMA2_BASE			0xC0	/* 16 'bit' DMA master, canals 4(=entrada de l'esclau)..7 */

#define DMA10Add				0x00
#define DMA10Cnt				0x01
#define DMA11Add				0x02
#define DMA11Cnt				0x03
#define DMA12Add				0x04
#define DMA12Cnt				0x05
#define DMA13Add				0x06
#define DMA13Cnt				0x07
#define DMA1StatCmd			0x08
#define DMA1RqReg				0x09
#define DMA1RCmdWbm			0x0A
#define DMA1Mode				0x0B
#define DMA1FF					0x0C
#define DMA1Clear				0x0D
#define DMA1ClrMode			0x0E
#define DMA1MskBts			0x0F

// Adreces dels ports del DMA 2
#define DMA20Add				0xC0
#define DMA20Cnt				0xC2
#define DMA21Add				0xC4
#define DMA21Cnt				0xC6
#define DMA22Add				0xC8
#define DMA22Cnt				0xCA
#define DMA23Add				0xCC
#define DMA23Cnt				0xCE
#define DMA2StatCmd			0xD0
#define DMA2RqReg				0xD2
#define DMA2RCmdWbm			0xD4
#define DMA2Mode				0xD6
#define DMA2FF					0xD8
#define DMA2Clear				0xDA
#define DMA2ClrMode			0xDC
#define DMA2MskBts			0xDE

// Registre de pgina del DMA per nombre de DRQ/DACK
#define DMAPage0				0x87	 /* Registre de pgina del DACK0 del DMA */
#define DMAPage1				0x83	 /* DACK1, etc */
#define DMAPage2				0x81
#define DMAPage3				0x82
#define DMAPage5				0x8B
#define DMAPage6				0x89
#define DMAPage7				0x8A

#define DMA_MODE_READ		0x44	/* E/S cap a memria, no autoinit, incrementar, 'single mode' */
#define DMA_MODE_WRITE		0x48	/* memria cap a E/S, no autoinit, incrementar, 'single mode' */
#define DMA_MODE_CASCADE	0xC0  /* passar a travs de DREQ->HRQ, DACK<-HLDA solament */

class CDMA : public CkeType
	{
		VOID Enable( BYTE );
		VOID Disable( BYTE );
		VOID ClearFlipFlop( BYTE );
		VOID SetMode( BYTE, BYTE );
		VOID SetPage( BYTE, BYTE );
		VOID SetAddress( BYTE, DWORD );
		VOID SetCount( BYTE, DWORD );

	protected:
		PCkeProcess ReservedChannel[ DMA_CHANNELS ];

	public:
		CDMA();
		virtual ~CDMA();

		virtual BOOL ClassCheck( CUID );

		VOID ReserveChannel( BYTE, PCkeProcess );
		VOID FreeChannel( BYTE, PCkeProcess );

		VOID TransferData( BYTE, PCkeProcess, BYTE, BYTE, DWORD, DWORD );

		DWORD GetResidue( BYTE );
	};

#endif

