/* **************************************************************************
*                                                                           *
*  IDE.H                                                                    *
*                                                                           *
*  16-02-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Controlador de dispositius IDE de l'Eros (declaracions privades)         *
*                                                                           *
************************************************************************** */

#ifndef _IDE_H
#define _IDE_H

#include "drivers\block\ide.h"
#include "sys\mailbox.h"

#define LOCKED    		TRUE
#define UNLOCKED			FALSE

#define HD_PORT 0x1f0

/* When writing to the port+X (where X =):
	 0 - write data       (1F0h - 16 bit)
	 1 - pre-comp         (1F1h)
	 2 - sector count     (1F2h)
	 3 - sector number    (1F3h)
	 4 - low cyl          (1F4h)
	 5 - high cyl         (1F5h)
	 6 - size/drive/head  (1F6h)
	 7 - command register (1F7h)

When reading from the port+X (where X =):
	 0 - read data       (1F0h - 16 bit)
	 1 - error register  (1F1h)
	 2 - sector count    (1F2h)
	 3 - sector number   (1F3h)
	 4 - low cyl         (1F4h)
	 5 - high cyl        (1F5h)
	 6 - size/drive/head (1F6h)
	 7 - status register (1F7h)
*/

#define HD_REG_PORT 0x3f6

/* This is a byte wide write only control port
   that allows reset and defines some special
   characteristics of the hard drives.
	Bit		Desc
	0		Not used
	1		Not used
	2		Reset Bit - Set, wait 50us, then Reset
	3		Mucho Heads Flag. Set = More than 8 heads
	4		Not used
	5		Not used
	6		Disable retries
	7		Disable retries (same as six, either one set)
*/

/* HDC Status Register Bit Masks (1F7h) */

#define BUSY        0x80  /* busy.. can't talk now! */
#define READY       0x40  /* Drive Ready  */
#define WRITE_FAULT 0x20  /* Bad news */
#define SEEKOK      0x10  /* Seek Complete */
#define DATA_REQ    0x08  /* Sector buffer needs servicing */
#define CORRECTED   0x04  /* ECC corrected data was read */
#define REV_INDEX   0x02  /* Set once each disk revolution */
#define ERROR       0x01  /* data address mark not found */

/* HDC Error Register Bit Masks (1F1h) */

#define BAD_SECTOR  0x80  /* bad block */
#define BAD_ECC     0x40  /* bad data ecc */
#define BAD_IDMARK  0x10  /* id not found */
#define BAD_CMD     0x04  /* aborted command */
#define BAD_SEEK    0x02  /* trk 0 not found on recalibrate, or bad seek */
#define BAD_ADDRESS 0x01  /* data address mark not found */


/* HDC internal command bytes (HDC_Cmd[7]) */

#define HDC_RECAL      0x10   /* 0001 0000 */
#define HDC_READ       0x20   /* 0010 0000 */
#define HDC_READ_LONG  0x22   /* 0010 0010 */
#define HDC_WRITE      0x30   /* 0011 0000 */
#define HDC_WRITE_LONG 0x32   /* 0011 0010 */
#define HDC_VERIFY     0x40   /* 0100 0000 */
#define HDC_FORMAT     0x50   /* 0101 0000 */
#define HDC_SEEK       0x70   /* 0111 0000 */
#define HDC_DIAG       0x90   /* 1001 0000 */
#define HDC_SET_PARAMS 0x91   /* 1001 0001 */

#define  CNSN_SZ     20
#define  REV_SZ      8
#define  MODEL_SZ    40

#pragma option -a1
typedef struct _Parms
	{
	WORD w_config;
	WORD w_fixedcyl;
	WORD w_removcyl;
	WORD w_heads;
	WORD w_unfbytespertrk;
	WORD w_unfbytes;
	WORD w_sectors;
	WORD w_minisg;
	WORD w_minplo;
	WORD w_vendstat;
	BYTE w_cnsn[CNSN_SZ];
	WORD w_cntype;
	WORD w_cnsbsz;
	WORD w_necc;
	BYTE w_rev[REV_SZ];
	BYTE w_model[MODEL_SZ];
	WORD w_nsecperint;
	WORD w_usedmovsd;
	} TParms, *PTParms;
#pragma option -a4

_CLASSDEF( CIDEDrive )

class CIDEDrive
	{
		CIDEDrive();

	protected:
		DWORD dwlastrecal, dwlastseek, dwlasterc, dwlaststat;
		PCsysMailBox pmailbox;
		BYTE cdrive, secpertrk, heads;
		WORD cyls;
		BOOL blocked;
		BYTE nsectors;
		BYTE hd_Cmd[ 8 ];		/* For all 8 command bytes */
		BYTE head;		// Calculated from LBA - which head
		BYTE sector;		// Calculated from LBA - Starting sector

		DWORD Seek( DWORD );
		DWORD Status( BYTE );
		DWORD FormatTrack( DWORD, DWORD );
		DWORD ReadSector( DWORD, DWORD, PBYTE );
		DWORD setupseek( DWORD, DWORD );
		DWORD SendCommand( BYTE );
		DWORD Wait();
		DWORD CheckBusy();
		DWORD GetGeometry();

	public:
		CIDEDrive( BYTE, PCsysMailBox );
		virtual ~CIDEDrive();

		DWORD Read( PBYTE, DWORD, DWORD );
		DWORD Write( PBYTE, DWORD, DWORD );
		BOOL Verify( DWORD, DWORD );

		BOOL Lock();
		BOOL Unlock();

		DWORD CheckMedia();
		BOOL MediaChange();

		BOOL DispatchMessage( TMSG& );

		PCsysMailBox MailBox();

		VOID Reset();

		DWORD Recalibrate();
	};

#endif

