/* **************************************************************************
*                                                                           *
*  Video.H                                                                  *
*                                                                           *
*  12-02-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Controlador de video de l'Eros (declaracions privades)                   *
*                                                                           *
************************************************************************** */

#ifndef _VIDEO_H
#define _VIDEO_H

#include "drivers\char\video.h"
#include "kernel\list.h"

#define DISPLAY_SIZE		(WIDE * HEIGHT)
#define WIDE   			80
#define HEIGHT				25
#define VGA_BUFFER		0xB8000

#define CRTCPort1			0x3d4
#define CRTCPort2			0x3d5
#define CRTCAddHi			0x0c
#define CRTCAddLo			0x0d
#define CRTCCurHi			0x0e
#define CRTCCurLo			0x0f

_CLASSDEF( CVideo )

class CVideo : public CkeType
	{
	protected:
		BOOL bshowcaret;
		BYTE cattribute;
		BYTE cposx;
		BYTE cposy;
		PWORD pscreen;
		WORD buffer[ DISPLAY_SIZE ];

	public:
		CVideo();
		virtual ~CVideo();

		VOID GotoXY( BYTE, BYTE );
		VOID Clear();
		VOID OutText( PSTR );
		CHAR GetChar( BYTE, BYTE );
		VOID SetChar( BYTE, BYTE, CHAR );

		BYTE GetAttribute( BYTE, BYTE );
		VOID SetAttribute( BYTE, BYTE, BYTE );

		BYTE GetColor();
		BYTE GetBkColor();
		VOID SetColor( BYTE );
		VOID SetBkColor( BYTE );

		BYTE GetX();
		BYTE GetY();

		VOID Activate();
		VOID Deactivate();

		VOID SetCaret( BOOL );
	};

#endif

