/* **************************************************************************
*                                                                           *
*  FS.H                                                                     *
*                                                                           *
*  18-02-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Sistema de fitxers genric                                               *
*                                                                           *
************************************************************************** */

#ifndef _drvFS_H
#define _drvFS_H

#include "consts.h"
#include "kernel\mailbox.h"
#include "kernel\pcb.h"
#include "drivers\block\blockdev.h"

_CLASSDEF( CdrvFileSystem )

//#include "drivers\fs\fcb.h" -BUG

#define MAX_FILESYSTEM_NAME		10

class CdrvFileSystem : public CkeType
	{
		CdrvFileSystem();

	protected:
		PCkeMailBox pobject;

	public:
		CdrvFileSystem( PSTR );
		virtual ~CdrvFileSystem();

		VOID Name( PSTR, DWORD );
/* -BUG
		PCdrvGlobalFile OpenFile( PCkeProcess, const PSTR, DWORD, DWORD );
		VOID CloseFile( PCkeProcess, PCdrvGlobalFile );
		DWORD ReadFile( PCkeProcess, PCdrvGlobalFile, DWORD, DWORD );
		DWORD WriteFile( PCkeProcess, PCdrvGlobalFile, DWORD, DWORD );
		DWORD SeekFile( PCkeProcess, PCdrvGlobalFile, DWORD, LONG );
		VOID FlushFile( PCkeProcess, PCdrvGlobalFile );
		VOID SetFileSize( PCkeProcess, PCdrvGlobalFile, DWORD );
		VOID SetAttributes( PCkeProcess, PCdrvGlobalFile, DWORD );
		DWORD GetAttributes( PCkeProcess, PCdrvGlobalFile );
*/
		VOID Delete( PCkeProcess, const PSTR );
		VOID Rename( PCkeProcess, const PSTR, const PSTR );
		VOID Create( PCkeProcess, const PSTR, DWORD );

		VOID GrowPageFile( DWORD );
		VOID ShrinkPageFile( DWORD );
		VOID ReadPageFile( DWORD, DWORD );
		VOID WritePageFile( DWORD, DWORD );
		DWORD PageFileSize();

		PVOID GetInternalPointer();
	};

#endif

