/* **************************************************************************
*                                                                           *
*  Fenix.H                                                                  *
*                                                                           *
*  14-03-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ pconsentiment per escrit de l'autor.        *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Subsistema Fnix de l'Eros ver 0.0.1                                     *
*                                                                           *
************************************************************************** */

#ifndef _fnxFENIX_H
#define _fnxFENIX_H

#include "time.h"

#define FENIX_MAILBOX			TEXT( "\\Mailbox\\Fenix" )
#define nFENIX_MAILBOX			TEXT( "Fenix" )

_CLASSDEF( CfnxModule )

#include "fenix\thread.h"

class CfnxModule
	{
	protected:
		PVOID pbox;
		PVOID pnullbox;

	public:
		CfnxModule();
		virtual ~CfnxModule();

		PVOID MailBox();
		PVOID NULLMailBox();
		VOID GetComputerName( PSTR, DWORD );

		TTIME GetTime();
		TDATE GetDate();
		VOID SetTime( TTIME );
		VOID SetDate( TDATE );

		VOID RegisterShutdown( PVOID );
		VOID UnregisterShutdown( PVOID );
		VOID Shutdown( DWORD );

		VOID MemCopy( PBYTE, PBYTE, DWORD );
		VOID MemMove( PBYTE, PBYTE, DWORD );
		VOID MemSet( PBYTE, DWORD, BYTE );
		LONG MemCompare( PBYTE, PBYTE, DWORD );

		DWORD ErrorCode();

		VOID Sleep( DWORD );

		PCfnxThread CreateThread( DWORD, DWORD, DWORD );
		BOOL Exec( PSTR );
		PCfnxThread GetMe();
		PCfnxProcess GetMyProcess();
	};

extern PCfnxModule Fenix;

#endif

