/* **************************************************************************
*                                                                           *
*  List.H                                                                   *
*                                                                           *
*  08-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classes genriques per a llistes i llistes doblement encadenades         *
*                                                                           *
************************************************************************** */

#ifndef _fnxLIST_H
#define _fnxLIST_H

#include "fenix\type.h"

_KERNELEXP( CfnxFIFOList )
_KERNELEXP( CfnxLIFOList )
_KERNELEXP( CfnxListItem )
_KERNELEXP( CfnxDblListItem )

class CfnxListItem : virtual public CfnxType
	{
	protected:
		PCfnxListItem pnext;

	public:
		CfnxListItem( PCfnxListItem = NULL );
		virtual ~CfnxListItem();

		virtual BOOL ClassCheck( CUID Cuid );

		virtual PCfnxListItem GetNext();
		virtual VOID SetNext( PCfnxListItem = NULL );
	};

class CfnxDblListItem : public CfnxListItem
	{
	protected:
		PCfnxDblListItem pprev;

	public:
		CfnxDblListItem( PCfnxDblListItem = NULL, PCfnxDblListItem = NULL );
		virtual ~CfnxDblListItem();

		virtual BOOL ClassCheck( CUID Cuid );

		virtual PCfnxDblListItem GetPrev();
		virtual VOID SetPrev( PCfnxDblListItem = NULL );
	};

class CfnxLIFOList : public CfnxType
	{
	protected:
		PCfnxListItem pfirst;
		DWORD dwelements;

	public:
		CfnxLIFOList();
		virtual ~CfnxLIFOList();

		virtual PCfnxListItem Get();
		virtual VOID Add( PCfnxListItem );
		virtual VOID Delete( PCfnxListItem );
	};

class CfnxFIFOList : public CfnxLIFOList
	{
	protected:
		PCfnxListItem plast;

	public:
		CfnxFIFOList();
		virtual ~CfnxFIFOList();

		virtual PCfnxListItem Get();
		virtual VOID Add( PCfnxListItem );
		virtual VOID Delete( PCfnxListItem );
	};

#endif
