/* **************************************************************************
*                                                                           *
*  ASM.H                                                                    *
*                                                                           *
*  17-02-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Codi en Assembler del kernel                                             *
*                                                                           *
************************************************************************** */

#ifndef _keASM_H
#define _keASM_H

#include "consts.h"

typedef struct _Registers
	{
	WORD CS, SS, DS, ES, FS, GS;
	DWORD EAX, EBX, ECX, EDX, ESI, EDI, ESP, EBP, EIP;
	DWORD EFLAGS;
	} TRegisters, *PTRegisters;

DWORD _export CLI();
VOID _export STI( DWORD );
VOID _export MicroDelay( DWORD );

// Operacions amb les taules del sistema
// -- Operacions amb la GDT
VOID SGDT();
// --

// -- Operacions amb la IDT
VOID SIDT();
// --

// -- Operacions amb les LDTs
VOID LLDT( PWORD );
VOID SLDT( PWORD );
// --

// -- Operacions amb els TSS
VOID LTR();
VOID STR();
// --

// Operacions sobre registres especials del processador

// -- Operacions sobre CR0
DWORD GetCR0();
VOID SetCR0( DWORD );
// --

// -- Operacions sobre CR2
DWORD GetCR2();
// --

// -- Operacions sobre CR3
DWORD GetCR3();
VOID SetCR3( DWORD );
VOID CacheCR3();
// --

// -- Operacions sobre els EFLAGS
DWORD GetEFLAGS();
VOID SetEFLAGS( DWORD );
// --

// Operacions amb els ports d'E/S

VOID outpb( WORD, BYTE );
VOID outpw( WORD, WORD );
VOID outpd( WORD, DWORD );
VOID outwords( WORD, PBYTE, DWORD );

BYTE inpb( WORD );
WORD inpw( WORD );
DWORD inpd( WORD );
VOID inwords( WORD, PBYTE, DWORD );

// Ajudes
VOID Call( DWORD );
VOID JumpTSS();
DWORD CpuType();
VOID PrepareRegisters();
VOID PrepareRegistersWithError();

// Interrupcions
VOID UnhandledInterrupt();
VOID INT0();
VOID INT1();
VOID INT2();
VOID INT3();
VOID INT4();
VOID INT5();
VOID INT6();
VOID INT7();
VOID INT8();
VOID INT9();
VOID INTA();
VOID INTB();
VOID INTC();
VOID INTD();
VOID INTE();
VOID INTF();
VOID INT10();
VOID INT11();
VOID INT12();
VOID INT13();
VOID INT14();
VOID INT15();
VOID INT16();
VOID INT17();
VOID INT18();
VOID INT19();
VOID INT1A();
VOID INT1B();
VOID INT1C();
VOID INT1D();
VOID INT1E();
VOID INT1F();
VOID INT20();
VOID INT21();
VOID INT22();
VOID INT23();
VOID INT24();
VOID INT25();
VOID INT26();
VOID INT27();
VOID INT28();
VOID INT29();
VOID INT2A();
VOID INT2B();
VOID INT2C();
VOID INT2D();
VOID INT2E();
VOID INT2F();
VOID INT30();

#endif

