/* **************************************************************************
*                                                                           *
*  CRX.H                                                                    *
*                                                                           *
*  08-01-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per al control dels registres CR0 i CR3                           *
*                                                                           *
************************************************************************** */

#ifndef _CRX_H
#define _CRX_H

#include "kernel\type.h"

typedef struct _TCR0
	{
	union
		{
		DWORD CR0;
		struct
			{
			BYTE PE : 1;
			BYTE MP : 1;
			BYTE EM : 1;
			BYTE TS : 1;
			BYTE ET : 1;
			WORD Reserved1_0 : 16;
			WORD Reserved2_0 : 10;
			BYTE PG : 1;
			} Bits;
		} DWord;
	} TCR0, *PTCR0;

typedef struct _TCR3
	{
	union
		{
		DWORD CR3;
		struct
			{
			WORD Reserved1_0 : 12;
			WORD PDBRLo : 16;
			WORD PDBRHi : 4;
			} Bits;
		} DWord;
	} TCR3, *PTCR3;

_CLASSDEF( CCR0 )

class CCR0 : public CkeType
	{
	protected:
		TCR0 cr0;

	public:
		CCR0( DWORD = 0L );
		virtual ~CCR0();

		virtual BOOL ClassCheck( CUID Cuid );

		VOID SetHard();
		VOID GetHard();

		VOID Clear();

		DWORD CR0();
		VOID CR0( DWORD );

		BOOL PE();
		BOOL MP();
		BOOL EM();
		BOOL TS();
		BOOL ET();
		BOOL PG();

		VOID PE( BOOL );
		VOID MP( BOOL );
		VOID EM( BOOL );
		VOID TS( BOOL );
		VOID ET( BOOL );
		VOID PG( BOOL );
	};

_CLASSDEF( CCR3 )

class CCR3 : public CkeType
	{
	protected:
		TCR3 cr3;

	public:
		CCR3( DWORD = 0L );
		virtual ~CCR3();

		virtual BOOL ClassCheck( CUID Cuid );

		VOID SetHard();
		VOID GetHard();

		VOID Clear();

		DWORD CR3();
		VOID CR3( DWORD );

		DWORD PDBR();
		VOID PDBR( DWORD );
	};

#endif
