/* **************************************************************************
*                                                                           *
*  Descr.H                                                                  *
*                                                                           *
*  13-07-96                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Control dels descriptors                                                 *
*                                                                           *
************************************************************************** */

#ifndef _DESCR_H
#define _DESCR_H

#include "kernel\type.h"

typedef struct _TDescriptor
	{
	WORD    LimitLow;
	WORD    BaseLow;
	union
		{
		struct
			{
			BYTE    BaseMid;
			BYTE    Flags1;     // Declarem com a 'bytes' per a evitar
			BYTE    Flags2;     // problemes d'aliniaci
			BYTE    BaseHi;
			} Bytes;
		struct
			{
			BYTE	BaseMid : 8;
			BYTE	Type : 5;
			BYTE	Dpl : 2;
			BYTE	Pres : 1;
			BYTE  LimitHi : 4;
			BYTE  Sys : 1;
			BYTE  Reserved_0 : 1;
			BYTE  Default_Big : 1;
			BYTE  Granularity : 1;
			BYTE  BaseHi : 8;
			} Bits;
		} HighWord;
	} TDescriptor, *PTDescriptor;

_CLASSDEF( CDescriptor )

class CDescriptor : public CkeType
	{
	protected:
		PTDescriptor pdesc;
		BOOL binitialized;

	public:
		CDescriptor( PTDescriptor = NULL );
		virtual ~CDescriptor();

		virtual BOOL ClassCheck( CUID Cuid );

		virtual PTDescriptor PDescriptor();
		virtual VOID Descriptor( PTDescriptor = NULL );

		virtual VOID Clear();

		virtual DWORD Base();
		virtual DWORD Limit();
		virtual BYTE Type();
		virtual BYTE DPL();
		virtual BOOL Present();
		virtual BOOL Sys();
		virtual BOOL Big();
		virtual BOOL Granularity();

		virtual BOOL Processor();
		virtual BOOL Data();
		virtual BOOL Code();
		virtual BOOL Down();
		virtual BOOL Writeable();
		virtual BOOL Accessed();
		virtual BOOL Conformed();
		virtual BOOL Readable();

		virtual BOOL FreeTSS386();
		virtual BOOL BusyTSS386();
		virtual BOOL LDT();
		virtual BOOL Callgate();
		virtual BOOL Taskgate();
		virtual BOOL Intgate386();
		virtual BOOL Trapgate386();

		virtual VOID Base( DWORD );
		virtual VOID Limit( DWORD );
		virtual VOID Type( BYTE );
		virtual VOID DPL( BYTE );
		virtual VOID Present( BOOL );
		virtual VOID Sys( BOOL );
		virtual VOID Big( BOOL );
		virtual VOID Granularity( BOOL );

		virtual VOID SetProcessor();
		virtual VOID SetData();
		virtual VOID SetCode();
		virtual VOID SetDown( BOOL = TRUE );
		virtual VOID SetWriteable( BOOL = TRUE );
		virtual VOID SetAccessed( BOOL = TRUE );
		virtual VOID SetConformed( BOOL = TRUE );
		virtual VOID SetReadable( BOOL = TRUE );

		virtual VOID SetFreeTSS386();
		virtual VOID SetBusyTSS386();
		virtual VOID SetLDT();
		virtual VOID SetCallgate();
		virtual VOID SetTaskgate();
		virtual VOID SetIntgate386();
		virtual VOID SetTrapgate386();
	};

#endif

