/* **************************************************************************
*                                                                           *
*  List.H                                                                   *
*                                                                           *
*  28-01-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classes genriques per a llistes i llistes doblement encadenades         *
*                                                                           *
************************************************************************** */

#ifndef _keLIST_H
#define _keLIST_H

#include "kernel\type.h"

_KERNELEXP( CkeFIFOList )
_KERNELEXP( CkeLIFOList )
_KERNELEXP( CkeListItem )
_KERNELEXP( CkeDblListItem )

class CkeListItem : virtual public CkeType
	{
	protected:
		PCkeListItem pnext;

	public:
		CkeListItem( PCkeListItem = NULL );
		virtual ~CkeListItem();

		virtual BOOL ClassCheck( CUID Cuid );

		virtual PCkeListItem GetNext();
		virtual VOID SetNext( PCkeListItem = NULL );
	};

class CkeDblListItem : public CkeListItem
	{
	protected:
		PCkeDblListItem pprev;

	public:
		CkeDblListItem( PCkeDblListItem = NULL, PCkeDblListItem = NULL );
		virtual ~CkeDblListItem();

		virtual BOOL ClassCheck( CUID Cuid );

		virtual PCkeDblListItem GetPrev();
		virtual VOID SetPrev( PCkeDblListItem = NULL );
	};

class CkeLIFOList : public CkeType
	{
	protected:
		PCkeListItem pfirst;
		DWORD dwelements;

	public:
		CkeLIFOList();
		virtual ~CkeLIFOList();

		virtual PCkeListItem Get();
		virtual VOID Add( PCkeListItem );
		virtual VOID Delete( PCkeListItem );
	};

class CkeFIFOList : public CkeLIFOList
	{
	protected:
		PCkeListItem plast;

	public:
		CkeFIFOList();
		virtual ~CkeFIFOList();

//		virtual PCkeListItem Get();
		virtual VOID Add( PCkeListItem );
		virtual VOID Delete( PCkeListItem );
	};

#endif

