/* **************************************************************************
*                                                                           *
*  PCB.H                                                                    *
*                                                                           *
*  18-01-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Control dels processos                                                   *
*                                                                           *
************************************************************************** */

#ifndef _kePCB_H
#define _kePCB_H

#include "kernel\type.h"

_KERNELEXP( CkeProcess )

#include "kernel\resource.h"
#include "kernel\pagedir.h"
#include "kernel\ldt.h"
#include "kernel\thread.h"
#include "kernel\mutex.h"
#include "kernel\heap.h"

// Selector per a codi i dades dins l'LDT
#define PROC_CODE		4
#define PROC_DATA		12

#define MODE_KERNEL	FALSE
#define MODE_USER		TRUE

class CkeProcess : public CkeResource
	{
		CkeProcess();

	protected:
		PCkePageDirectory ppagedir;
		PCLDT pldt;
		PCkeThread pthread;
		BYTE cbasepriority;
		PCkeHeap pheap;
		BOOL bprivilegelevel;

	public:
		CkeProcess( PSTR, DWORD, DWORD, DWORD, DWORD, DWORD, PCkeObject, BOOL = MODE_USER, BOOL = FALSE, BOOL = TRUE );
		virtual ~CkeProcess();

		virtual BOOL ClassCheck( CUID Cuid );

		virtual PVOID Map( PCkeRegion, DWORD );
		virtual VOID Unmap( PCkeRegion );
		virtual BOOL TryToMap( PCkeRegion, PVOID, DWORD );
		virtual VOID Commit( PVOID, DWORD );

		virtual VOID AddThread( PCkeThread );
		virtual PCkeThread Thread();

		BYTE BasePriority();
		VOID BasePriority( BYTE );

		virtual PCkeHeap Heap();

		DWORD PDBR();
		WORD LDTEntry();

		BOOL PrivilegeLevel();
	};

#endif

