/* **************************************************************************
*                                                                           *
*  Selector.H                                                               *
*                                                                           *
*  13-07-96                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Control dels selectors                                                   *
*                                                                           *
************************************************************************** */

#ifndef _SELECTOR_H
#define _SELECTOR_H

#include "kernel\type.h"

typedef struct _TSelector
	{
	union
		{
		WORD Index;
		struct
			{
			BYTE RPL : 2;
			BYTE Table : 1;
			WORD Index : 13;
			} Bits;
		} Word;
	} TSelector, *PTSelector;

#define SELECTOR_GDT		0
#define SELECTOR_LDT		1

_CLASSDEF( CSelector )

class CSelector : public CkeType
	{
	protected:
		TSelector selector;

	public:
		CSelector( WORD = 0 );
		virtual ~CSelector();

		virtual BOOL ClassCheck( CUID Cuid );

		VOID Selector( WORD );
		WORD Selector();

		WORD Index();
		BOOL GDT();
		BOOL LDT();
		BYTE RPL();

		VOID Index( WORD );
		VOID Table( BOOL );		// 0 - GDT / 1 - LDT
		VOID RPL( BYTE );
	};

#endif

