/* **************************************************************************
*                                                                           *
*  SysTable.H                                                               *
*                                                                           *
*  13-07-96                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe genrica per a les taules GDT, LDT i IDT                          *
*                                                                           *
************************************************************************** */

#ifndef _SYSTABLE_H
#define _SYSTABLE_H

#include "kernel\type.h"
#include "kernel\descr.h"

#define NEXT_DESCRIPTOR		(WORD) 0xffffL

_CLASSDEF( CSystemTable )

class CSystemTable : public CkeType
	{
	protected:
		PTDescriptor pdesc;
		WORD wsize;
		BOOL binitialized;

	public:
		CSystemTable( PTDescriptor = NULL, WORD = 0 );
		virtual ~CSystemTable();

		virtual BOOL ClassCheck( CUID Cuid );

		virtual VOID SetHard() = 0;
		virtual VOID GetHard() = 0;

		virtual VOID Clear() = 0;

		virtual VOID Table( PTDescriptor = NULL, WORD = 0 );
		virtual PTDescriptor GetTable();

		PTDescriptor Descriptor( WORD );

		WORD Size();
		WORD Free();

		VOID Size( WORD );
		VOID Free( WORD );
		WORD CreateDescriptor( WORD = NEXT_DESCRIPTOR );
	};

#endif

