/* **************************************************************************
*                                                                           *
*  VAD.H                                                                    *
*                                                                           *
*  11-01-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe que controla les Virtual Address Descriptor                       *
*                                                                           *
************************************************************************** */

#ifndef _keVAD_H
#define _keVAD_H

#include "kernel\type.h"
#include "kernel\list.h"

_KERNELEXP( CkeVAD )

#include "kernel\region.h"
#include "kernel\pcb.h"
#include "kernel\mutex.h"

class CkeVAD : public CkeDblListItem
	{
	protected:
		PVOID pvirtualaddress;
		PCkeProcess pproc;
		PCkeRegion pregion;
		BYTE cprivateprotection;

	public:
		CkeVAD( PVOID = NULL, PCkeProcess = NULL, PCkeRegion = NULL, BYTE = NULL, PCkeVAD = NULL, PCkeVAD = NULL );
		virtual ~CkeVAD();

		virtual BOOL ClassCheck( CUID Cuid );

		PVOID VirtualAddress();
		PCkeProcess Process();
		PCkeRegion Region();
      BYTE Protection();

		VOID VirtualAddress( PVOID );
		VOID Process( PCkeProcess );
		VOID Region( PCkeRegion );
      VOID Protection( BYTE );
	};

#endif

