/* **************************************************************************
*                                                                           *
*  Security.H                                                               *
*                                                                           *
*  23-01-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe que implementa les llistes de control d'accs (ACL)               *
*                                                                           *
************************************************************************** */

#ifndef _SECURITY_H
#define _SECURITY_H

#include "kernel\list.h"
#include "sys\private\rights.h"

_CLASSDEF( CSecurityItem )

#define SECURITY_ALLOW			1
#define SECURITY_DENY			2

class CSecurityItem : public CkeDblListItem, public CRights
	{
		CSecurityItem();

	protected:
		BYTE ctype;

	public:
		CSecurityItem( DWORD, BYTE = SECURITY_ALLOW );
		virtual ~CSecurityItem();

		virtual BOOL ClassCheck( CUID );

		BYTE Type();

		void Read( BOOL );
		void Write( BOOL );
		void Execute( BOOL );
		void Delete( BOOL );
		void Syncronize( BOOL );
		void ModifyRights( BOOL );
		void ModifyState( BOOL );
	};

#endif

