/* **************************************************************************
*                                                                           *
*  Thread.H                                                                 *
*                                                                           *
*  30-01-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per a la gesti dels fluxos                                       *
*                                                                           *
************************************************************************** */

#ifndef _THREAD_H
#define _THREAD_H

#include "kernel\type.h"

_CLASSDEF( CThread )

#include "sys\private\resource.h"
#include "sys\private\pcb.h"

class CThread : public CResource
	{
	protected:
	public:
		CThread( PVOID = NULL );
		virtual ~CThread();

		virtual BOOL ClassCheck( CUID );

		DWORD ErrorCode();

		DWORD KernelTime();
		DWORD UserTime();

		VOID ErrorCode( DWORD );

		PCkeThread NextInProc();
		PCkeThread PrevInProc();
		PCkeThread NextInAll();
		PCkeThread PrevInAll();

		VOID NextInProc( PCkeThread );
		VOID PrevInProc( PCkeThread );
		VOID NextInAll( PCkeThread );
		VOID PrevInAll( PCkeThread );

		BYTE Priority();
		VOID Priority( BYTE );

		PCProcess Process();
		DWORD CreationTime();

		DWORD ExitStatus();
		VOID Exit( DWORD );
	};

#endif

