/* **************************************************************************
*                                                                           *
*  Types.H                                                                  *
*                                                                           *
*  21-01-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Definici dels tipus de dades generals                                   *
*                                                                           *
************************************************************************** */

#ifndef _TYPES_H
#define _TYPES_H

// Arrodonim n segons la granularitat especificada per s (una potncia de 2)
#define ROUND_UP(n,s) (((DWORD)(n)+(s)-1)&~((s)-1))

// -- Exportem si estem construnt el kernel
#ifdef _BUILDKERNEL_
	#define EXPKERNEL		_export
#else
	#define EXPKERNEL		_import
#endif
// --

// -- Exportem si estem construnt l'AAL
#ifdef _BUILDAAL_
	#define EXPAAL		_export
#else
	#define EXPAAL		_import
#endif
// --

// -- Definicions molt tils
#ifndef NULL
	#define NULL	0
#endif

#ifndef FALSE
	#define FALSE	(BOOL) 0
	#define TRUE	(BOOL) 1
#endif
// --

// -- Si no hem fet #include <windows.h>
#ifndef __WINDOWS_H
// --- Per a headers.h
#define UNALIGNED
#define NTAPI
#define BOOLEAN			BOOL
#define CONST				const
// ---

// --- Tipus bsics
typedef void				VOID;
typedef unsigned char	BOOL;
typedef unsigned char	BYTE;
typedef unsigned short	WORD;
typedef unsigned int    UINT;
typedef short				SHORT;
typedef unsigned long	DWORD;
typedef long				LONG;
// ---

// --- Apuntadors a tipus bsics
typedef VOID	*PVOID;
typedef BYTE	*PBYTE;
typedef WORD	*PWORD;
typedef SHORT	*PSHORT;
typedef DWORD	*PDWORD;
typedef LONG	*PLONG;
// ---

// --- Obtenir un BYTE des d'un WORD/DWORD
#define LOBYTE(w)           ((BYTE)(w))
#define HIBYTE(w)           ((BYTE)((UINT)(w) >> 8))
// ---

// --- Obtenir un WORD des d'un DWORD
#define LOWORD(l)           ((WORD)(l))
#define HIWORD(l)           ((WORD)((DWORD)(l) >> 16))
// ---

// Uneix dos WORDs en un DWORD
#define MAKELONG(low, high) ((LONG)(((WORD)(low)) | (((DWORD)((WORD)(high))) << 16)))

// Transforma adreces de segment:offset16 a offset32
#define MK_32P(high, low)	 ((DWORD) ((WORD)(low)) + ((DWORD) ((WORD)(high)) << 4))


// --- Serveis per a UNICODE
// wchar_t es un tipus del C++ per a carcters de 16bits
typedef wchar_t	WCHAR;
typedef BYTE		ACHAR;

// ---- Apuntadors a tipus carcters (de 8 i 16bits)
typedef WCHAR *PWCHAR;
typedef WCHAR *PWSTR;
typedef WCHAR *WSTR;
typedef ACHAR *PACHAR;
typedef ACHAR *PASTR;
typedef ACHAR *ASTR;
// ----

// Les cadenes de carcters UNICODE comencen amb L##
#define WTEXT(quote)	L##quote
#define ATEXT(quote)	(ASTR) quote

// ---- Si utilitzem UNICODE
#ifdef UNICODE
typedef PWCHAR	PCHAR;
typedef PWSTR	PSTR;
typedef WCHAR	CHAR;
#define TEXT(quote) L##quote
// si utilitzem ASCII
#else
typedef PACHAR	PCHAR;
typedef PASTR	PSTR;
typedef ACHAR	CHAR;
#define TEXT(quote) (ASTR) quote
#endif	/* UNICODE */
// ---

#endif	/* _WINDOWS_H */
// --

// CUID s el Class Unique IDentifier
typedef DWORD	CUID;
typedef CUID	*PCUID;

// -- Si no hem fet #include <_defs.h> (de Borland)
#ifndef _PTRDEF
#define _PTRDEF(name) typedef name * P##name;
#define _REFDEF(name) typedef name & R##name;
#define _REFPTRDEF(name) typedef name * & RP##name;
#define _PTRCONSTDEF(name) typedef const name * PC##name;
#define _REFCONSTDEF(name) typedef const name & RC##name;

#define _CLASSDEF(name) class name; \
			  _PTRDEF(name) \
			  _REFDEF(name) \
			  _REFPTRDEF(name) \
			  _PTRCONSTDEF(name) \
			  _REFCONSTDEF(name)
#endif	/* _PTRDEF */

#define _KERNELEXP(name) class EXPKERNEL name; \
			  _PTRDEF(name) \
			  _REFDEF(name) \
			  _REFPTRDEF(name) \
			  _PTRCONSTDEF(name) \
			  _REFCONSTDEF(name)

#define _AALEXP(name) class EXPAAL name; \
			  _PTRDEF(name) \
			  _REFDEF(name) \
			  _REFPTRDEF(name) \
			  _PTRCONSTDEF(name) \
			  _REFCONSTDEF(name)
// --

// -- Utilitats per a depuraci
#ifdef _DEBUG
extern DWORD EXPKERNEL DebugLevel;
#define CHECK_CLASS(o, c, s)	if( !(o->ClassCheck( c )) )\
											(System->Debug())->CheckPanic( o, c, s )
#define TRACE(s)					(System->Debug())->Trace( s )
#else
#define CHECK_CLASS(o, c, s)
#define TRACE(s)
#endif	/* _DEBUG */
// --

// Cridar el mtode adent del 'mutex' especificat
#define ENTER_CRITICAL_SECTION( o )	o->Wait()
#define LEAVE_CRITICAL_SECTION( o )	o->Release()

// Estructura de les dades passades com a segon parmetre en molts missatges
typedef struct _Data
	{
	DWORD dwParam1;
	DWORD dwParam2;
	DWORD dwParam3;
	DWORD dwParam4;
	} TData, *PTData;

#endif

