;
;    Extensor de modo real a modo protejido para usar con Watcom C/C++
;          Los ejecutables se pueden utilizar sin MS-DOS
;
;                Realizado por Daniel Lancha Garcia
;

.386p

 INCLUDE EXTENSOR.INC

        EXTRN _Ext_MSDOS:WORD,_Ext_CPU:BYTE,_Ext_DSP_DS:WORD,_Ext_DSP:WORD
        EXTRN VIDEO_MODE:BYTE,VIDEO_PAG:BYTE,LED_BLOQ:BYTE,LED_NUM:BYTE
        EXTRN LED_CAPS:BYTE,GDT_BL:FWORD,IDT_BL:FWORD,OLD_IDT_BL:FWORD
        EXTRN OLD_GDT_BL:FWORD,INT_MASK:BYTE,Mensaje0:BYTE,Error_Salida:BYTE
        EXTRN Mensaje5:BYTE,ERROR_EAX:DWORD,ERROR_EBX:DWORD,ERROR_ECX:DWORD
        EXTRN ERROR_EDX:DWORD,ERROR_ESI:DWORD,ERROR_EDI:DWORD,ERROR_ESP:DWORD
        EXTRN ERROR_EBP:DWORD,ERROR_CR0:DWORD,ERROR_CR2:DWORD,ERROR_CR3:DWORD
        EXTRN ERROR_EFLAGS:DWORD,ERROR_EIP:DWORD,ERROR_CS:WORD,ERROR_SS:WORD
        EXTRN ERROR_DS:WORD,ERROR_ES:WORD,ERROR_FS:WORD,ERROR_GS:WORD
        EXTRN INICIO_GDT:DWORD,INICIO_IDT:DWORD
        EXTRN MensajeExcepcion:BYTE,MensajeError0:BYTE,MensajeError:BYTE
        EXTRN Mensaje6:BYTE,Mensaje7:BYTE,Mensaje8:BYTE,Mensaje9:BYTE
        EXTRN INICIO_PILA:DWORD,INICIO_DATOS:DWORD,INT2_MASK:BYTE
        EXTRN INICIO_IDT:DWORD,INICIO_CODIGO32:DWORD,GDT_CS32:DWORD
        EXTRN GDT_GDT:DWORD,GDT_CS:DWORD,GDT_SS:DWORD,GDT_DS:DWORD
        EXTRN GDT_IDT:DWORD:DWORD,GDT_REAL_DS:DWORD,SELECTOR_REAL_DS:ABS
        EXTRN FIN_PILA:DWORD,FIN_DATOS:DWORD,FIN_IDT:DWORD
        EXTRN FIN_CODIGO32:DWORD,FIN_GDT:DWORD
        EXTRN SELECTOR_CS:ABS,SELECTOR_DS:ABS,SELECTOR_SS:ABS,GDT_DMA:DWORD
        EXTRN SELECTOR_DUMMY_TSS:ABS,DUMMY_TSS:DWORD,GDT_DUMMY_TSS:DWORD
        EXTRN START32_TSS:DWORD,GDT_START32_TSS:DWORD,SELECTOR_START32_TSS:ABS
        EXTRN _Ext_KEYBOARD_BLOQ:BYTE,_Ext_KEYBOARD_NUM:BYTE
        EXTRN _Ext_KEYBOARD_CAPS:BYTE,Ext_keyboardleds_:PROC
        EXTRN Ext_settimer_:PROC,SELECTOR_CS32:ABS
        EXTRN INICIO_PILA_INT:DWORD,FIN_PILA_INT:DWORD
        EXTRN GDT_PILA_INT:DWORD,GDT_TIMER_TSS:DWORD
        EXTRN TASK_TSS:DWORD,TIMER_TSS:DWORD,SELECTOR_DMA:DWORD
        EXTRN _Ext_MEM:DWORD,Mensaje10:BYTE,TablaMemBase:DWORD
        EXTRN SELECTOR_MEMBASE:ABS,SELECTOR_DPMI:ABS,GDT_LDT:DWORD
        EXTRN GDT_DPMI:DWORD,BASE_DPMI:WORD
        EXTRN Mensaje11:BYTE,Mensaje12:BYTE,Mensaje13:BYTE,Mensaje14:BYTE
        EXTRN SELECTOR_TIMER:ABS,GDT_TIMER:DWORD,BASE_TAREA:WORD
        EXTRN GDT_CAMBIO:DWORD
        EXTRN GDT_TSS32:DWORD,BASE_LDT:WORD,GDT_LDT32:DWORD
        EXTRN GDT_TASK_TSS:DWORD,GDT_TASK:DWORD,FIN_PILA_TASK:DWORD
        EXTRN INICIO_PILA_TASK:DWORD,GDT_PILA_TASK:DWORD,FIN_TSSs:DWORD
        EXTRN DATA_PAGES:DWORD,ADD_DATA_PAGE:DWORD

        PUBLIC Inicio,RetornoReal



Pila SEGMENT  USE16 PARA STACK 'STACK'
        db        LONGITUD_PILA_REAL dup('PILA')
Pila ENDS


        ASSUME CS:Codigo,SS:Pila

Codigo SEGMENT USE16
INICIO_CODIGO LABEL WORD
Inicio PROC
        call    GuardarDSP          ; Inicia DS y guarda DSP
        call    ConseguirLEDs       ; Consigue los LEDs del teclado
        call    ConseguirModoVideo  ; Modo de video original
        call    MSDOS               ; Detectar MSDOS y rehacer DSP
        call    Verifica_CPU        ; Verificar si la CPU y su modo
        call    ConseguirMemoria    ; Abre A20 y consigue memoria libre
        call    IniciaPaginado      ; Inicia paginas
        call    MoverPaginasDatos   ; Traslada las paginas de datos
        call    SumarPaginasMemBase ; Traslada las paginas de memoria base
        call    CompletarDescriptores ; Base y Limite de los descriptores
        call    CompletarTSSs       ; Inicia los TSSs principales ( CR3 )
  ; Pasar a modo protejido
        CargarGDT GDT_BL
        cli
        CargarIDT IDT_BL
        IRQs_Protejido PICA,INT_MASK,40h
;        IRQs_Protejido PICB,INT2_MASK,50h
        ActivarBitProtejido
        Salto16_16  SELECTOR_CS,Protejido ; Salto FAR para cargar CS protejido
  ; Ya en modo protejido        
Protejido:
        mov        ax,offset SELECTOR_DUMMY_TSS
        ltr        ax
        Salto16_TSS SELECTOR_START32_TSS
 ; Pasar a Modo Real
RetornoReal:
        sti
        mov     ax,offset SELECTOR_REAL_DS  ; Poner Selectores correctos
        mov     ds,ax
        mov     ax,offset SELECTOR_SS
        mov     ss,ax
        mov     esp,LONGITUD_PILA * 8
        mov     al,LED_BLOQ                ; Restaurar LEDs
        mov     _Ext_KEYBOARD_BLOQ,al
        mov     al,LED_NUM
        mov     _Ext_KEYBOARD_NUM,al
        mov     al,LED_CAPS
        mov     _Ext_KEYBOARD_CAPS,al
        Llamada16_32 SELECTOR_CS32,Ext_keyboardleds_
        mov     eax,-1                     ; Reponer timer freq
        Llamada16_32 SELECTOR_CS32,Ext_settimer_
        cli                        ; Desactivar Interrupciones
        CargarIDT OLD_IDT_BL       ; Cargar antigua IDT 
        mov     ax,ds           ; Sementos con limite 0xFFFFh -> Modo Real
        mov     es,ax             
        mov     ss,ax
        mov     fs,ax
        mov     gs,ax
        DesactivarBitProtejido
        Salto16_16 Codigo,Real     ; Salto FAR para cargar CS real
  ; Ya en modo Real
Real:
        cli
        mov     ax,Pila           ; Iniciar Registros
        mov     ss,ax
        mov     sp,LONGITUD_PILA_REAL * 4
        mov     ax,seg INICIO_DATOS
        mov     ds,ax
        CargarGDT OLD_GDT_BL      ; Cargar antigua GDT
        IRQs_Real PICA,INT_MASK,08h   ; Activar IRQs 0-7
;        IRQs_Real PICB,INT2_MASK,70h  ; Activar IRQs 8-15
        sti
        xor     eax,eax
        jmp     Fin              ; Salir del Extensor
Inicio ENDP        

;       /////// PROCEDIMENTOS \\\\\\\\
;
; Mensaje             : DS:DX = Mensaje a salir por pantalla
; VisualizaBYTE       : AL = Byte a visualizar
; VisualizaWORD       : AX = Word a visualizar
; VisualizaDWORD      : EAX = Dword a visualizar
; VisualizaHEX        : Visualiza '0x' como en C++
; VisualizaFinLinea   : Salto de linea y vuelta de carro
; VisualizaEspacios   : Visualiza ' ,    ' para excepciones
; Visualiza_Rejistros : Visualiza los rejistros guardados en las variables
; Detectar_CPU        : Devuelve en CX el tipo de micro (2)86,(3)86,(4)86...
; ConseguirLEDs       : Recoje en variables booleanas los LEDs del teclado
; Fin                 : AX = Codigo de Salida

Mensaje PROC NEAR                ; DS:DX = Mensaje
        push      ax
        mov       ah,9
        int       21h
        pop       ax
        ret
Mensaje ENDP

VisualizaBYTE PROC
        push      dx
        push      ax
        mov       dx,ax
        mov       dh,dl
        and       dl,11110000b
        shr       dl,4
        cmp       dl,9
        jg        VisualizaBYTE_1
        sub       dl,7
 VisualizaBYTE_1:
        add       dl,'A'-10
        mov       ah,2
        int       21h
        mov       dl,dh
        and       dl,00001111b
        cmp       dl,9
        jg        VisualizaBYTE_2
        sub       dl,7
 VisualizaBYTE_2:
        add       dl,'A'-10
        int       21h
        pop       ax
        pop       dx
        ret
VisualizaBYTE ENDP


VisualizaWORD PROC
        xchg      ah,al
        call      VisualizaBYTE
        xchg      al,ah
        call      VisualizaBYTE
        ret
VisualizaWORD ENDP


VisualizaDWORD PROC
        rol      eax,16
        call     VisualizaWORD
        ror      eax,16
        call     VisualizaWORD
        ret
VisualizaDWORD ENDP

VisualizaFinLinea PROC
        push     ax
        push     dx
        mov      dl,10
        mov      ah,2
        int      21h
        mov      dl,13
        int      21h
        pop      dx
        pop      ax
        ret
VisualizaFinLinea ENDP

VisualizaEspacios PROC
        push      ax
        push      dx
        push      cx
        mov       dl,' '
        mov       ah,2h
        int       21h
        mov       dl,','
        int       21h
        mov       dl,' '
        mov       cx,2
 VisualizaEspacios_otra:        
        int       21h
        loop      VisualizaEspacios_otra
        pop       cx
        pop       dx
        pop       ax
        ret
VisualizaEspacios ENDP

VisualizaHEX PROC
        push      ax
        push      dx
        mov       dl,'0'
        mov       ah,2
        int       21h
        mov       dl,'x'
        int       21h
        pop       dx
        pop       ax
        ret
VisualizaHEX ENDP

Visualiza_Rejistros PROC
        push     ds
        push     ax
        push     dx
        push     bx
        mov      ax,seg INICIO_DATOS
        mov      ds,ax
        call     VisualizaFinLinea
        call     VisualizaFinLinea
        mov      dx,offset Mensaje5
        mov      bx,dx
        inc      bx
        mov      byte ptr ds:[bx],'A'
        mov      byte ptr ds:1[bx],'X'
        call     Mensaje
        call     VisualizaHEX
        mov      eax,ERROR_EAX
        call     VisualizaDWORD
        call     VisualizaEspacios
        mov      byte ptr ds:[bx],'B'
        call     Mensaje
        call     VisualizaHEX
        mov      eax,ERROR_EBX
        call     VisualizaDWORD
        call     VisualizaEspacios
        mov      byte ptr ds:[bx],'C'
        call     Mensaje
        call     VisualizaHEX
        mov      eax,ERROR_ECX
        call     VisualizaDWORD
        call     VisualizaEspacios
        mov      byte ptr ds:[bx],'D'
        call     Mensaje
        call     VisualizaHEX
        mov      eax,ERROR_EDX
        call     VisualizaDWORD
        call     VisualizaFinLinea
        mov      byte ptr ds:1[bx],'I'
        mov      byte ptr ds:[bx],'D'
        call     Mensaje
        call     VisualizaHEX
        mov      eax,ERROR_EDI
        call     VisualizaDWORD
        call     VisualizaEspacios
        mov      byte ptr ds:[bx],'S'
        call     Mensaje
        call     VisualizaHEX
        mov      eax,ERROR_ESI
        call     VisualizaDWORD
        call     VisualizaEspacios
        mov      byte ptr ds:1[bx],'P'
        call     Mensaje
        call     VisualizaHEX
        mov      eax,ERROR_ESP
        call     VisualizaDWORD
        call     VisualizaEspacios
        mov      byte ptr ds:[bx],'B'
        call     Mensaje
        call     VisualizaHEX
        mov      eax,ERROR_EBP
        call     VisualizaDWORD
        call     VisualizaFinLinea
        mov      dx,offset Mensaje6
        mov      bx,dx
        mov      byte ptr ds:[bx],'D'
        call     Mensaje
        call     VisualizaHEX
        mov      ax,ERROR_DS
        call     VisualizaWORD
        call     VisualizaEspacios
        mov      byte ptr ds:[bx],'E'
        call     Mensaje
        call     VisualizaHEX
        mov      ax,ERROR_ES
        call     VisualizaWORD
        call     VisualizaEspacios
        mov      byte ptr ds:[bx],'F'
        call     Mensaje
        call     VisualizaHEX
        mov      ax,ERROR_FS
        call     VisualizaWORD
        call     VisualizaEspacios
        mov      byte ptr ds:[bx],'G'
        call     Mensaje
        call     VisualizaHEX
        mov      ax,ERROR_GS
        call     VisualizaWORD
        call     VisualizaEspacios
        mov      byte ptr ds:[bx],'S'
        call     Mensaje
        call     VisualizaHEX
        mov      ax,ERROR_SS
        call     VisualizaWORD
        call     VisualizaFinLinea
        mov      dx,offset Mensaje9
        mov      bx,dx
        add      bx,5
        mov      byte ptr ds:[bx],'0'
        call     Mensaje
        call     VisualizaHEX
        mov      eax,ERROR_CR0
        call     VisualizaDWORD
        call     VisualizaEspacios
        mov      byte ptr ds:[bx],'2'
        call     Mensaje
        call     VisualizaHEX
        mov      eax,ERROR_CR2
        call     VisualizaDWORD
        call     VisualizaEspacios
        mov      byte ptr ds:[bx],'3'
        call     Mensaje
        call     VisualizaHEX
        mov      eax,ERROR_CR3
        call     VisualizaDWORD
        call     VisualizaFinLinea
        mov      dx,offset Mensaje7
        call     Mensaje
        call     VisualizaHEX
        mov      ax,ERROR_CS
        call     VisualizaWORD
        mov      dl,':'
        mov      ah,2
        int      21h
        call     VisualizaHEX
        mov      eax,ERROR_EIP
        call     VisualizaDWORD
        call     VisualizaEspacios
        mov      dx,offset Mensaje8
        call     Mensaje
        call     VisualizaHEX
        mov      eax,ERROR_EFLAGS
        call     VisualizaDWORD
        call     VisualizaFinLinea
        call     VisualizaFinLinea
        pop      bx
        pop      dx
        pop      ax
        pop      ds
        ret
Visualiza_Rejistros ENDP

Detectar_CPU PROC NEAR            ; CX = procesador:(2)86,(3)86,(4)86,(5)86
        push ax
        push bx
        xor cx,cx                 ; Tipo 0 por defecto
        pushf                     ; BX = FLAGS
        pop bx
        mov ax,bx                 ; Intentar limpiar 4 bits de mas peso
        and ah,0fh
        push ax                   ; FLAGS = AX
        popf
        pushf                     ; AX = FLAGS 
        pop ax
        and ah,0f0h               ; Se han limpiado ?
        cmp ah,0f0h
        je short Detectar_CPU_Ok  ; Si no es asi CPU = 8086/8
        mov cl,2                  ; Tipo 2 por defecto
        or bh,0f0h                ; Intentar Activar 4 bits de mas peso
        push bx                   ; FLAGS = BX 
        popf
        pushf                     ; AX =  FLAGS
        pop ax
        and ah,0f0h               ; Se han activado ?
        jz short Detectar_CPU_Ok  ; Si no es asi CPU = 80286
        inc cx                    ; Tipo 3 por defecto
        push eax                  ; Salvar registros 32bit
        push ebx     
        pushfd                    ; EBX = EFLAGS
        pop ebx
        mov eax,ebx               ; Intentar cambiar bit AC
        xor eax,40000h
        push eax                  ; EFLAGS = EAX
        popfd
        pushfd                    ; EAX = EFLAGS
        pop eax
        xor eax,ebx               ; Ha cambiado el bit AC ?
        jz short Detectar_CPU_Ok2 ; Si no es asi CPU = 386
        inc cx                    ; Tipo 4 por defecto
        mov eax,ebx               ; Intentar cambiar bit ID
        xor eax,200000h
        push eax                  ; EFLAGS = EAX
        popfd
        pushfd                    ; EAX = EFLAGS
        pop eax
        xor eax,ebx               ; Ha cambiado el bit ID ?
        jz short Detectar_CPU_Ok2 ; Si no es asi CPU = 486
        inc cx                    ; CPU = 586
Detectar_CPU_Ok2:
        pop ebx                   ; Restaurar registros 32bit
        pop eax    
Detectar_CPU_Ok:
        pop bx
        pop ax
        xor       ch,ch
        ret                       ; Salir
Detectar_CPU ENDP


ActivarA20 PROC NEAR                ; Habilitar la linea A20 
        pushf
        push        fs
        push        gs
        cli
        xor         ax,ax
        mov         fs,ax
        dec         ax
        mov         gs,ax
        call        ActivarA20_test
        jz  short   ActivarA20_fin
        in          al,92h
        or          al,2
        jmp short   $+2
        jmp short   $+2
        jmp short   $+2
        out         92h,al
        call        ActivarA20_test
        jz  short   ActivarA20_fin
        call        ActivarA20_espera
        jnz short   ActivarA20_intenta
        mov         al,0d1h
        out         64h,al
        call        ActivarA20_espera
        jnz short   ActivarA20_intenta
        mov         al,0dfh
        out         60h,al
        call        ActivarA20_espera
 ActivarA20_intenta:
        mov         ecx,800h
 ActivarA20_otra:
        call        ActivarA20_test
        jz  short   ActivarA20_fin
        in          al,40h
        jmp short   $+2
        jmp short   $+2
        jmp short   $+2
        in          al,40h
        mov         ah,al
 ActivarA20_tick:
        in          al,40h        
        jmp short   $+2
        jmp short   $+2
        jmp short   $+2
        in          al,40h
        cmp         al,ah
        je short    ActivarA20_tick
        loop        ActivarA20_otra
        mov         ax,-1
        jmp short   ActivarA20_salida
 ActivarA20_fin:
        xor         ax,ax
 ActivarA20_salida:
        pop         gs
        pop         fs
        popf
        ret
 ActivarA20_espera:
        xor         ecx,ecx
 ActivarA20_espera_otra:        
        jmp short   $+2
        jmp short   $+2
        jmp short   $+2
        in          al,64h
        test        al,2
        loopnz      ActivarA20_espera_otra
        ret
 ActivarA20_test:
        mov         al,fs:[0]
        mov         ah,al
        not         al
        xchg        al,gs:[10h]
        cmp         ah,fs:[0]
        mov         gs:[10h],al
        ret                
ActivarA20 ENDP

CalculaMemo PROC NEAR
        xor        eax,eax
        mov        ah,88h
        int        15h
        or         ax,ax
        jz         memo_error
        and        ax,0FC00h
        movzx      eax,ax
        shl        eax,10
        add        eax,100000h
 memo_error:
        ret
CalculaMemo ENDP

LeerMemoBase PROC NEAR
        push       ebx
        mov        ebx,ecx
        dec        ebx
        shl        ebx,2
        xor        eax,eax
        xor        edi,edi
        mov        ax,ds:[esi+ebx]
        mov        di,ds:[esi+ebx+2]
        pop        ebx
        ret
LeerMemoBase ENDP

EscribirMemoBase PROC NEAR
        push       ebx
        mov        ebx,ecx
        dec        ebx
        shl        ebx,2
        mov        ds:[esi+ebx],ax
        mov        ds:[esi+ebx+2],di
        pop        ebx
        ret
EscribirMemoBase ENDP


ChocaMemoBase PROC NEAR
        push       ecx
        add        ebx,edx
        mov        ecx,LONG_BASE_MEM
 ChocaMemoBase_otra:
        call       LeerMemoBase
        test       edi,edi
        jz         ChocaMemoBase_noVale
        add        edi,eax
        cmp        eax,edx
        jg         ChocaMemoBase_otroCaso
        je         ChocaMemoBase_choca
        cmp        edi,edx
        jle        ChocaMemoBase_noVale
 ChocaMemoBase_choca:        
        pop        ecx
        ret
 ChocaMemoBase_otroCaso:
        cmp        eax,ebx
        jl         ChocaMemoBase_choca        
 ChocaMemoBase_noVale:
        loop       ChocaMemoBase_otra
        xor        edi,edi
        mov        eax,edx
        pop        ecx
        ret
ChocaMemoBase ENDP

LibreMemoBase PROC NEAR
        push       ebx
        mov        ecx,LONG_BASE_MEM
        mov        ebx,ecx
        dec        ebx
        shl        ebx,2
 LibreMemoBase_otra:
        test word ptr ds:[esi+ebx+2],0ffffh
        jz         LibreMemoBase_sal
        sub        ebx,4
        loop       LibreMemoBase_otra
 LibreMemoBase_sal:        
        pop        ebx
        ret
LibreMemoBase ENDP

ReservaMemoBase PROC NEAR
        push       ds
        push       edi
        push       esi
        push       ecx
        push       edx
        push       ebx
        movzx      edx,_Ext_DSP_DS
        add        dx,_Ext_DSP
        mov        ax,seg TablaMemBase
        mov        ds,ax
        mov        esi,offset TablaMemBase
        mov        ecx,LONG_BASE_MEM 
 ReservaMemoBase_otra:
        call       ChocaMemoBase
        test       edi,edi
        jz         ReservaMemoBase_bien
        cmp        edi,09000h
        jge        ReservaMemoBase_mal
        mov        edx,edi
        loop       ReservaMemoBase_otra
 ReservaMemoBase_mal:
        xor        eax,eax
        pop        ebx
        jmp short  ReservaMemoBase_salir
 ReservaMemoBase_bien:
        call       LibreMemoBase
        test       ecx,ecx
        jz         ReservaMemoBase_mal
        pop        edi
        call       EscribirMemoBase
        mov        ebx,edi
 ReservaMemoBase_salir:
        pop        edx
        pop        ecx
        pop        esi
        pop        edi
        pop        ds
        ret
ReservaMemoBase ENDP

LiberaMemoBase PROC
        push       ebx 
        push       ecx
        push       ds
        mov        bx,seg TablaMemBase
        mov        ds,bx
        mov        esi,offset TablaMemBase
        mov        ebx,LONG_BASE_MEM-1
        shl        ebx,2
        mov        ecx,LONG_BASE_MEM
 LiberaMemoBase_otra:
        cmp word ptr ds:[esi+ebx],ax
        je         LiberaMemoBase_bien
        sub        ebx,4
        loop       LiberaMemoBase_otra
        mov        eax,-1
        jmp short        LiberaMemoBase_salir
 LiberaMemoBase_bien:
        mov dword ptr ds:[esi+ebx],0
 LiberaMemoBase_salir:        
        pop        ds
        pop        ecx
        pop        ebx
        ret
LiberaMemoBase ENDP

GuardarDSP PROC
        mov     ax,ds
        mov     bx,seg INICIO_DATOS        ; Inicia segmento de datos a DS
        mov     ds,bx
        mov     _Ext_DSP_DS,ax        ; Guardar DSP
        mov     es,ax
        mov     ax,es:[4]
        inc     ax
        mov     cx,512 / 16
        mul     cx
        mov     _Ext_DSP,ax           ; Guardar parrafos del DSP ( programa )
        mov     dx,offset Mensaje0
        call    Mensaje               ; Mensaje de entrada
        ret
GuardarDSP ENDP

ConseguirLEDs PROC NEAR
        pusha
        push    ds
        mov     dx,40h        ; Conseguir LEDs
        mov     ds,dx
        mov     al,ds:[17h]
        mov     bl,al
        shr     bl,1
        shr     bl,1
        shr     bl,1
        shr     bl,1
        mov     ax,seg INICIO_DATOS
        mov     ds,ax
        mov     ax,0ff00h
        mov     bh,bl
        and     bh,1
        jz      ConseguirLedBloq
        xchg    ah,al
 ConseguirLedBloq:
        mov     LED_BLOQ,al
        mov     ax,0ff00h
        mov     bh,bl
        and     bh,2
        jz      ConseguirLedNum
        xchg    ah,al
 ConseguirLedNum:
        mov     LED_NUM,al
        mov     ax,0ff00h
        mov     bh,bl
        and     bh,4
        jz      ConseguirLedCaps
        xchg    ah,al
 ConseguirLedCaps:
        mov     LED_CAPS,al
        pop     ds
        popa
        ret
ConseguirLEDs ENDP

ConseguirModoVideo PROC NEAR
        push    ds
        pusha
        mov     ax,seg INICIO_DATOS
        mov     ds,ax
        mov     ah,0fh                ; Conseguir Modo de video
        int     10h
        mov     VIDEO_MODE,al
        mov     VIDEO_PAG,bh
        popa
        pop     ds        
        ret
ConseguirModoVideo ENDP

MSDOS PROC NEAR
        push    dx
        mov     ax,3000h
        int     21h        ; MS-DOS ?
        cmp     ax,0ffffh
        je      MSDOS_No
        mov     _Ext_MSDOS,ax          ; Con MS-DOS
        push    bx
        mov     bx,seg FIN_TSSs
        sub     bx,_Ext_DSP_DS
        push    ax
        mov     ax,offset FIN_TSSs
        shr     ax,4
        inc     ax
        add     bx,ax
        pop     ax
        mov     _Ext_DSP,bx         ; Poner parrafos del EXE en DSP
        pop     bx
        mov     dx,offset Mensaje14
        call    mensaje
        pop     dx
        ret
 MSDOS_No:
        mov     _Ext_MSDOS,0        ; Sin MS-DOS
        mov     dx,offset Mensaje13
        call    mensaje
        pop     dx
        ret
MSDOS ENDP

Verifica_CPU PROC NEAR
        push    cx
        call    Detectar_CPU
        mov     Error_Salida,1
        cmp     cx,2                ; Mayor que un 286?
        jng     Fin                ; Si menor salir con error
        mov     _Ext_CPU,cl
        mov     Error_Salida,2
        mov     ax,4300h
        int     2fh                 ; Driver XMS ?
        cmp     al,80h
        jz      Fin                 ; Si existe salir con error
        mov     Error_Salida,3
        pushfd                   ; push 32bit flags
        pop     eax              ; pop en eax
        test    eax,20000h       ; Comprobar bit 17 (VM)
        jnz     Fin              ; Si Modo V86 salir con error
        mov     Error_Salida,0
        push    dx
        mov     dx,offset Mensaje12
        mov     cl,_Ext_CPU      ; Mostrar CPU por pantalla
        add     cl,'0'
        push    bx
        mov     bx,dx
        mov     ds:[bx+8],cl
        pop     bx
        call    Mensaje
        pop     dx
        pop     cx
        ret
Verifica_CPU ENDP

ConseguirMemoria PROC NEAR
        call    ActivarA20
        mov     Error_Salida,0fh
        or      ax,ax            ; Se inicializo la linea A20 del micro
        jnz     Fin              ; No , error
        mov     Error_Salida,10h
        call    CalculaMemo      ; Calcula memoria del sistema
        test    eax,eax
        jz      Fin              ; Si no se pudo error
        mov     _Ext_MEM,eax
        mov     Error_Salida,4
        push    eax
        push    dx
        mov     dx,offset Mensaje10     ; Mostrar la memoria por pantalla
        call    Mensaje
        pop     dx
        call    VisualizaHEX
        pop     eax
        call    VisualizaDWORD
        mov     dx,offset Mensaje11
        call    Mensaje
        mov     bx,LONG_TABLA_MEM / 2  ; Hacer Tabla DPMI
        call    ReservaMemoBase
        test    ax,ax
        jz      Fin
        mov     BASE_DPMI,ax
        mov     bx,LONGITUD_CAMBIO / 8 ; Hace Tabla Tareas
        call    ReservaMemoBase
        test    ax,ax
        jz      Fin
        mov     BASE_TAREA,ax
        mov     bx,LONG_LDT / 2        ; Hacer LDT principal
        call    ReservaMemoBase
        test    ax,ax
        jz      Fin
        mov     BASE_LDT,ax
        mov     Error_Salida,0
        push    es
        mov     es,ax
        xor     eax,eax
        xor     edi,edi
        mov     ecx,LONG_LDT * 2
        cld
        rep     stosd
        mov     es,BASE_DPMI
        xor     edi,edi
        mov     ecx,LONG_TABLA_MEM * 2
        rep     stosd
        mov     es,BASE_TAREA
        xor     edi,edi
        mov     ecx,LONGITUD_CAMBIO / 2
        rep     stosd
        pop     es
        ret
ConseguirMemoria ENDP

CompletarDescriptores PROC NEAR
        push     es
        push     esi
        push     edi
        mov      ax,seg INICIO_GDT
        mov      es,ax
        DescargarGDT OLD_GDT_BL
        Poner_Base INICIO_CODIGO,GDT_CS
        Poner_Base INICIO_GDT,GDT_GDT
        Poner_Base4 ADD_DATA_PAGE,GDT_DS
        Poner_Base3 INICIO_DATOS,GDT_REAL_DS
        Poner_Base3 INICIO_PILA,GDT_SS
        Poner_Base INICIO_IDT,GDT_IDT
        Poner_Base3 INICIO_CODIGO32,GDT_CS32
        Poner_Base DUMMY_TSS,GDT_DUMMY_TSS
        Poner_Base START32_TSS,GDT_START32_TSS
        Poner_Base START32_TSS,GDT_TSS32
        Poner_Base TASK_TSS,GDT_TASK_TSS
        Poner_Base TASK_TSS,GDT_TASK
        Poner_Base TIMER_TSS,GDT_TIMER_TSS
        Poner_Base TIMER_TSS,GDT_TIMER
        Poner_Base INICIO_PILA_TASK,GDT_PILA_TASK
        Poner_Base INICIO_PILA_INT,GDT_PILA_INT
        Poner_Base2 BASE_DPMI,GDT_DPMI
        Poner_Base2 BASE_TAREA,GDT_CAMBIO
        Poner_Base2 BASE_LDT,GDT_LDT
        Poner_Base2 BASE_LDT,GDT_LDT32
        Poner_Limite2 GDT_DS
     TMP = OFFSET FIN_GDT
        Poner_Limite TMP,GDT_GDT
     TMP = OFFSET FIN_IDT
        Poner_Limite TMP,GDT_IDT
     TMP = OFFSET FIN_PILA ;Variable temporal para que no de errores la MACRO
        Poner_Limite TMP,GDT_SS
     TMP = OFFSET FIN_CODIGO32
        Poner_Limite TMP,GDT_CS32
     TMP = OFFSET FIN_PILA_INT
        Poner_Limite TMP,GDT_PILA_INT
     TMP = OFFSET FIN_PILA_TASK
        Poner_Limite TMP,GDT_PILA_TASK
  ; Hacer la variable BASE-LIMITE para poderlos cargarlos en el GDT e IDT
     TMP = OFFSET FIN_GDT 
        Hacer_BL INICIO_GDT,TMP,GDT_BL
     TMP = OFFSET FIN_IDT
        Hacer_BL INICIO_IDT,TMP,IDT_BL
        pop      edi
        pop      esi
        pop      es
        ret
CompletarDescriptores ENDP

IniciaPagina PROC NEAR  
        push     edx
        push     ecx
        cld
 IniciaPagina_otra:
        stosd
        add      eax,1000h
        loop     IniciaPagina_otra        
        pop      edx
        push     edx
        mov      ecx,1024
        sub      ecx,edx
        jz       IniciaPagina_salir
        xor      eax,eax
        rep      stosd
 IniciaPagina_salir:        
        xor      edi,edi
        mov      cx,es
        add      cx,100h
        mov      es,cx
        pop      ecx
        pop      edx
        ret
IniciaPagina ENDP


IniciaPaginado PROC NEAR
        push       es
        pushad
        mov        ebx,200h
        mov        edx,_Ext_MEM
        add        edx,400000h
        test       edx,0FFFh
        jz         IniciaPaginado_multiplo
        add        ebx,100h
 IniciaPaginado_multiplo:
        shr        edx,12
 IniciaPaginado_mas:
        add        ebx,100h
        cmp        edx,400h
        jle        IniciaPaginado_hacer
        sub        edx,400h
        jmp short        IniciaPaginado_mas
 IniciaPaginado_hacer:
        mov        Error_Salida,4
        call       ReservaMemoBase
        test       ax,ax
        jz         Fin
        mov        Error_Salida,0
        and        ax,0FF00h
        add        ax,100h
        movzx      edx,ax
        shl        edx,4
        mov        cr3,edx
        mov        es,ax
        xor        edi,edi
        shr        ebx,8
        sub        ebx,2
        mov        ecx,ebx
        mov        eax,1003h
        add        eax,edx
        call       IniciaPagina
        mov        eax,3
 IniciaPaginado_otra:        
        push       ecx
        mov        ecx,1024
        call       IniciaPagina
        pop        ecx
        loop       IniciaPaginado_otra
        popad
        pop        es
        ret        
IniciaPaginado ENDP

SumarPaginas PROC
        push       es
        pushad
        add        eax,3
        mov        edx,cr3
        shr        edx,4
        mov        es,dx
        mov        edx,_Ext_MEM
        mov        edi,edx
        and        edi,3FFFFFh
        shr        edi,10
        and        edi,0FFFFFFFCh
        and        edx,0FFC00000h
        shr        edx,20
        and        edi,0FFFFFFFCh
        mov        edx,es:[edx]
        shr        edx,4
        mov        es,dx
        push       ecx
 SumarPaginas_otra:
        stosd
        add        eax,1000h
        loop       SumarPaginas_otra
        xor        eax,eax
        stosd
        pop        ecx
        shl        ecx,12
;        add        _Ext_MEM,ecx
        popad
        pop        es
        ret
SumarPaginas ENDP

MoverPaginasDatos PROC
        push       es
        xor        eax,eax
        mov        ax,seg INICIO_DATOS
        push       ax
        shl        eax,4
        push       eax
        and        eax,0FFFFF000h       ; eax = Pagina inicio datos
        mov        edx,eax
        shr        edx,12
        pop        ecx
        add        ecx,offset FIN_DATOS
        and        ecx,0FFFFF000h
        shr        ecx,12
        inc        ecx
        sub        ecx,edx              ; ecx = N de paginas de datos
        mov        DATA_PAGES,ecx
        mov        edx,cr3
        shr        edx,4
        mov        es,dx
        mov        edx,es:[0]
        shr        edx,4
        mov        es,dx                ; es = Tabla 0 de Paginas
        add        eax,3
        mov        edi,400h
 MoverPaginasDatos_Hacer:
        stosd
        add        eax,1000h
        loop       MoverPaginasDatos_Hacer
        xor        eax,eax
        pop        ax
        and        ax,00FFh
        shl        ax,4
        mov        ADD_DATA_PAGE,eax
        mov        es,BASE_DPMI
        mov dword ptr es:[0],100000h
        mov        eax,offset FIN_DATOS
        add        eax,ADD_DATA_PAGE
        and        eax,0FFFFF000h
        add        eax,000001000h ; Reservar DPMI las paginas de datos
        mov        es:[4],eax
        pop        es
        mov        eax,100000h
        mov        ecx,DATA_PAGES
        call       SumarPaginas
        add        ADD_DATA_PAGE,100000h
        ret
MoverPaginasDatos ENDP

SumarPaginasMemBase PROC
        mov        Error_Salida,4
        mov        ebx,1
        call       ReservaMemoBase
        call       LiberaMemoBase
        mov        bx,09000h
        sub        bx,ax
        call       ReservaMemoBase
        test       ax,ax
        jz         Fin
        mov        Error_Salida,0
        movzx      edx,ax
        mov        eax,edx
        shl        eax,4
        and        eax,0FFFFF000h
        add        eax,1000h
        mov        ecx,090000h
        sub        ecx,eax
        jz         SumarPaginasMemBase_No
        js         SumarPaginasMemBase_No
        jc         SumarPaginasMemBase_No
        shr        ecx,12
        call       SumarPaginas
 SumarPaginasMemBase_No:
        ret
SumarPaginasMemBase ENDP

CompletarTSSs PROC NEAR
        CompletaTSS DUMMY_TSS,0
        CompletaTSS START32_TSS,0
   TMP = offset SELECTOR_START32_TSS
        CompletaTSS TIMER_TSS,TMP
   TMP = offset SELECTOR_START32_TSS
        CompletaTSS TASK_TSS,TMP
        ret
CompletarTSSs ENDP

Fin    PROC NEAR
      push       ax
      mov        ax,seg INICIO_DATOS
      mov        ds,ax
      mov        ah,0fh
      int        10h
      cmp        al,VIDEO_MODE
      jne        CambiarModoVideo
      cmp        bh,VIDEO_PAG
      je         NoCambiarModoVideo
CambiarModoVideo:
      mov        al,VIDEO_MODE
      xor        ah,ah
      int        10h
      mov        al,VIDEO_PAG
      mov        ah,5
      int        10h
NoCambiarModoVideo:            
      mov        dx,offset Mensaje0
      xor        ax,ax
      mov        al,Error_Salida
      and        ax,ax
      jz         Fin_sin_error
      cmp        al,5
      jl         Fin_error_no_excepcion
      cmp        al,0eh
      jg         Fin_error_no_excepcion
      call       Visualiza_Rejistros
      mov        dx,offset MensajeExcepcion
      jmp short        Fin_error_excepcion
 Fin_error_no_excepcion:
      cmp        al,11h
      jl         Fin_error_no_excepcion2
      call       Visualiza_Rejistros
 Fin_error_no_excepcion2:
      mov        dx,offset MensajeError0
 Fin_error_excepcion:      
      call       Mensaje
      dec        ax
      mov        dx,ax
      mov        cl,5
      shl        dx,cl
      add        dx,offset MensajeError
 Fin_sin_error:      
      call       Mensaje
      pop        ax
SalidaSistema:
      mov        ah,4ch
      int        21h    ; Salir de EXTENSOR
Fin   ENDP

FIN_CODIGO LABEL WORD

Codigo ENDS        

END Inicio
