/****************************************************************************/
/*** This is the Freedows '98 Cache Kernel IRQ Handling code.             ***/
/***    Copyright (C) 1997 by Martin Kortmann                             ***/
/***                                                                      ***/
/***    This file is part of the Freedows '98 Project                     ***/
/****************************************************************************/
/*** Contributors: (If you modify this, please put your name/email here)  ***/
/***                                                                      ***/
/*** File History: (Please record any changes here)                       ***/
/***  08. mar 1997  Coding started (MK)                                   ***/
/****************************************************************************/
#ifndef __IRQ_H
#define __IRQ_H

struct IntRegs
{
   ushort   GS;
   ushort   dummy6;
   ushort   FS;
   ushort   dummy5;
   ushort   ES;
   ushort   dummy4;
   ushort   SS;
   ushort   dummy3;
   ushort   DS;
   ushort   dummy2;
   long     EDI;
   long     ESI;
   long		EBP;
   long     ESP;
   long     EBX;
   long     EDX;
   long     ECX;
   long     EAX;
   long     ErrorCode;
   long     EIP;
   ushort   CS;
   ushort   dummy1;
   long     EFLAGS;
} __attribute__((packed));

typedef struct IntRegs	IntRegs;

extern void InitIRQ (void);

/*
 * Request one Hardware Interrupt.
 *
 * Parameter:
 *  Nr    : Number of Hardware interrupt (0 - 15)
 *  hndlr : address of interrupt function
 *  data  : a simpe number that will be passed to the interrupt function
 *
 * returns: // TODO that should be changed to the standard errno values!
 *   0 = function fails,
 *   1 = OK, you got it.
 */
extern int  RequestIRQ (int Nr, void (*hndlr)(IntRegs *, long), long data);

/*
 * Free one Hardware Interrupt.
 *
 * Parameter:
 *  Nr    : Number of Hardware interrupt (0 - 15)
 */
extern void FreeIRQ   (int Nr);

extern void DumpIRQStatistic (void);

#endif // __IRQ_H

