/****************************************************************************/
/*** This is the Freedows '98 Cache Kernel Timer code.                    ***/
/***    Copyright (C) 1997 by Martin Kortmann                             ***/
/***                                                                      ***/
/***    This file is part of the Freedows '98 Project                     ***/
/****************************************************************************/
/*** Contributors: (If you modify this, please put your name/email here   ***/
/***                                                                      ***/
/*** File History: (Please record any changes here)                       ***/
/***  08. mar 1997  Coding started (MK)                                   ***/
/****************************************************************************/
#ifndef __TIMER_H
#define __TIMER_H

/*
 * Init Timer system
 */
extern void InitTimer (void);

/*
 * Get Number of 10ms ticks since system start
 */
extern unsigned long GetTickCount (void);

/*
 * Set a function that vill be called after xx Milliseconds
 * (with 10 ms)
 *
 * ATTENTION currently the callback fnc will be called at interruptlevel
 *           this will be changed in future!!!
 */
extern int SetSingleShotTimer (int ms, void (*fnc)(void));

#endif //__TIMER_H
