/* by Breyten Ernsting <pinbrn@xs4all.nl> for Freedows kernel */
/* descriptions of these standard C functions can be found in any C book
*/
/* all of this is copied with minor modifications from the source
that Martin Kortmann created (I don't know where he got it) */
#ifndef __STDARG_H
#define __STDARG_H
#ifdef __cplusplus
extern "C" {
#endif
#include <sys/fdtypes.h>

__va_list
#undef __va_list
#define __va_list

#define __size(x) ((sizeof(x)+sizeof(int)-1) & ~(sizeof(int)-1))

#define va_start(ap, parmN) ((void)((ap) = (va_list)((char *)(&parmN)+__size(parmN))))
#define va_arg(ap, type) (*(type *)(((*(char * *)&(ap))+=__size(type))-(__size(type))))
#define va_end(ap)          ((void)0)

#ifdef __cplusplus
}
#endif
#endif // __STDARG_H
