/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
/* by Breyten Ernsting <pinbrn@xs4all.nl> for Freedows kernel */
/* descriptions of these standard C functions can be found in any C book
*/
/* all of this is copied with minor modifications from the DJGPP source'
  see copyright above */
#ifndef __string_h_
#define __string_h_

#ifdef __cplusplus
extern "C" {
#endif

#include <sys/fdtypes.h>
  
#define NULL 0
__size_t
#undef __size_t
#define __size_t

void *	memchr(const void *_s, int _c, size_t _n);
int	memcmp(const void *_s1, const void *_s2, size_t _n);
void *	memcpy(void *_dest, const void *_src, size_t _n);
void *	memmove(void *_s1, const void *_s2, size_t _n);
void *	memset(void *_s, int _c, size_t _n);
char *	strcat(char *_s1, const char *_s2);
char *	strchr(const char *_s, int _c);
int	strcmp(const char *_s1, const char *_s2);
int	strcoll(const char *_s1, const char *_s2);
char *	strcpy(char *_s1, const char *_s2);
size_t	strcspn(const char *_s1, const char *_s2);
char *	strerror(int _errcode);
size_t	strlen(const char *_s);
char *	strncat(char *_s1, const char *_s2, size_t _n);
int	strncmp(const char *_s1, const char *_s2, size_t _n);
char *	strncpy(char *_s1, const char *_s2, size_t _n);
char *	strpbrk(const char *_s1, const char *_s2);
char *	strrchr(const char *_s, int _c);
size_t	strspn(const char *_s1, const char *_s2);
char *	strstr(const char *_s1, const char *_s2);
char *	strtok(char *_s1, const char *_s2);
size_t	strxfrm(char *_s1, const char *_s2, size_t _n);
/* removed bcmp,bcopy,bzero,ffs,index & rindex defs */
void *	memccpy(void *_to, const void *_from, int c, size_t n);
char *	stpcpy(char *_dest, const char *_src);
/* char *	strdup(const char *_s); */ /* not possible yet */
char *	strlwr(char *_s);
int	strcasecmp(const char *_s1, const char *_s2);
int	stricmp(const char *_s1, const char *_s2);
int	strncasecmp(const char *_s1, const char *_s2, size_t _n);
int	strnicmp(const char *_s1, const char *_s2, size_t _n);
char *	strsep(char **_stringp, const char *_delim);
char *	strupr(char *_s);

#ifdef __cplusplus
}
#endif

#endif /* !__string_h_ */
