/****************************************************************************/
/*** This is the Freedows '98 Cache Kernel DMA Handling code.             ***/
/***    Copyright (C) 1997 by Martin Kortmann                             ***/
/***                                                                      ***/
/***    This file is part of the Freedows '98 Project                     ***/
/****************************************************************************/
/*** Contributors: (If you modify this, please put your name/email here   ***/
/***                                                                      ***/
/*** File History: (Please record any changes here)                       ***/
/***  05. apr 1997  Coding started (MK)                                   ***/
/****************************************************************************/
#include <kernel/selector.h>

#include <kernel/kernel.h>
#include <kernel/schedule.h>
#include <kernel/dma.h>
#include <kernel/kprint.h>
#include <kernel/console.h>

extern int sprintf(char * buf, const char *fmt, ...);

typedef struct DMAChannel
{
	int  		   lock;
	const char *device_id;
}DMAChannel;

static DMAChannel DMAChannelBusy [MAX_DMA_CHANNELS] =
{
	{ 0, 0 },
	{ 0, 0 },
	{ 0, 0 },
	{ 0, 0 },
	{ 1, "cascade" },
	{ 0, 0 },
	{ 0, 0 },
	{ 0, 0 }
};

int get_dma_list(char *buf)
{
	int i, len = 0;

	for (i = 0 ; i < MAX_DMA_CHANNELS ; i++)
	{
		if (DMAChannelBusy[i].lock)
		{
		    len += sprintf(buf+len, "%2d: %s\n", i, DMAChannelBusy[i].device_id);
		}
	}
	return len;
} /* get_dma_list */


int RequestDMA(unsigned int dmanr, const char * device_id)
{
	if (dmanr >= MAX_DMA_CHANNELS)
		return -1;

   if (DMAChannelBusy[dmanr].lock != 0)
	  	return (-1);

	DMAChannelBusy[dmanr].lock = 1;
	DMAChannelBusy[dmanr].device_id = device_id;

	return 0;
}


void FreeDMA(unsigned int dmanr)
{
	if (dmanr >= MAX_DMA_CHANNELS)
	{
		kprintf("Trying to free DMA%d\n", dmanr);
		return;
	}

	if (DMAChannelBusy[dmanr].lock == 0)
	{
		kprintf("Trying to free free DMA%d\n", dmanr);
		return;
	}	

	DMAChannelBusy[dmanr].lock = 0;
} /* free_dma */
