/****************************************************************************/
/*** This is the Freedows '98 Cache Kernel code.                          ***/
/***    Copyright (C) 1997 by Martin Kortmann                             ***/
/***                                                                      ***/
/***    This file is part of the Freedows '98 Project                     ***/
/****************************************************************************/
/*** Contributors: (If you modify this, please put your name/email here   ***/
/***                                                                      ***/
/*** File History: (Please record any changes here)                       ***/
/***  29. mar 1997  Coding started (MK)                                   ***/
/****************************************************************************/
#include <kernel/kernel.h>
#include <kernel/selector.h>
#include <kernel/kprint.h>

static void (*DoOutput)(const char *) = 0;

static byte Attr = 7;

// kprint - "Kernel Print" will simply output the string passed to it at the
//          current cursor position (CurX, CurY) with the attribute Attr
// NOTE: It deliberately does not translate \n to \r\n!
void kprint(const unsigned char *s)
{
	ushort		c;
	ushort		scroffs;
	int			i;

	if (DoOutput)
	{
	   DoOutput ((const char *) s);
	   return;
	}

	// console is nit initialized, do direct output
	outportb(0x3d4, 0x0e);
	scroffs = inportb(0x3d5);
	
	scroffs <<= 8;
	
	outportb(0x3d4, 0x0f);
	scroffs += inportb(0x3d5);
	
	scroffs <<= 1;

	while((c=*s++) != 0)
	{
		switch(c)
		{
		case '\n':
			scroffs += 160;
			break;
			
		case '\r':
			scroffs = (scroffs/160)*160;
			break;

		default:
			PokeW(SEL_DLINEAR, scroffs+0xb8000, c+(Attr<<8));
			scroffs += 2;
			break;
		}

		if(scroffs >= 160*25)
		{
			CopyMem(SEL_DLINEAR, 0xb8000+160, SEL_DLINEAR, 0xb8000, 160*24);
			for(i = 0; i < 80; i++)
				PokeW(SEL_DLINEAR, 0xb8000+(160*24)+(i*2), (Attr<<8)+0x20);
			scroffs -= 160;
		}
	}

	scroffs >>= 1;

	outportb(0x3d4, 0x0f);
	outportb(0x3d5, scroffs & 0xff);

	outportw(0x3d4, 0x0e);
	outportb(0x3d5, scroffs >> 8);
}

extern int vsprintf (char *, const char *, va_list);

void kprintf(const unsigned char *fmt, ...)
{
   char buf[256];

	va_list args;

	va_start(args, fmt);
	vsprintf(buf,fmt, args);
	va_end(args);

   kprint(buf);
}

void SetKernelOutputFunction (void (*fnc)(const char *))
{
	DoOutput = fnc;
}

