/****************************************************************************/
/*** This is the Freedows '98 Cache Kernel code.                          ***/
/***    Copyright (C) 1997 by Martin Kortmann                             ***/
/***                                                                      ***/
/***    This file is part of the Freedows '98 Project                     ***/
/****************************************************************************/
/*** Contributors: (If you modify this, please put your name/email here   ***/
/***                                                                      ***/
/*** File History: (Please record any changes here)                       ***/
/***  29. mar 1997  Coding started (MK)                                   ***/
/****************************************************************************/
#include <string.h>

int memcmp(const void *s1, const void *s2, int n)
{
	const unsigned char *p1 = s1, *p2 = s2;

	if (n)
	{
		n++;
		while (--n > 0)
		{
			if (*p1++ == *p2++)
			   continue;
			return (*--p1 - *--p2);
		}
	}
	return (0);
}
