/* Copyright (C) 1994 DJ Delorie, see COPYING.DJ for details */
/* by Breyten Ernsting <pinbrn@xs4all.nl> */
/* and by Daniel Helfman <witten@fidalgo.net> for Freedows kernel */
/* descriptions of these standard C functions can be found in any C book
*/
/* all of this is copied with minor modifications from the DJGPP source'
  see copyright above */
#include <string.h>
#include <libc/unconst.h>
#include <libc/stubs.h>
#include <errno.h>
#include <ctype.h>

char *
strcat(char *s, const char *append)
{
  char *save = s;

  for (; *s; ++s);
  while ((*s++ = *append++));
  return save;
}

char *
strchr(const char *s, int c)
{
  char cc = c;
  while (*s)
  {
    if (*s == cc)
      return unconst(s, char *);
    s++;
  }
  if (cc == 0)
    return unconst(s, char *);
  return 0;
}

int
strcmp(const char *s1, const char *s2)
{
  while (*s1 == *s2)
  {
    if (*s1 == 0)
      return 0;
    s1++;
    s2++;
  }
  return *(unsigned const char *)s1 - *(unsigned const char *)(s2);
}

int
strcoll(const char *s1, const char *s2)
{
  return strcmp(s1, s2);
}

char *strcpy(char *to, const char *from) {
  char *save = to;
  for (; (*to = *from); ++from, ++to);
  return save;
}

size_t strcspn(const char *s1, const char *s2) {
  const char *p, *spanp;
  char c, sc;

  for (p = s1;;) {
    c = *p++;
    spanp = s2;
    do {
      if ((sc = *spanp++) == c)
        return p - 1 - s1;
    } while (sc != 0);
  }
  /* NOTREACHED */
}

char *
strerror(int errnum)
{
  static char ebuf[40];		/* 64-bit number + slop */
  char *cp;
  int v=1000000, lz=0;

  if (errnum >= 0 && errnum < __sys_nerr)
    return(unconst(__sys_errlist[errnum], char *));

  strcpy(ebuf, "Unknown error: ");
  cp = ebuf + 15;
  if (errnum < 0)
  {
    *cp++ = '-';
    errnum = -errnum;
  }
  while (v)
  {
    int d = errnum / v;
    if (d || lz || (v == 1))
    {
      *cp++ = d+'0';
      lz = 1;
    }
    errnum %= v;
    v /= 10;
  }

  return ebuf;
}

size_t strlen(const char *str) {
  const char *s;
  if (str == 0) return 0;
  for (s = str; *s; ++s);
  return s-str;
}

char *
strncat(char *dst, const char *src, size_t n)
{
  if (n != 0)
  {
    char *d = dst;
    const char *s = src;

    while (*d != 0)
      d++;
    do {
      if ((*d = *s++) == 0)
	break;
      d++;
    } while (--n != 0);
    *d = 0;
  }
  return dst;
}

int
strncmp(const char *s1, const char *s2, size_t n)
{

  if (n == 0)
    return 0;
  do {
    if (*s1 != *s2++)
      return *(unsigned const char *)s1 - *(unsigned const char *)--s2;
    if (*s1++ == 0)
      break;
  } while (--n != 0);
  return 0;
}

char *strncpy(char *dst, const char *src, size_t n) {
  if (n != 0) {
    char *d = dst;
    const char *s = src;

    do {
      if ((*d++ = *s++) == 0) {
        while (--n != 0)
          *d++ = 0;
        break;
      }
    } while (--n != 0);
  }
  return dst;
}

char *
strpbrk(const char *s1, const char *s2)
{
  const char *scanp;
  int c, sc;

  while ((c = *s1++) != 0)
  {
    for (scanp = s2; (sc = *scanp++) != 0;)
      if (sc == c)
	return unconst(s1 - 1, char *);
  }
  return 0;
}

char *
strrchr(const char *s, int c)
{
  char cc = c;
  const char *sp=(char *)0;
  while (*s)
  {
    if (*s == cc)
      sp = s;
    s++;
  }
  if (cc == 0)
    sp = s;
  return unconst(sp, char *);
}

size_t strspn(const char *s1, const char *s2) {
  const char *p = s1, *spanp;
  char c, sc;

  cont:
  c = *p++;
  for (spanp = s2; (sc = *spanp++) != 0;)
    if (sc == c)
      goto cont;
  return (p - 1 - s1);
}

char *strstr(const char *s, const char *find) {
  char c, sc;
  size_t len;

  if ((c = *find++) != 0) {
    len = strlen(find);
    do {
      do {
        if ((sc = *s++) == 0) return 0;
      } while (sc != c);
    } while (strncmp(s, find, len) != 0);
    s--;
  }
  return ((char *)s);
}

char *strtok(char *s, const char *delim) {
  const char *spanp;
  int c, sc;
  char *tok;
  static char *last;

  if (s == NULL && (s = last) == NULL)
    return (NULL);

  /*
   * Skip (span) leading delimiters (s += strspn(s, delim), sort of).
   */
  cont:
  c = *s++;
  for (spanp = delim; (sc = *spanp++) != 0;) {
    if (c == sc)
      goto cont;
  }

  if (c == 0) {			/* no non-delimiter characters */
    last = NULL;
    return (NULL);
  }
  tok = s - 1;

  /*
   * Scan token (scan for delimiters: s += strcspn(s, delim), sort of).
   * Note that delim must have one NUL; we stop if we see that, too.
   */
  for (;;) {
    c = *s++;
    spanp = delim;
    do {
      if ((sc = *spanp++) == c) {
        if (c == 0)
          s = NULL;
        else
          s[-1] = 0;
        last = s;
        return (tok);
      }
    } while (sc != 0);
  }
  /* NOTREACHED */
}

size_t
strxfrm(dst, src, n)
     char *dst;
     const char *src;
     size_t n;
{
  size_t r = 0;
  int c;

  if (n != 0) {
    while ((c = *src++) != 0)
    {
      r++;
      if (--n == 0)
      {
	while (*src++ != 0)
	  r++;
	break;
      }
      *dst++ = c;
    }
    *dst = 0;
  }
  return r;
}

void *
memccpy(void *t, const void *f, int c, size_t n)
{
  c &= 0xff;
  if (n)
  {
    unsigned char *tt = (unsigned char *)t;
    const unsigned char *ff = (const unsigned char *)f;

    do {
      if ((*tt++ = *ff++) == c)
	return tt;
    } while (--n != 0);
  }
  return 0;
}

char *
stpcpy(char *_dest, const char *_src)
{
  if (!_dest || !_src)
    return 0;
  while ((*_dest++ = *_src++));
  return --_dest;
}

/* no strdup yet */

int
stricmp(const char *s1, const char *s2)
{
  while (tolower(*s1) == tolower(*s2))
  {
    if (*s1 == 0)
      return 0;
    s1++;
    s2++;
  }
  return (int)tolower(*s1) - (int)tolower(*s2);
}

char *
strlwr(char *_s)
{
  char *rv = _s;
  while (*_s)
  {
    *_s = tolower(*_s);
    _s++;
  }
  return rv;
}

int
strnicmp(const char *s1, const char *s2, size_t n)
{

  if (n == 0)
    return 0;
  do {
    if (tolower(*s1) != tolower(*s2++))
      return (int)tolower(*s1) - (int)tolower(*--s2);
    if (*s1++ == 0)
      break;
  } while (--n != 0);
  return 0;
}

char *
strsep(char **stringp, const char *delim)
{
  char *s;
  const char *spanp;
  int c, sc;
  char *tok;

  if ((s = *stringp) == 0)
    return 0;

  tok = s;
  while (1)
  {
    c = *s++;
    spanp = delim;
    do {
      if ((sc = *spanp++) == c)
      {
	if (c == 0)
	  s = 0;
	else
	  s[-1] = 0;
	*stringp = s;
	return tok;
      }
    } while (sc != 0);
  }
}

char *
strupr(char *_s)
{
  char *rv = _s;
  while (*_s)
  {
    *_s = toupper(*_s);
    _s++;
  }
  return rv;
}

int	strcasecmp(const char *_s1, const char *_s2)
{
   return stricmp(_s1,_s2);
}

int	strncasecmp(const char *_s1, const char *_s2, size_t _n)
{
  return strnicmp(_s1,_s2,_n);
}