/****************************************************************************/
/*** This is the Freedows '98 Cache Kernel code.                          ***/
/***    Copyright (C) 1997 by Martin Kortmann                             ***/
/***                                                                      ***/
/***    This file is part of the Freedows '98 Project                     ***/
/****************************************************************************/
/*** Contributors: (If you modify this, please put your name/email here   ***/
/***                                                                      ***/
/*** File History: (Please record any changes here)                       ***/
/***  29. mar 1997  Coding started (MK)                                   ***/
/****************************************************************************/
#include <string.h>

char * strncpy(char *dst, const char *src, int n)
{
	if (n != 0)
	{
		char *d = dst;
		const char *s = src;

		do
		{
			if ((*d++ = *s++) == 0)
			{
				while (--n != 0)
					*d++ = 0;
				break;
			}
		} while (--n != 0);
	}

	return (dst);
}
