/*             ** SECCION  DE INTERFAZ PUBLICA DE KMOS **          */
/* Este  archivo cabecera (KMOSPUB.H) contiene el interfaz pblico */
/* de exportacin, visible al usuario, proporcionada por KMOS      */
/* para su propia implementacin y la de las rutinas de usuario    */
/* (aplicaciones) */

/* Tipos pblicos de KMOS */
typedef struct k_mens {             /* Prototipo de mensaje            */
  struct k_mens *enlace;            /* enlace para mensajes en buzones */
  int mtipo;                        /* tipo de mensaje                 */
  void *cuerpo;                     /* puntero al cuerpo del mensaje   */
} k_mens, *k_ptrmens;

typedef char procnombre[9];  /* nombre de proceso, limite  9 caracteres*/
typedef unsigned int palabra;    /* tipo generico unsigned int, PALABRA*/
typedef void * puntero;             /* tipo generico puntero           */

/* variables pblicas de KMOS  */
extern puntero k_bziniv0;         /*  buzn para interrupciones de nivel_0 */
extern puntero k_bziniv1;         /*  buzn para interrupciones de nivel_1 */
extern puntero k_bziniv2;         /*  buzn para interrupciones de nivel_2 */
extern puntero k_bziniv3;         /*  buzn para interrupciones de nivel_3 */
extern puntero k_bziniv4;         /*  buzn para interrupciones de nivel_4 */
extern puntero k_bziniv5;         /*  buzn para interrupciones de nivel_5 */
extern puntero k_bziniv6;         /*  buzn para interrupciones de nivel_6 */
extern puntero k_bziniv7;         /*  buzn para interrupciones de nivel_7 */


/* Servicio pblicos de KMOS, invocables por usuario */

/** K_CREARBUZON ** crea un buzn, inicializando el descriptor  */
/* de buzn cuya direccin se le pasa como parmetro.           */

extern puntero k_crearbuzon ();


/** K_ENVIAR ** entrega un mensaje, cuya direccin se le pasa como   */
/* segundo parmetro, al primer proceso que est esperando en el     */
/* buzn designado cuya direccin se le pasa como primer parmetro . */
/* K_ENVIAR es no-bloqueante y los mensajes que tengan que esperar se*/
/* guardan en cola en orden FIFO  */

extern void k_enviar (puntero buzon, k_ptrmens mensaje);


/** K_RECIBIR es una funcin que entrega al proceso que la invoca */
/* el primer mensaje de la cola asociada al buzn cuya direccin  */
/* se le pasa como primer parmetro. Ignora el segundo parmetro. */
/* K_RECIBIR es bloqueante.                                       */

extern k_ptrmens k_recibir (puntero buzon, int limite);


/** K_CREARPROC ** crea un Bloque de Control de Proceso para un       */
/* un proceso cuyos atributos se le pasan como parmetros. El proceso */
/* es colocado luego en la lista de Preparados. Los parmetros de     */
/*  invocacin son:                                                   */
/*   1. (ptrproc) apunta a la direccin inicial del cdigo del proceso*/
/*   2. (pnombre) nombre del proceso, cadena <= 9 caracteres          */
/*   3. (longpila) longitud de pila de proc., normalmente de 80 a 255 */
/*   4. (prioridad) prioridad del proceso : 0-mxima, 255-mnima      */

extern void k_crearproc (puntero ptrproc, procnombre pnombre,
                         palabra longpila, int prioridad);


/** K_ELIMINARPROC ** elimina (finaliza) el proceso invocante.     */
/* Este es el servicio de terminacion que proporciona KMOS.        */

extern void k_eliminarproc();


/** K_RETARDAR ** retarda el proceso invocante durante el nmero de */
/* tics del reloj del sistema que se le pasa como parmetro.        */

extern void k_retardar (int tics);


/** K_HABILNVL ** hace que el nivel de interrupcin hardware, que se */
/* le pasa como parmetro, sea elegible para activacin. No hace nada*/
/* si el nivel no es vlido (los niveles vlidos en el PC son 0-7 ). */
/* La habilitacin de un nivel ya habilitado  no tiene ningn efecto.*/

extern void k_habilnvl (int nivel);


/** KMOSINICIAL ** inicializa las estructuras internas de KMOS. Debera */
/* ser invocado slo una vez desde el cdigo principal (main) de usuario*/
/* antes de la invocacin de cualquier servicio de KMOS                 */
/* (vanse las demos).                                                  */

extern void kmosinicial();


/** KMOSINICIAR ** iniciacin de KMOS; establece el entorno del sistema.*/
/* Debera ser invocado slo una vez desde el cdigo de usuario, como   */
/* ltima sentencia de la seccin de iniciacin (main) de usuario.      */

extern void kmosiniciar();

