/* kmos con salida al DOS */

#include "kmospub.h"

/*#include <stdio.h>*/
#include <stdlib.h>
/*#include <setjmp.h>*/
#include <dos.h>

void imprimir(char *cadena);

extern void **vectempor;/* = (puntero) 0x00000020ul; /* vector int. temporizador DOS  */
extern void **reltempor;/* = (puntero) 0x00000180ul; /* lugar de reubicacion          */

#define cip00 0x20               /* PC Controlador Interr. Prog., direccin0  */
#define cip01 0x21               /* PC CIP (8259A), direccin1                */

#define inton asm sti            /* STI, permite las interrupciones      */
#define intoff asm cli           /* CLI, prohibe las interrupciones      */


puntero  valvectempor, valreltempor;
unsigned char  valorcip00, valorcip01;

palabra  /*AX, BX, CX, DX, SI, DI, FLAGS, */SP;

#define salvar \
{\
  intoff;\
  valvectempor = *vectempor;\
  valreltempor = *reltempor;\
  valorcip00 = inportb(cip00);\
  valorcip01 = inportb(cip01);\
  SP=_SP;\
  inton;\
}
/*  AX=_AX;BX=_BX;CX=_CX;DX=_DX;SI=_SI;DI=_DI;FLAGS=_FLAGS;SP=_SP;\*/
/*jmp_buf  salto_al_fin;*/
void salir(void)
{
  k_retardar(200);
  intoff;
  *vectempor = valvectempor;
  *reltempor = valreltempor;
  outportb(cip00, valorcip00);
  outportb(cip01, valorcip01);
/*  _AX=AX;_BX=BX;_CX=CX;_DX=DX;_SI=SI;_DI=DI;_FLAGS=FLAGS;*//*_SP=SP;*/
  inton;
  imprimir("Saliendo de KMOS $");
  exit(0);
/*  longjmp(salto_al_fin,1);*/
}


void imprimir(char *cadena)
{
  union REGS  regs;
  struct SREGS  sregs;
  unsigned char  salvamascara;

  salvamascara=inportb(cip01);
  outportb(cip01,0xbd);
  regs.h.ah=9;
  sregs.ds=FP_SEG(cadena);
  regs.x.dx=FP_OFF(cadena);
  intdosx(&regs,&regs,&sregs);
  outportb(cip01,salvamascara);
}

void p1()
{
char cadena[]="hola $";
while(1){
  k_retardar(60);
  imprimir(cadena);
}
  k_eliminarproc();
}


main()
{
  salvar;
/*  if(setjmp(salto_al_fin) != 0){
    imprimir(" Saliendo de KMOS $");
    exit(0);
  }*/
  kmosinicial();

  k_crearproc(p1,"P1",255,150);
  k_crearproc(salir,"salir",255,140);

  imprimir(" Entrando en KMOS $");
  kmosiniciar();
}