/*
   dxedump.cpp
   Copyright (c) 1997 Josh McDonald <os-dev@effect.net.au>.
   Part of OS/2000.
   http://www.effect.net.au/os-dev/

   Dumps the code from kernel.dxe. Then, attatch with copy/b to stub.com.

   Contains code stolen from dxeload.c, by DJ Delorie and Charles Sandman.

*/


#include <io.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/dxe.h>

int main(int argc, char **argv)
{
	dxe_header dh;
  	char *data;
  	int h;

        int base;

        h = _open("kernel.dxe", 0);
  	if (h < 0)
	{
		printf ("Could not open file!\n");
    		return 1;
	}

  	_read(h, &dh, sizeof(dh));
  	if (dh.magic != DXE_MAGIC)
  	{
    		_close(h);
		printf("Not a dxe!\n");
		return 1;
	}

        dh.symbol_offset+=7;    //STUPID 2 Leave this out!!!!!!

        printf("symbol_offset  :%u\n",dh.symbol_offset);
	printf("element_size   :%u\n",dh.element_size);
	printf("nrelocs        :%u\n",dh.nrelocs);

	data = (char *)malloc(dh.element_size);
	if (data == 0)
	{
		_close(h);
		printf("No mem!\n");
		return 1;
	}

	_read(h, data, dh.element_size);

	{
		long relocs[dh.nrelocs];
		int i;
		_read(h, relocs, sizeof(long)*dh.nrelocs);
		_close(h);

                //Code is relocated around 7 bytes.

              for (i=0; i<dh.nrelocs; i++)
                      *(long *)(data + relocs[i]) += 7;
	}

	_close(h);

        printf("Creating dxe.bin...");

	//I hate the integer handle shit, so I'm usin' stdio.
        FILE *o=fopen("dxe.bin","wb");

        //We're gonna dump 7 bytes of code to the file first,
        //Which is JMP FAR 0x0008:symbol_offset.

        putc(0xea,o);
        putc(dh.symbol_offset,o);
        putc(dh.symbol_offset>>8,o);
        putc(dh.symbol_offset>>16,o);
        putc(dh.symbol_offset>>24,o);
        putc(0x08,o);
        putc(0,o);

        //Now, dump the actual code!
        for (unsigned long nn=0;nn<dh.element_size;nn++)
		putc(data[nn],o);
	fclose(o);

        printf("Done!\n");

	return 0;
}


