/********************************************************************

        Kernel.cpp

        Initial kernel code, for OS/2000. Called by the small r/m
        setup program and 32-bit JMP code in init.asm.

        Non optimized, I wanna get it working first ;-)

        Compiled to a DXE, then converted by dxedump with a 7byte JMP
        instruction prefixed to the code (to JMP into the entry point),
        which is attatched to init. built from init.asm.

        Contains some conio.h replacements. Printf once I figure it out ;-)

        Entry32-> Gets a flat pmode segment, ds->cs->flat,

        Default selectors:
        
        0x08    -       Code, 32-bit.
        0x10    -       Data, 00000000, flat
        0x18    -       Data, alias for code.

        The real mode code will set up a stack at 2M, this code
        is garaunteed to be originally in <1m.

********************************************************************/

//These externs aren't really, they're just here for the compiler.

#define byte unsigned char
#define word unsigned short
#define dword unsigned long

extern dword default_handler;
extern dword default_lo_int;
extern dword default_hi_int;
extern dword irq0;
extern dword irq1;
extern dword irq2;
extern dword irq3;
extern dword irq4;
extern dword irq5;
extern dword irq6;
extern dword irq7;
extern dword new_timer;
extern exception00;
extern exception01;
extern exception02;
extern exception03;
extern exception04;
extern exception05;
extern exception06;
extern exception07;
extern exception08;
extern exception09;
extern exception10;
extern exception11;
extern exception12;
extern exception13;
extern exception14;
extern exception16;

//
// Globals
//

unsigned static ds_base;                //Base of ds. Eventually won't be
                                        //Needed.
volatile dword tick_counter; 
volatile dword tick_counter2;           //Clock tick counter 1
char *screen;                           //Screen address.
char *memory;                           //Flat 4g pointer .

struct idt_gate
{
        word offset1;
        word selector;
        byte dword_count;
        byte type;
        word offset2;
};

idt_gate idt[256];              

struct
{
        word size;
        dword offset;
} idt_desc;

char hex_letter[]={'0','1','2','3','4','5','6','7','8','9','a',
                'b','c','d','e','f'};

//
// Set interrupt
//

void set_int (int intno, dword pointer)
{
        idt[intno].selector=0x08;
        idt[intno].dword_count=0;
        idt[intno].type=0x0ee;
        idt[intno].offset1=pointer;
        idt[intno].offset2=pointer>>16;
        return;
}

//
// Output a byte to a port.
//

void outportb(dword port, dword data)
{
        asm ("movl %0,%%edx\n
                movl %1,%%eax\n
                outb %%al,%%dx\n": /* out */ : /* In */ "g" (port),
                        "g" (data) );
        return;
}

//
// Screen variables
//

int cursor_xpos;
int cursor_ypos;
int cursor_mempos;
int attribute;

#define width 80
#define height 25
#define crtc_port1 0x3d4
#define crtc_port2 0x3d5
#define crtc_curlo 0x0f
#define crtc_curhi 0x0e

//
// Gotoxy
//

void gotoxy(int x,int y)
{
        cursor_xpos=x;
        cursor_ypos=y;

        int px=x-1;
        int py=y-1;

        cursor_mempos=py*width*2;
        cursor_mempos+=px*2;

        //Set the hardware cursor pos.

        int offset=py*width;
        offset+=px;

        outportb(crtc_port1,crtc_curlo);
        outportb(crtc_port2,offset);
        outportb(crtc_port1,crtc_curhi);
        offset>>=8;
        outportb(crtc_port2,offset);

        return;
}

//
// Clear screen
//

void clrscr(void)
{
        int i;
        for (i=0;i<width*2*height;i+=2)
        {
                screen[i]=' ';
                screen[i+1]=attribute;
        }
        gotoxy(1,1);
        return;
}

//
// Clear console
//

void clrcon(void)
{
        int i;
        for (i=width*2;i<width*2*height;i+=2)
        {
                screen[i]=' ';
                screen[i+1]=attribute;
        }
        gotoxy(1,2);
        return;
}

//
// Textcolor
//

void textcolor(int c)
{
//        asm ("hang: jmp hang\n");

        attribute&=0xf0;        //Reset foreground colour.
        attribute|=(c&0xf);     //Add in new foreground colour.
        return;
}

//
// Textbackground
//

void textbackground(int c)
{
        attribute&=0x0f;        //Reset background.
        attribute|=(c<<4);      //Add new background colour.
        return;
}

//
// Scrollwindow
//

void scrollwindow(void)
{
        int i;
        for (i=width*4;i<width*2*height;i++)
                screen[i-width*2]=screen[i];
        return;
}

//
// Print
//

void print(char *str)
{
        int i=0;
        while(str[i])
        {
                int c=str[i];

                if(c=='\n')
                {
                        cursor_mempos+=(width-cursor_xpos+1)*2;
                        cursor_xpos=width+1;
                }
                else
                {
                        screen[cursor_mempos]=c;
                        cursor_mempos+=2;
                        cursor_xpos++;
                }

                if (cursor_xpos>width)
                {
                        cursor_xpos-=width;
                        cursor_ypos++;
                        if (cursor_ypos>height)
                        {
                                scrollwindow();
                                cursor_ypos=height;
                        }
                }
                i++;
        }

        //Set the hardware cursor pos. 

        int xp=cursor_xpos-1;
        int yp=cursor_ypos-1;

        int offset=yp*width;
        offset+=xp;

        outportb(crtc_port1,crtc_curlo);
        outportb(crtc_port2,offset);
        outportb(crtc_port1,crtc_curhi);
        offset>>=8;
        outportb(crtc_port2,offset);

        return;
}

void call_print(void)
{
        print("call_print()\n");
        return;
}

//
// Various interrupt handlers.
// This function is never called, it just contains the handlers.
// Really just a collection of misc. ASM/C code within the kernel.

void default_handlers (void)
{
        //IRQ handlers...

        asm ("\n
                _default_lo_int:\n
                cli 
                push %eax 
                mov $0x20,%al 
                outb %al,$0x20 
                pop %eax 
                iret 

                _default_hi_int:
                cli 
                push %eax 
                mov $0x20,%al 
                outb %al,$0xa0 
                outb %al,$0x20
                pop %eax 
                iret 

                _irq0: 
                cli
                push %ds
                push %eax
                push %ebx
                mov $0x10,%eax
                mov %ax,%ds 
                mov $0xb8000+144,%ebx
                movb (%ebx),%ax
                inc %ax
                and $0x7,%ax
                or $0xf0,%ax
                movb %ax,(%ebx)
                pop %ebx
                pop %eax
                pop %ds
                jmp _default_lo_int

                _irq1: 
                cli 
                push %ds
                push %eax
                push %ebx
                mov $0x10,%eax
                mov %ax,%ds
                mov $0xb8000+146,%ebx
                incb (%ebx)
                inb $0x60,%al
                pop %ebx
                pop %eax
                pop %ds
                jmp _default_lo_int

                _irq2: 
                cli 
                push %ds
                push %eax
                push %ebx
                mov $0x10,%eax
                mov %ax,%ds
                mov $0xb8000+148,%ebx
                incb (%ebx)
                pop %ebx
                pop %eax
                pop %ds
                jmp _default_lo_int

                _irq3: 
                cli 
                push %ds
                push %eax
                push %ebx
                mov $0x10,%eax
                mov %ax,%ds
                mov $0xb8000+150,%ebx
                incb (%ebx)
                pop %ebx
                pop %eax
                pop %ds
                jmp _default_lo_int

                _irq4: 
                cli 
                push %ds
                push %eax
                push %ebx
                mov $0x10,%eax
                mov %ax,%ds
                mov $0xb8000+152,%ebx
                incb (%ebx)
                pop %ebx
                pop %eax
                pop %ds
                jmp _default_lo_int

                _irq5: 
                cli 
                push %ds
                push %eax
                push %ebx
                mov $0x10,%eax
                mov %ax,%ds
                mov $0xb8000+154,%ebx
                incb (%ebx)
                pop %ebx
                pop %eax
                pop %ds
                jmp _default_lo_int

                _irq6: 
                cli 
                push %ds
                push %eax
                push %ebx
                mov $0x10,%eax
                mov %ax,%ds
                mov $0xb8000+156,%ebx
                incb (%ebx)
                pop %ebx
                pop %eax
                pop %ds
                jmp _default_lo_int

                _irq7: 
                cli 
                push %ds
                push %eax
                push %ebx
                mov $0x10,%eax
                mov %ax,%ds
                mov $0xb8000+158,%ebx
                incb (%ebx)
                pop %ebx
                pop %eax
                pop %ds
                jmp _default_lo_int

                ");

        //Standard "what the fuck was that?!?" handler.

        asm ("_default_handler:\n
                mov $0x18,%eax \n
                mov %ax,%ds \n ");

        print ("Unexpected CPU exception!");
        asm ("here: jmp here\n");

        //Crap default exception handlers.

        asm ("_exception00:
                mov $0x18,%eax 
                mov %ax,%ds  ");
        print("Divide by 0!\nSystem halted.\n");
        asm ("jmp here");                
                
        asm ("_exception01:\n
                mov $0x18,%eax \n
                mov %ax,%ds \n ");
        print("Debug!\nSystem halted.\n");
        asm ("jmp here");                
                
        asm ("_exception02:\n
                mov $0x18,%eax \n
                mov %ax,%ds \n ");
        print("Heavy hardware failure!\nSystem halted.\n");
        asm ("jmp here");                
                
        asm ("_exception03:\n
                mov $0x18,%eax \n
                mov %ax,%ds \n ");
        print("Breakpoint!\nSystem halted.\n");
        asm ("jmp here");                
                
        asm ("_exception04:\n
                mov $0x18,%eax \n
                mov %ax,%ds \n ");
        print("Overflow!\nSystem halted.\n");
        asm ("jmp here");                
                
        asm ("_exception05:\n
                mov $0x18,%eax \n
                mov %ax,%ds \n ");
        print("Bound range exceeded!\nSystem halted.\n");
        asm ("jmp here");                
                
        asm ("_exception06:\n
                mov $0x18,%eax \n
                mov %ax,%ds \n ");
        print("Invalid Opcode!\nSystem halted.\n");
        asm ("jmp here");                
                
        asm ("_exception07:\n
                mov $0x18,%eax \n
                mov %ax,%ds \n ");
        print("Device not available!\nSystem halted.\n");
        asm ("jmp here");                
                
        asm ("_exception08:\n
                mov $0x18,%eax \n
                mov %ax,%ds \n ");
        print("Double fault!\nSystem halted.\n");
        asm ("jmp here");                
                
        asm ("_exception09:\n
                mov $0x18,%eax \n
                mov %ax,%ds \n ");
        print("Coprocessor segment overrun!\nSystem halted.\n");
        asm ("jmp here");                
                
        asm ("_exception10:\n
                mov $0x18,%eax \n
                mov %ax,%ds \n ");
        print("Invalid TSS!\nSystem halted.\n");
        asm ("jmp here");                
                
        asm ("_exception11:\n
                mov $0x18,%eax \n
                mov %ax,%ds \n ");
        print("Segment not present!\nSystem halted.\n");
        asm ("jmp here");                
                
        asm ("_exception12:\n
                mov $0x18,%eax \n
                mov %ax,%ds \n ");
        print("Stack fault!\nSystem halted.\n");
        asm ("jmp here");                
                
        asm ("_exception13:\n
                mov $0x18,%eax \n
                mov %ax,%ds \n ");
        print("GPF! Noooooooooooooooo, Windows 3.1 lives!\nSystem halted.\n");
        asm ("jmp here");                
                
        asm ("_exception14:
                mov $0x18,%eax 
                mov %ax,%ds ");
        print("Page fault!\nSystem halted.\n");
        asm ("jmp here");                

        asm ("_exception16:
                mov $0x18,%eax 
                mov %ax,%ds  ");
        print("FPU Error!\nSystem halted.\n");
        asm ("jmp here");



        //New timer interrupt handler.

        asm ("_new_timer:
                push %ds
                push %eax
                push %ebx

                mov $0x18,%eax
                mov %ax,%ds

                mov (_tick_counter),%ebx
                inc %ebx
                mov %ebx,(_tick_counter)

                mov (_tick_counter2),%ebx
                inc %ebx
                mov %ebx,(_tick_counter2)
                cmpl $3000,%ebx

                jb noneed_call_old

                xor %eax,%eax
                movl %eax,(_tick_counter2)            

                pop %ebx
                pop %eax
                pop %ds
                jmp _irq0               

              noneed_call_old:
                
                pop %ebx
                pop %eax
                pop %ds
                jmp _default_lo_int

        ");
        

        return; //Just for compiler's sake.
}

//Set up IDT and default IRQ+Exception handlers.

void setup_idt(void)
{
        print ("setup_idt()...");

        int i;

        //Fill IDT with default entries.
        for (i=0;i<256;i++)
        {
                set_int(i,(dword)&default_handler);
        }
        for (i=32;i<40;i++)
                set_int(i,(dword)&default_lo_int);
        for (i=40;i<48;i++)
                set_int(i,(dword)&default_hi_int);

        set_int(32,(dword)&irq0);
        set_int(33,(dword)&irq1);
        set_int(34,(dword)&irq2);
        set_int(35,(dword)&irq3);
        set_int(36,(dword)&irq4);
        set_int(37,(dword)&irq5);
        set_int(38,(dword)&irq6);
        set_int(39,(dword)&irq7);

        set_int( 0,(dword)&exception00);
        set_int( 1,(dword)&exception01);
        set_int( 2,(dword)&exception02);
        set_int( 3,(dword)&exception03);
        set_int( 4,(dword)&exception04);
        set_int( 5,(dword)&exception05);
        set_int( 6,(dword)&exception06);
        set_int( 7,(dword)&exception07);
        set_int( 8,(dword)&exception08);
        set_int( 9,(dword)&exception09);
        set_int(10,(dword)&exception10);
        set_int(11,(dword)&exception11);
        set_int(12,(dword)&exception12);
        set_int(13,(dword)&exception13);
        set_int(14,(dword)&exception14);
        set_int(16,(dword)&exception16);

        idt_desc.size=(256*8)-1;
        idt_desc.offset=(dword)idt+ds_base;

        //Set IDT and turn on ints.
        asm ("lidt _idt_desc\n
                sti\n");

        print("OK.\n");

        return;
}


//Set up the timer
void setup_timer(void)
{
        print("setup_timer()...");

        //Speed up the timer to 49.715 khz (overhead in this?)

        asm ("cli");
        outportb(0x43,0x34);
        outportb(0x40,24);
        outportb(0x40,0);
        asm ("sti");

        //Is this _really_ all that we need to do?

        set_int(32,(dword)&new_timer);

        print("OK!\n");

        return;
}

// Output a number in hex

void hex (dword number)
{
        dword j,k;
        int i;

        char *output="00000000";

        k=number;

        for (i=8;i>0;i--)
        {
                j=k&0xf;
                output[i-1]=hex_letter[j];
                k>>=4;
        }
        

        print(output);

        return;
}

//Keep the machine idling.

void idle_machine(void)
{
        print ("idle_machine()... ");
        while (1)
        {
                if(tick_counter&0x20000)
                        print("Blip! ");

                while (tick_counter&0x20000);
        }   
        return;
}
 
//
// Entry point.
//

void entry32()
{

        //OK, get ds_base We need asm here, so......

        asm ("movw $0x10,%ax\n
                movw %ax,%fs\n
                movl $0,%ebx\n
                movl %fs: (%ebx),%eax\n
                movl %eax,_ds_base\n");

        screen=(char *)(0xb8000-ds_base);
        memory=(char *)(-ds_base);


        textbackground(0);

        textcolor(15);

        outportb(0x3c8,1);
        outportb(0x3c9,20);
        outportb(0x3c9,20);
        outportb(0x3c9,40);


        clrscr();

        print(" OS/2000 Console         ");

        textbackground(0);

        textcolor(1);

        clrcon();

        print("OS/2000 Version 0.1.\n");
        print("Copyright (c) 1997 Josh McDonald.\n");
        print("Build: ");
        print(__DATE__);
        print(" / ");
        print(__TIME__);
        print("\n\n");
        print("For more information, see: http://www.effect.net.au/os2000/\n\n");

        setup_idt();
        setup_timer();

        idle_machine();

        //Just for compiler's sake ;-)
        return; 
}






