#include <malloc.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>

#include "index.h"
#include "lidata.h"

void insertaLi(lidata   **lista, unsigned short indice, unsigned short desp,
                unsigned char   *cadena,unsigned short tam)
{
  lidata   *nuevo,  *aux=*lista;
  if ((nuevo=(lidata    *) malloc(sizeof(lidata )))==NULL)
      {
	printf("No hay memoria suficiente");
	exit(0);
      }
  nuevo->indice=indice;
  nuevo->desp=desp;
  nuevo->code=cadena;
  nuevo->tamano=tam;
  nuevo->sig=aux;
  *lista=nuevo;
}


void liberaLi(lidata   *lista)
{
  if (lista!=NULL){
  if (lista->sig!=NULL) liberaLi(lista->sig);
  if (lista->code!=NULL)  free(lista->code);
   free(lista);}
}

/*Procedimiento de obtencion de informacion del registro LiData*/
void Lidata(lidata   **Lista,FILE *fp,unsigned short tamanio)
/*Este registro almacena la informacion de datos con repeticion, esto es,
  una cadena o una serie de cadenas repetidas formando una estructura de
  datos, ya sea para codigo u para otros fines. La forma de almacenar estas
  repeticiones seran desritas en el procedimiento iterac*/
{
unsigned short index,segment;
unsigned char   *cadena;
unsigned short n,aux;

   tamanio-=indice(fp,&index); /*obtenemos el indice al que referenciamos la
				informacion*/
   char alto,bajo;
   bajo=fgetc(fp);
   alto=fgetc(fp);
   segment=bajo+(alto<<8);/*tomamos el desplazamiento del codigo en
				     ese segmento*/
   tamanio-=2; /*actualizamos el tamao para la comprobacion de que hemos
		hecho todo bien*/
   iterac(fp,&tamanio,&cadena,&n);
   /*insertamos en lista*/
   insertaLi(Lista,index,segment,cadena,n);
   /*En el caso de que el fichero sea erroneo, medido en la lectura de
     caracteres, damos el error y salimos*/
   if (tamanio<1) {printf("El fichero dado es erroneo!!!"); exit(0);}
   /*leemos el checksum*/
   fgetc(fp);
}



void iterac(FILE *fp, unsigned short *i,unsigned char   **cadena,unsigned short *n)
/*Este procedimiento recursivo se encarga de obtener la informacion del
  registro LIDATA y de devolver una cadena con todos los elementos tal y como
  quedan tras la repeticion*/
{
unsigned short ele,repe,aux,aux2,tam;
unsigned char *cad;
unsigned char sub;
unsigned short indice=0;
element **tabla;

  char alto,bajo;
  bajo=fgetc(fp);
  alto=fgetc(fp);
  repe=bajo+(alto<<8);/*leemos el numero de repeticiones*/
  bajo=fgetc(fp);
  alto=fgetc(fp);
  ele=bajo+(alto<<8);/*leemos el numero de elementos*/
  *i-=4;
  if (ele==0)/*tal y como describe la documentacion, miramos si el numero de
	       elementos es 0*/
    {
      /*si es 0, tenemos un bloque de codigo simple*/
      /*reservamos memoria para la estructura*/
      tabla=(element **) malloc(sizeof(element *));
      tabla[0]=(element *) malloc(sizeof(element));
      /*obtenemos el tamao*/
      tam=fgetc(fp);
      *i-=tam+1;
      /*reservamos memoria para el vector*/
      tabla[0]->vector=(unsigned char *) malloc(tam);
      /*lo obtenemos*/
      for(aux=0;aux<tam;aux++) tabla[0]->vector[aux]=fgetc(fp);
      /*y lo almacenamos*/           
      tabla[0]->tam=tam;
      /*decimos que tenemos UN elemento*/
      ele=1;
    }
  else
    {

     /*si tenemos mas elementos 1-n, reservamos memoria para dichos
       elementos*/
     tabla=(element **) malloc(sizeof(element *)*ele);
     /*por cada unos de ellos obtenemos la informacion*/
      for(aux=0;aux<ele;aux++)
	{
	 /*llamando recursivamente a este procedimiento hasta que sean
	   elementos simples*/
          tabla[aux]=(element *) malloc(sizeof(element));
          iterac(fp,i,&tabla[aux]->vector,&tam);
          /*a la vuelta, nos devuelve el tamao y una cadena*/          
	  tabla[aux]->tam=tam;
	}
    };

  /*actualizamos la veriable tamao*/
  tam=0;
  /*obtenemos el tamao de todas las cadenas juntas*/
  for(aux2=0;aux2<ele;aux2++)
       tam+=tabla[aux2]->tam;
  /*y obtenemos el tamao de la cadena resultante*/
  tam*=repe;

cad=(unsigned char *)malloc(tam);
/*recorremos la estructura y formamos la nueva cadena*/
  for(aux=0;aux<repe;aux++)
     for(aux2=0;aux2<ele;aux2++)
        for(sub=0;sub<tabla[aux2]->tam;sub++,indice++)
             cad[indice]=tabla[aux2]->vector[sub];
/*que devolvemos junto con su tamao*/
*cadena=cad;
*n=tam;
/*Liberando la memoria de la estructura antes de finalizar*/
for(aux2=0;aux2<ele;aux2++)
   {
     free(tabla[aux2]->vector);
     free(tabla[aux2]);
    }
free(tabla);
}
