#include <malloc.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>

#include "seg.h"
#include "define.h"
#include "index.h"

/*Mensajes que se dan en el analisis del alinemamiento de un segmento*/
char *align_msg[5] =
{
  "0 Segmento absoluto",
  "1 Reubicable, segmento alineado a byte",
  "2 Reubicable, segmento alineado a word",
  "3 Reubicable, segmento alineado a parrafo",
  "4 Reubicable, segmento alineado a pagina"
};



/*Mensajes en el analisis de segmentos, campo del registro de combinacion*/
char *combine_msg[7] =
{
  "0 Segmento privado",
  "1 reservado por IBM, yo SI lo soportare",
  "2 Segmento publico",
  "3 reservado por IBM, yo SI lo soportare",
  "4 Segmento publico",
  "5 Segment de pila",
  "6 Segment comun"
};



/*inserta un elemento en la lista, en caso de que haya mas segmentos en ella
se insertaran despues de los que ya estan, siendo muy comun que hay mas de
un segmento en el codigo*/
void insertaS(segmento  **lista,
              unsigned char alinea,
              unsigned char combina,
              unsigned char big,
              unsigned char p,
              unsigned short frame,
              unsigned short desp,
              unsigned short longitud,
              unsigned short Nindex,
              unsigned short Clasindex,
              unsigned short Overindex)
{
  segmento  *nuevo, *aux=*lista;

  if ((nuevo=(segmento   *)malloc(sizeof(segmento)))==NULL)
      {
	printf("No hay memoria suficiente");
	exit(0);
      }
  /*actualizamos los campos*/
  nuevo->alinea=alinea;
  nuevo->combina=combina;
  nuevo->big=big;
  nuevo->p=p;
  nuevo->frame=frame;
  nuevo->desp=desp;
  nuevo->longitud=longitud;
  nuevo->Nindex=Nindex;
  nuevo->Clasindex=Clasindex;
  nuevo->Overindex=Overindex;
  if (aux!=NULL)
    nuevo->napa=aux->napa+1;
  else
    nuevo->napa=1;

  nuevo->sig=aux;
  *lista=nuevo;
}

/*libera la memoria que hemos retenido en la creacion de la lista*/
void liberaS(segmento  *lista)
{
  if (lista!=NULL){
  if (lista->sig!=NULL) liberaS(lista->sig);
  free(lista);}
}

/*Procedimiento Segdef*/
void Segdef(segmento  **Lista,FILE *fp)
/*Segdef es un registro que almacena la informacion de un segmento
  determinado, dicha informacion es crucial en la disposicion de los
  segmentos en el fichero ejecutable generado asi como para resolver
  la reubicacion del codigo y su enlace posterior con el registro de
  enlace (fixupp).
  La informacion que almacena es muy dispar, su alineamiento, la forma
  de combinarlo con otros segmentos, indices a nombresm su longitud, su
  tamao relativo (64 K u otros), si esta en modo protegido.
  Esta informacion ha de tomarse en cuenta.
  */
{
unsigned short frame=0,offs=0,longitud,seg,clase,overlay;
unsigned char alinea=0,combina,grande,p=0,c;

   c=fgetc(fp);
   alinea = (c &(BIT7+BIT6+BIT5)) >> 5; /*alinea, 3 bits mas significativos*/
   combina= (c &(BIT4+BIT3+BIT2)) >> 2; /*combina, 3 bits sigientes*/
   grande = (c & BIT1)            >> 1; /*grande, bit2*/
					/*falta p, bit utilizado para denotar
					  el uso del comando use32, o sea modo
					  protegido, por ahora no lo soporto
					  asi que en versiones futuras se
					  puede incluir este bit y enlace*/

   if (alinea==0)/*si la alineacion es 0, indica que es absoluta, indicando a
		su vez que la direccion se mostrara en los 4 bytes posteriores
		al byte que hemos leido, si no, estos campos no existen*/
     {
       char alto,bajo;
       bajo=fgetc(fp);
       alto=fgetc(fp);
       frame =bajo+(alto<<8);/*numero de frame*/
       bajo=fgetc(fp);
       alto=fgetc(fp);                                    
       offs  =bajo+(alto<<8);/*desplazamiento dentro del segmento*/

      }
   char alto,bajo;
   bajo=fgetc(fp);
   alto=fgetc(fp);

   longitud = bajo+(alto<<8);/*longitud*/
   indice(fp,&seg);/*indice de segmento*/
   indice(fp,&clase);/*indice de clase*/
   indice(fp,&overlay);/*indice de overlay*/

   insertaS(Lista,alinea,combina,grande,p,frame,offs,longitud,
	    seg,clase,overlay);
   fgetc(fp); /*sumatorio que ignoro*/
}
