// ZEUS! : ZEUS.C
#include <dos.h>
#include "defines.h"
#include "tipos.h"
#include "memoria.h"
#include "sistema.h"
#include "ZEUS.H"

tpEBCP far *BCPs;
tpEBCP far *Activo;
tpEBCP far **ZIP_del_nuevo_proceso; // Puntero al ZIP para actualizarlo ZEUS.
WORD SS_Zeus_Pila;
WORD SP_Zeus_Pila;

tpGestorInterrupcion Gestor_Interrupcion[ N_INTERRUPCIONES ] = {
  INT_TIC,	0
 };

void proceso_inicializador_de_ZEUS( void );

void interrupt GestorINT_TIC();
void interrupt GestorINT_TIC() {
}

void interrupt Servicios_ZEUS();
const unsigned long far *Tics = ( const unsigned long far * )MK_FP( 0x40, 0x6C ); // Contador Tic's
tpServicio far *Solicitado; // Servicio que han solicitado.
			    // NOTA: Ha de estar en el segmento de datos
			    // ya que si lo ponemos como una variable
			    // esttica que resida en la pila de llegada,
			    // cuando cambiemos a la pila del ZEUS no podremos
			    // acceder a ella ( al menos comodamente ).
 void ZEUS_Nuevo_Proceso( void );
 void ZEUS_Nuevo_Proceso( void ) {
  tpEBCP far *Nuevo;
  char far *Cima; // De la PILA del proceso.

  Nuevo = ( tpEBCP far * ) dame_memoria( sizeof( tpEBCP ) );
  // Aadido por JCD
  if( Solicitado->Prioridad_INT == 0 ) // El proceso la misma prioridad que el actual
    Nuevo->BCP.Prioridad = Activo->BCP.Prioridad;
   else
  // fin aadido por JCD
  if( Activo->BCP.Prioridad < Solicitado->Prioridad_INT )
   Nuevo->BCP.Prioridad = 0; // La menor de todas.
  else
   Nuevo->BCP.Prioridad = Activo->BCP.Prioridad - Solicitado->Prioridad_INT; // Le restamos la relativa a la actual.

  // Ponemos el ZIP del proceso, que es igual a la direccin del BCP :
   Nuevo->BCP.ZIP = ( void far * ) Nuevo;

  // Reservamos memoria para la pila de ste proceso :
   Nuevo->BCP.PILA =(char far *) dame_memoria( Solicitado->Taman );
   // Modificado por JCD
   // Cima = Nuevo->BCP.PILA + Solicitado->Taman - 1;
   Cima = Nuevo->BCP.PILA + Solicitado->Taman - 2;


  // Si no se dice lo contrario, el proceso est preparado :
   Nuevo->BCP.Estado = PREPARADO;
   Nuevo->BCP.Nombre =(char far *) Solicitado->Mensaje_Texto;
   Nuevo->BCP.TicsDeReferencia = *Tics;
   Nuevo->BCP.TicsEjecutados   = 0;

  // Ponemos en la PILA, Flags, CS e IP de la salida de INTERRUPCION.
   *( ( unsigned far * ) (Cima-0) ) = ESTADO_INICIAL_BANDERAS;
   *( ( unsigned far * ) (Cima-2) ) = Solicitado->CSreg;
   *( ( unsigned far * ) (Cima-4) ) = Solicitado->IPreg;

  // Inicializamos el puntero SS:SP a la primera posicin libre :
   Nuevo->BCP.SSreg = FP_SEGa( Cima );
   Nuevo->BCP.SPreg = FP_OFFa( Cima );
   Nuevo->BCP.SPreg -= 22; // Para situarlo en la posicin actual.
   Nuevo->BCP.BPreg = Nuevo->BCP.SPreg; // Apuntan al mismo sitio.

  // Ponemos los valores de aquellos registros importantes (DS) :
   *( ( unsigned far * ) (Cima-16) ) = _DS;

  // Inicializamos la cola de mensajes del proceso nuevo :
   Nuevo->BCP.NMensajes = 0; // No tiene ningn mensaje en la cola.
   Nuevo->BCP.Joven     = 0; // Hemos dicho que no tiene mensajes.
   Nuevo->BCP.Viejo     = 0; //  Que no tiene !.

  // No tiene ningn servicio pendiente :
   Nuevo->BCP.Servicio_Pendiente = 0;

  // Aadimos ste BCP a la lista de BCP's :
   Nuevo->Despues	= BCPs;
   BCPs->Antes		= Nuevo;
   BCPs			= Nuevo;
   Nuevo->Antes		= 0;

  // Devolvemos en el registro de solicitud de servicio el ZIP del
  // proceso creado, para que el padre sepa que hacer con l :
   Solicitado->ZIP = Nuevo->BCP.ZIP; // = ( void far * ) Nuevo;
 }

 void ZEUS_ZEUS_Recibir_Mensaje( void );
 void ZEUS_ZEUS_Recibir_Mensaje( void ) {
  tpEMensaje far *Sacado;

  Solicitado->Mensaje_Texto = Activo->BCP.Viejo->Mensaje.Mensaje; // Este es.
  Sacado = Activo->BCP.Viejo; // Vamos a liberar el primer e.mensaje.
  /* Esto es lo que coloco yo JCD */
  if(Activo->BCP.Viejo==Activo->BCP.Joven)  // Solo hay un mensaje
    { Activo->BCP.Viejo=Activo->BCP.Joven=0; }  // No hay mas mensajes;
   else
    { /* Buscamos el valor para Activo->BCP.Viejo */
      Activo->BCP.Viejo=Activo->BCP.Joven;
      while(Activo->BCP.Viejo->Siguiente!=0)  // Viejo apuntara al final de la lista
	Activo->BCP.Viejo=Activo->BCP.Viejo->Siguiente;
    }
//  Creo que lo que la linea de abajo esta mal : JCD
//  Activo->BCP.Viejo = Sacado->Siguiente; // El siguiente es el siguiente.
  libera_memoria( Sacado );
// Creo que estas dos lineas de abajo ya no son necesarias : JCD
//  if( Activo->BCP.Viejo == 0 )
//   Activo->BCP.Joven = 0; // Era el nico que haba en la lista.
  Activo->BCP.NMensajes--; // Hay uno menos.
 }

 void ZEUS_ZEUS_Activa_Mas_Prioridad( void );
 void ZEUS_ZEUS_Activa_Mas_Prioridad( void ) {
  tpEBCP far *Indice = BCPs;

  // Cogemos un BCP que est a PREPARADO :
   while( Indice->BCP.Estado != PREPARADO )
    Indice = Indice->Despues;
  // Miramos a ver que BCP preparado tiene mayor prioridad :
   Activo = Indice;
   Indice = Indice->Despues;

   while( Indice ) { // Mientras halla procesos en la lista...

    if( Indice->BCP.Estado == PREPARADO ) // ...si estando preparado...
     if( Indice->BCP.Prioridad >= Activo->BCP.Prioridad ) // ...tiene + prioridad ...
      Activo = Indice;	// ...lo hacemos el Activo.

    Indice = Indice->Despues; // Miramos el siguiente BCP.
   }
   // Si estaba pendiente de servicio, lo terminamos :
   // Esta linea creo que esta mal: JCD
   // if( Indice->BCP.Servicio_Pendiente != 0 ) {
   // if( Activo->BCP.Servicio_Pendiente != 0 ) {   // Linea modificada por JCD
   if( Activo->BCP.NMensajes ) {  // Linea modificada por JCD
     Activo->BCP.Estado = ACTIVO;
     Solicitado =( tpServicio * ) Activo->BCP.Servicio_Pendiente;
     Activo->BCP.Servicio_Pendiente = 0;
     if( Activo->BCP.NMensajes ) // En teora debera de dar siempre cierto.
       ZEUS_ZEUS_Recibir_Mensaje();
    }
   Activo->BCP.TicsDeReferencia = *Tics; // Nueva referencia.
   // Aqu, en Activo, est el proceso preparado con mayor prioridad.
   Activo->BCP.Estado = ACTIVO;

 }

 void ZEUS_Terminar( void );
 void ZEUS_Terminar( void ) {
  // Eliminamos el BCP actual de la lista de BCP's :

   // NOTA : No comprobamos el hecho de estar slos en la lista de
   // BSP's pues si nos vamos a eliminar nosotros, ha de haber alguien.
   if( ! Activo->Antes ) { // Soy el primero.
    Activo->Despues->Antes = 0;
    BCPs = Activo->Despues;
   } else if( ! Activo->Despues ) // Soy el ltimo.
    Activo->Antes->Despues = 0;
   else {
    Activo->Antes->Despues	= Activo->Despues;
    Activo->Despues->Antes	= Activo->Antes;
   }
   // LIBERAR MEMORIA DE LA COLA DE MENSAJES; SI QUEDAN.
   libera_memoria( Activo->BCP.PILA );
   libera_memoria( Activo );

  // Activamos el de mayor prioridad :
   ZEUS_ZEUS_Activa_Mas_Prioridad();
 }

 void ZEUS_Enviar_Mensaje( void );
 void ZEUS_Enviar_Mensaje( void ) {
  tpEBCP far *Receptor = ( tpEBCP far * ) Solicitado->ZIP;

  // Insertamos el mensaje en la cola de mensajes.
   if( Receptor->BCP.NMensajes ) // Hay mensajes en la cola.
    Receptor->BCP.Joven->Siguiente =( tpEMensaje far * ) Solicitado->Mensaje_Texto;
   else
    Receptor->BCP.Viejo = ( tpEMensaje far * )Solicitado->Mensaje_Texto;

  // Para poder insertar otro detrs del nuestro actualizamos :
   Receptor->BCP.Joven = ( tpEMensaje far * )Solicitado->Mensaje_Texto;

  // Hay un mensaje ms :
   Receptor->BCP.NMensajes++;

  // Sea como fuere, ahora tenemos que mirar cual tiene ms prioridad :
   if( Receptor->BCP.Prioridad > Activo->BCP.Prioridad ) {
    // Le expropiamos la CPU porque tenemos ms prioridad :
    Activo->BCP.Estado = PREPARADO;
    Activo->BCP.TicsEjecutados += *Tics - Activo->BCP.TicsDeReferencia;
    Receptor->BCP.Estado = ACTIVO;
    Activo = Receptor;
    Solicitado =( tpServicio far * ) Activo->BCP.Servicio_Pendiente;
    Activo->BCP.Servicio_Pendiente = 0;
    // Aqui creo que falta que se saquen el mensaje recibido.
    ZEUS_ZEUS_Recibir_Mensaje();  // Linea aadida por: JCd
   } else
    if( Receptor->BCP.Estado == BLOQUEADO )
     Receptor->BCP.Estado = PREPARADO; // Si estaba bloq. lo desbloq.
 }

 void ZEUS_Recibir_Mensaje( void );
 void ZEUS_Recibir_Mensaje( void ) {
  // Si tenemos mensajes en la cola, lo cogemos :
   if( Activo->BCP.NMensajes )
    ZEUS_ZEUS_Recibir_Mensaje();
   else { // Si no tenemos, nos bloqueamos y esperamos.
     Activo->BCP.Estado = BLOQUEADO;
     Activo->BCP.TicsEjecutados += *Tics - Activo->BCP.TicsDeReferencia;
     Activo->BCP.Servicio_Pendiente = Solicitado; // El que se haya solicitado
    // Activamos el de mayor prioridad :
     ZEUS_ZEUS_Activa_Mas_Prioridad();
   }
 }

void interrupt Servicios_ZEUS() {

 CLI;

 // Cogemos la direccin del servicio solicitado :
  Solicitado = ( tpServicio far * ) MK_FP( _DX, _BX );

 // Salvamos la pila en el BCP del proceso activo :
  Activo->BCP.SSreg = _SS;
  Activo->BCP.SPreg = _SP;
  Activo->BCP.BPreg = _BP;

 // Ponemos la pila de ZEUS! :
  _SS = SS_Zeus_Pila;
  _SP = SP_Zeus_Pila;

 // Tratamiento del servicio :
  switch( Solicitado->Servicio ) {
   case NUEVO_PROCESO   : ZEUS_Nuevo_Proceso(); break;
   case TERMINAR        : ZEUS_Terminar(); break;
   case ENVIAR_MENSAJE  : ZEUS_Enviar_Mensaje(); break;
   case RECIBIR_MENSAJE : ZEUS_Recibir_Mensaje(); break;
  }

 // Fin tratamiento del servicio.

 // Restauramos la pila del proceso activo :
  _SS = Activo->BCP.SSreg;
  _SP = Activo->BCP.SPreg;
  _BP = Activo->BCP.BPreg;

 STI;
}

void far *ZEUS_nuevo_proceso( unsigned CSr, unsigned IPr,
				      unsigned T_Pila,
				      char PrioridadRelativa,
				      char far *NombreProceso ) {
 tpServicio Servicio; // Vamos a solicitar un servicio a ZEUS.

 // Rellenamos los datos necesarios para realizar el servicio :
  Servicio.Servicio      = NUEVO_PROCESO;
  Servicio.CSreg         = CSr;
  Servicio.IPreg         = IPr;
  Servicio.Taman         = T_Pila;
  Servicio.Mensaje_Texto = NombreProceso;
  Servicio.Prioridad_INT = PrioridadRelativa;

 // Indicamos en el puntero DX:BX la direccin de nuestro registro de
 // solicitud de servicio para ZEUS! :
  _DX = FP_SEG( ( void far * ) &Servicio );
  _BX = FP_OFF( ( void far * ) &Servicio );

 // Solicitamos el servicio :
  INT( SERVICIOS_ZEUS );

 // Devolvemos el Identificador de Proceso :
  return ( void far * ) Servicio.ZIP;
}

void ZEUS_terminar() {
 tpServicio Servicio; // Vamos a solicitar un servicio a ZEUS.

 // Rellenamos los datos necesarios para realizar el servicio :
  Servicio.Servicio = TERMINAR;

 // Indicamos en el puntero DX:BX la direccin de nuestro registro de
 // solicitud de servicio para ZEUS! :
  _DX = FP_SEG( ( void far * ) &Servicio );
  _BX = FP_OFF( ( void far * ) &Servicio );

 // Solicitamos el servicio :
  INT( SERVICIOS_ZEUS );
}

void ZEUS_enviar_mensaje( void far *ZIP, void far *Mensaje ) {
 tpServicio Servicio; // Vamos a solicitar un servicio a ZEUS.
 tpEMensaje far *EMensaje;

 EMensaje = ( tpEMensaje far * ) dame_memoria( sizeof( tpEMensaje ) );

 // Rellenamos el mensaje :
  EMensaje->Siguiente = 0; 	 // Se insertar al final.
  EMensaje->Mensaje.Mensaje = Mensaje; // Lo que se enva.
  EMensaje->Mensaje.ZIP_Emisor = Activo; // Quin lo enva.

 // Rellenamos los datos necesarios para realizar el servicio :
  Servicio.Servicio      = ENVIAR_MENSAJE;
  Servicio.ZIP		 = ZIP;
  Servicio.Mensaje_Texto = ( void far * ) EMensaje;

 // Indicamos en el puntero DX:BX la direccin de nuestro registro de
 // solicitud de servicio para ZEUS! :
  _DX = FP_SEG( ( void far * ) &Servicio );
  _BX = FP_OFF( ( void far * ) &Servicio );

 // Solicitamos el servicio :
  INT( SERVICIOS_ZEUS );
}

void far *ZEUS_recibir_mensaje( void ) {
 tpServicio Servicio; // Vamos a solicitar un servicio a ZEUS.

 // Rellenamos los datos necesarios para realizar el servicio :
  Servicio.Servicio      = RECIBIR_MENSAJE;

 // Indicamos en el puntero DX:BX la direccin de nuestro registro de
 // solicitud de servicio para ZEUS! :
  _DX = FP_SEG( ( void far * ) &Servicio );
  _BX = FP_OFF( ( void far * ) &Servicio );

 // Solicitamos el servicio :
  INT( SERVICIOS_ZEUS );

 // Devolvemos el contenido del mensaje :
  return ( void far * ) Servicio.Mensaje_Texto;
}

int InicializaGestorMemoria( void );

main() {

 // Tomamos la posicin actual de la pila, como el inicio de la
 // pila para ZEUS!.
  SS_Zeus_Pila = _SS;
  SP_Zeus_Pila = _SP;

 // Modificado por: JCD
 // -> Inicializamos el gestor de memoria
 InicializaGestorMemoria();

 // fin modificado por JCD

 // Establece gestores interrupcin :
//  establece_int( INT_TIC, GestorINT_TIC );

 // Establece servicios del ZEUS! :
  setvect( SERVICIOS_ZEUS, ( void interrupt (far *)(...))Servicios_ZEUS );


 // Creamos y ponemos en la lista de BCP's el proceso de
 // inicializacin del ZEUS! :
  BCPs = ( tpEBCP far * ) dame_memoria( sizeof( tpEBCP ) );

  BCPs->Antes   = 0;  // No hay ninguno antes.
  BCPs->Despues = 0;  // Ni despus.

  BCPs->BCP.ZIP    = ( void far * ) BCPs; // Su direccin es su IP.
  BCPs->BCP.Estado = ACTIVO; // Como es el que se va a ejecutar primero...
  BCPs->BCP.Prioridad = 0xFF; // Le damos la mxima prioridad.

  BCPs->BCP.PILA  = ( char far * ) dame_memoria( PILA_INICIALIZADOR );
  BCPs->BCP.SSreg = FP_SEGa( BCPs->BCP.PILA + PILA_INICIALIZADOR - 1 );
  BCPs->BCP.SPreg = FP_OFFa( BCPs->BCP.PILA + PILA_INICIALIZADOR - 1 );

  BCPs->BCP.NMensajes = 0; // No tiene ningn mensaje en la cola.
  BCPs->BCP.Joven     = 0; // Hemos dicho que no tiene mensajes.
  BCPs->BCP.Viejo     = 0; //  Que no tiene !.

 // Como el activo es el nico que hay :
  Activo = BCPs;

 // Hacemos que la pila sea la del proceso activo :
  CLI;
  _SS = BCPs->BCP.SSreg;
  _SP = BCPs->BCP.SPreg;
  STI;

 //  Inicializamos ZEUS! !!!
  proceso_inicializador_de_ZEUS();

 return 0;
}