#include <alloc.h>
#include <STDIO.h>
#include <conio.h>
#include <string.h>
#include "ZGM\tiposmem.h"
#include "ZGM\mem.h"
#include "ZGM\errormem.h"
#define MEMORIA_MINIMA  100L*1024L // memoria minima aceptable : Zeus y algo mas

TpBCPMemoria far * ListaBCPM=NULL;                 // Lista de bloque de memoria ocupadas
DWORD TotalMemoria,MemDisponible;  // Contendr la memoria que tenga el sistema medida en K

void far * LongToVoidFar(DWORD valor,int alinear=FALSE){
    void far * p=NULL;
    (unsigned long int)p =  ((valor << 12) & 0xffff0000L) + (valor & 0x0000000fL) ;
    if((valor & 0x0000000F) && alinear)  //Est desalineado
	{
	   (unsigned long int)p += 0x00010000;
	   (unsigned long int)p &= 0xffff0000;
	}
    return(p);
}

DWORD VoidFarToLong(void far * puntero)
 {
   unsigned int segmento,offset;

   segmento = ((unsigned long)puntero) >> 16;
   offset   = ((unsigned long)puntero) & 0x0000ffff;
   return((((unsigned long)segmento)<<4) +(unsigned long)offset);
 }


int InicializaGestorMemoria( void )
  {
    TpBCPMemoria far *BCPMprimero;
    TpBCPMemoria far *BCPMultimo;

    if(ListaBCPM!=NULL)
      return(ERROR_INIT_MEM);

    // vemos cuanta memoria hay disponible en el sistema
    TotalMemoria=farcoreleft()-(4L*1024L);

    // Se comprueba que la memoria disponible sea suficiente
    if(TotalMemoria<MEMORIA_MINIMA)
      return(NO_MEM);

    // Reservamos memoria
    ListaBCPM=(TpBCPMemoria far *)farmalloc( TotalMemoria );

    if( ListaBCPM == NULL )
      // Este error es inesperado. Se ha comprobado ya que la memoria esta
      //  disponible
      return(ERR_INESP_1);

    // Procedemos a inicializar la Lista de BCPM's
    BCPMprimero=ListaBCPM;
    BCPMultimo =pBCPM( VoidFarToLong(ListaBCPM) + TotalMemoria - LONG_BCPM );

    // Inicializamos la lista
    BCPMprimero->DireccionMemoria=VoidFarToLong( BCPMprimero ) + LONG_BCPM;
    BCPMprimero->Long            = 0;
    BCPMprimero->Proceso         = 0;  // No utilizado.
    BCPMprimero->Atributos       = 1;  // No se puede borrar.
    BCPMprimero->Sig             = BCPMultimo;
    BCPMprimero->Ant             = NULL;

    BCPMultimo->DireccionMemoria= VoidFarToLong( BCPMultimo ) + LONG_BCPM;
    BCPMultimo->Long            = 0;
    BCPMultimo->Proceso         = 0;  // No utilizado.
    BCPMultimo->Atributos       = 1;  // No se puede borrar.
    BCPMultimo->Sig             = NULL;
    BCPMultimo->Ant             = BCPMprimero;

    // volvemos devolviendo no error
    return(NO_ERROR);
  }

int QuitaGestorMemoria( void )
  {
    int Error=NO_ERROR;
    // verificamos la integridad del Sistema de memoria
    Error=VerificaIntegridadMemoria();
    if( Error!=NO_ERROR )
      // Hay un error en la lista de memoria
      return( Error );

    // devolvemos la memoria al DOS
    farfree(ListaBCPM);
    // Asignamos NULL
    ListaBCPM=NULL;
    return(NO_ERROR);
  }

int VerificaIntegridadMemoria( void )
  {
    TpBCPMemoria far *pRecorreBCPM=ListaBCPM;
    int Error=NO_ERROR;

    // Verificamos que el gestor de memoria esta inicializado
    if( ListaBCPM == NULL)
      // No se ha inicializado el Gestor de memoria
      return(GESTOR_NO_INIT);
    // Se supone que ListaBCPM Apunta al primero, luego Ant== NULL
    if( ListaBCPM->Ant != NULL)
      // El primer elemento de la lista no es correcto.
      return(LISTA_BCPM_CORRUPTA);
    // Recorremos la lista de BCPM's en busca de alguna incoherencia.
    while( pRecorreBCPM != NULL )
      {
	 // Verificamos que sea un BCPM valido
	 Error= VerificaBCPM( pRecorreBCPM );
	 if( Error != NO_ERROR )
	   // Error!!! BCMP No valido.
	   return( Error );

	 // Comprobamos que entre este BCPM y el siguientes haya como minimo
	 //  el tamao de la memoria reservada por el BCPM Actual.
	 Error=VerificaHueco( pRecorreBCPM );
	 if( Error!=NO_ERROR )
	   // No es posible que Long sea mayor que LongHueco-> Error!!
	   return( Error );

	 // Pasamos a comprobar el siguiente BCPM
	 pRecorreBCPM = pRecorreBCPM->Sig;
      }
    // No ha ocurrido Ningun Error
    return( NO_ERROR );
  }

int VerificaBCPM( TpBCPMemoria far *pBCPMem)
  {
     DWORD lTmp;
     // Verificamos que sea un BCPM valido
     lTmp = VoidFarToLong( pBCPMem ) + LONG_BCPM;
     if( pBCPMem->DireccionMemoria != lTmp )
       // Error!!! BCMP No valido.
       return(BCPM_NO_VALIDO);
     // Se ha verificado el check
     return( NO_ERROR );
  }

int VerificaHueco( TpBCPMemoria far *pBCPMem )
  {
    DWORD DirBCPM1  = VoidFarToLong( pBCPMem      );
    DWORD DirBCPM2  = VoidFarToLong( pBCPMem->Sig );
    DWORD LongHueco = DirBCPM1 + LONG_BCPM;
    int Error;

    // Verificamos que los BCPM's sean Validos
    Error=VerificaBCPM( pBCPM( DirBCPM1 ) );  // Se verifica el BCPM1
    if( Error!= NO_ERROR )
      // BCPM no valido
      return( Error);
    if( pBCPMem->Sig == NULL )
      // Estamos al final de la lista y no hay hueco
      return( NO_ERROR );
    Error=VerificaBCPM( pBCPM( DirBCPM2 ) );  // Se verifica el BCPM2
    if( Error!= NO_ERROR )
      // BCPM no valido
      return( Error);

    // Miramos si es el ultimo BCPM
    if( pBCPMem->Sig == NULL ) // Es el ultimo BCPM
     {
       if( pBCPMem->Long!=0 )
	 // Longuitud del ultimo BCP incorrecto
	 return( LISTA_BCPM_CORRUPTA );
       else
	 return( NO_ERROR );
     }

    // Terminamos de calcular LongHueco
    LongHueco -= DirBCPM2;  // LongHueco calculado.
    // Se verifica que la Long del BCP Actual sea menor o igual
    //  Al hueco existente entre el BCPM Actual y el BCPM siguiente.
    if( pBCPMem->Long > LongHueco )
      // No es posible que Long sea mayor que LongHueco-> Error!!
      return(TAM_HUECO_NO_VALIDO);
    // El tamao del hueco es valido
    return( NO_ERROR);
  }

DWORD DameLongHueco( TpBCPMemoria far *pBCPMactual, int far *Error )
  {
    DWORD LongHueco = 0L;

    (*Error) = NO_ERROR;
    // Verificamos que el BCP Actual...
    (*Error) = VerificaBCPM ( pBCPMactual );
    if( (*Error)!= NO_ERROR )
      // BCPM no valido
      return( 0 );

    // ...y el BCP siguiente sean integros.
    (*Error) = VerificaBCPM ( pBCPMactual->Sig );
    if( (*Error)!= NO_ERROR )
      // BCPM no valido
      return( 0 );

    // Calculamos el Tamao del hueco...
    LongHueco = VoidFarToLong( pBCPMactual->Sig );
    LongHueco-= pBCPMactual->DireccionMemoria+pBCPMactual->Long;

    return( LongHueco );
  }

DWORD DameMemoriaDisponible( int far *Error )
  {
     DWORD TotalLibre = 0L;
     TpBCPMemoria far *pBCPMactual = ListaBCPM;

     (*Error) = NO_ERROR;

     // Verificamos la integridad de la memoria
     (*Error) = VerificaIntegridadMemoria();
     if( (*Error) != NO_ERROR )
       // La memoria no es fiable....
       return( 0 );

     // Empezamos a contar los huecos que quedan libres entre BCPM's
     while( pBCPMactual->Sig != NULL )
       { // Vamos contando los huecos
	 TotalLibre += DameLongHueco( pBCPMactual, Error);
	 pBCPMactual = pBCPMactual->Sig;
       }
     // Devolvemos el valor calculado
     return( TotalLibre );
  }

DWORD DameMemoriaOcupada( int far *Error )
  {
     DWORD TotalOcupado = 0L;
     TpBCPMemoria far *pBCPMactual = ListaBCPM;

     (*Error) = NO_ERROR;

     // Verificamos la integridad de la memoria
     *Error = VerificaIntegridadMemoria();
     if( (*Error) != NO_ERROR )
       // La memoria no es fiable....
       return( 0 );

     // Procedemos a contar lo ocupado.
     while( pBCPMactual != NULL )
       { // Se tiene en cuenta lo reservado mas el BCPM
	 TotalOcupado += pBCPMactual->Long+ LONG_BCPM;
	 pBCPMactual   = pBCPMactual->Sig;
       }

     // Devolvemos el dato calculado
     return( TotalOcupado );
  }

TpBCPMemoria far *DameAdrNuevoBCPM( TpBCPMemoria far *pBCPMactual )
  {
     DWORD lTmp;
     TpBCPMemoria far *pTmp;

     // Calculamos donde esta el final de la memoria ocupada por BCPMactual
     lTmp = pBCPMactual->DireccionMemoria+pBCPMactual->Long;
     // Le sumamos el tamao del BCPM
     lTmp += LONG_BCPM;

     pTmp=(TpBCPMemoria far *)LongToVoidFar( lTmp, TRUE );  // Me calcula la direccion de donde
							    //  epieza la memoria de usuario del
							    //  BCP Nuevo
     // Le restamos la longitud de BCPM, que esta inmediatamente antes.
     lTmp=VoidFarToLong( pTmp ) - LONG_BCPM;
     // Convertimos la direccion de memoria en Adr.de mem. valida
     pTmp=(TpBCPMemoria far *)LongToVoidFar( lTmp );

     // Devolvemos la Adr. de memoria del nuevo BCPM
     return( pTmp );
  }

int InsertaBCPM( TpBCPMemoria far *pBCPMactual, TpBCPMemoria far *pBCPMnuevo )
  {
     int Error;
     // Validamos BCPM actual
     Error=VerificaBCPM( pBCPMactual );
     if( Error != NO_ERROR )
       // BCPM no valido
       return( Error );
     // Validamos BCPM nuevo
     Error=VerificaBCPM( pBCPMnuevo );
     if( Error != NO_ERROR )
       // BCPM no valido
       return( Error );
     // Validamos BCPM siguiente
     Error=VerificaBCPM( pBCPMactual->Sig );
     if( Error != NO_ERROR )
       // BCPM no valido
       return( Error );

     // Lo insertamos en la lista
     pBCPMnuevo->Sig=pBCPMactual->Sig;
     pBCPMnuevo->Ant=pBCPMactual;

     pBCPMactual->Sig->Ant=pBCPMnuevo;
     pBCPMactual->Sig     =pBCPMnuevo;

     // volvemos
     return( NO_ERROR );
  }

int BorraBCPM( TpBCPMemoria far *pBCPMactual)
  {
     int Error;
     // Validamos BCPM actual
     Error=VerificaBCPM( pBCPMactual );
     if( Error != NO_ERROR )
       // BCPM no valido
       return( Error );
     // Validamos BCPM anterior
     Error=VerificaBCPM( pBCPMactual->Ant );
     if( Error != NO_ERROR )
       // BCPM no valido
       return( Error );
     // Validamos BCPM siguiente
     Error=VerificaBCPM( pBCPMactual->Sig );
     if( Error != NO_ERROR )
       // BCPM no valido
       return( Error );

     // Se elimina de la lista
     pBCPMactual->Ant->Sig=pBCPMactual->Sig;
     pBCPMactual->Sig->Ant=pBCPMactual->Ant;

     // Volvemos
     return( NO_ERROR );
  }

int EsLiberable( TpBCPMemoria far *pBCPMactual )
  {
    // Esto..... no necesita ser comentado... :)
    if( ( pBCPMactual->Atributos & 0x01 ) == 0x01 )
      return( FALSE  );
     else
      return( TRUE );
  }

DWORD DameLongHuecoAsignable( TpBCPMemoria far *pBCPMactual )
  {
     DWORD LongHueco = 0L, PpioMem = 0L;
     TpBCPMemoria far *pTmp;
     int Error;

     // Calculamos el tope
     LongHueco = VoidFarToLong( pBCPMactual->Sig );
     // Miramos si es mayor que cero
     if( LongHueco == 0 )
       // EL hueco asignable es 0
       return( 0 );
     // Calculamos la Adr del Futuro BCPM
     pTmp      = DameAdrNuevoBCPM( pBCPMactual );
     PpioMem   = VoidFarToLong( pTmp ) + LONG_BCPM;
     LongHueco-= PpioMem;

     // Buf... por fin podemos volver... :)
     return( LongHueco );
  }

// Ahora las gansas.... :(

void far *AsignaMemoria( DWORD Bytes, unsigned char Atributos, DWORD ZIP )
  {
     int Error=NO_ERROR;
     TpBCPMemoria far *pBCPMnuevo;
     TpBCPMemoria far *pBCPMelegido;
     TpBCPMemoria far *pRecorreBCPM=ListaBCPM;
     DWORD MejorHueco = 0L;
     DWORD LongHueco  = 0L;
     void far *AdrDevuelto;

     // Comprobamos la integridad de la memoria antes de hacer nada
     Error= VerificaIntegridadMemoria();
     if( Error != NO_ERROR )
       // Oh, Oh!! Error  :(
       return(NULL);

     // El mejor hueco, como no, seria tener toda la mem para mi... :)
     MejorHueco = TotalMemoria;

     while( pRecorreBCPM->Sig != NULL )
       {
	  // Obtenemos la longitud del hueco actual
	  LongHueco = DameLongHuecoAsignable( pRecorreBCPM );
	  if( (LongHueco >= Bytes) && (LongHueco < MejorHueco) )
	    {  // Nos quedamos con este hueco
	       MejorHueco   = LongHueco;
	       pBCPMelegido = pRecorreBCPM;
	    }
	   pRecorreBCPM = pRecorreBCPM->Sig;
       }
     // Verificamos se haya asignado otro hueco...
     if( MejorHueco == TotalMemoria )
       // No hay memoria disponible
       return(NULL);

     // Obtenemos la Adr. del BCP nuevo

     pBCPMnuevo = DameAdrNuevoBCPM( pBCPMelegido );

     // Rellenamos la estructura
     pBCPMnuevo->DireccionMemoria = VoidFarToLong( pBCPMnuevo) + LONG_BCPM;
     pBCPMnuevo->Atributos        = Atributos;
     pBCPMnuevo->Proceso          = ZIP;
     pBCPMnuevo->Long             = Bytes;

     // Insertamos el Nuevo BCPM en la Lista de BCPM's
     Error=InsertaBCPM( pBCPMelegido, pBCPMnuevo );
     if( Error!= NO_ERROR)
       // :( Error :''(
       return( NULL );

     // Comprobamos la integridad de la memoria despues de asignar
     Error= VerificaIntegridadMemoria();
     if( Error != NO_ERROR )
       // Oh, Oh!! Error  :(
       return(NULL);

     // Si todo ha salido bien devolvemos el puntero  de la Adr.
     AdrDevuelto = (void far *)pBCPM( pBCPMnuevo->DireccionMemoria );
     return( AdrDevuelto );
  }

int LiberaMemoria( void far *AdrALiberar )
  {
     int Error=NO_ERROR;
     TpBCPMemoria far *pBCPMaLiberar= NULL;

     // Comprobamos la integridad de la memoria antes de hacer nada
     Error= VerificaIntegridadMemoria();
     if( Error != NO_ERROR )
       // Oh, Oh!! Error  :(
       return( Error );

     // Calculamos la Adr del BCP a liberar...
     pBCPMaLiberar=pBCPM( VoidFarToLong( AdrALiberar ) - LONG_BCPM );

     // Chequamos BCPM valido
     Error = VerificaBCPM( pBCPMaLiberar );
     if( Error!=NO_ERROR)
       // Errror! :(
       return( Error );

     // Verificamos si es liberable
     if( !EsLiberable( pBCPMaLiberar ) )
       // No se puede liberar
       return( NO_ES_LIBERABLE );

     // Se elimina el BCPM de la lista
     Error=BorraBCPM( pBCPMaLiberar );
	  if( Error!=NO_ERROR)
       // Errror! :(
       return( Error );

     // Comprobamos la integridad de la memoria despues de hacer algo.. O;)
     Error= VerificaIntegridadMemoria();
     if( Error != NO_ERROR )
       // Oh, Oh!! Error  :(
       return( Error );

     // si llegamos aqui... 'To' t'a bien.
     return( NO_ERROR );  // "This is an unrecheable code" =:)
  }

void MuestraListaBCPMs( char Mascara , char far *Zip)
  {
	 //  Mascara
	 //
	 //   7  6  5  4  3  2  1  0
	 //  Ŀ
	 //        108 4 2 1 
	 //  
	 //                    > Cabezera
	 //                   > Info sobre Todos procesos
	 //                 > Filtro por procesoZIP
	 //               > Pausa ( 0:No 1:Si )
	 //             > Info Totales

     int Error,NumLineas;
     TpBCPMemoria far *pTmp=ListaBCPM;
     char far *DameAtrib[]={"LIBERABLE","NO LIBERABLE"};
     static char cTmp[20];

     if ( Mascara & 0x01 )
      {
	printf("\n");
	printf("  Lista de bloques de memoria :\n");
	printf("------------------------------------------------------------------------\n");
	printf(" %10s %8s        %10s  %10s \n","Adr.Mem.","Tamao","ZIP","Atributos");
	printf("------------------------------------------------------------------------\n");
      }
     while( pTmp!= NULL && (Mascara & 0x02) )
       {
	 NumLineas++;
	 if( Mascara & 0x4 )
	   {  // Se aplica el filtro
	      sprintf(cTmp,"%08lx",pTmp->Proceso);
	      if( strcmp( Zip, cTmp ) == 0 )
		 printf(" 0x%08lX %8lu Bytes. 0x%08lX %10s \n",
			pTmp->DireccionMemoria,
			pTmp->Long,
			pTmp->Proceso,
			DameAtrib[pTmp->Atributos] );
	    }
	   else
	    printf(" 0x%08lX %8lu Bytes. 0x%08lX %10s \n",
		     pTmp->DireccionMemoria,
		     pTmp->Long,
		     pTmp->Proceso,
		     DameAtrib[pTmp->Atributos] );

	 if( (NumLineas >18)  && (Mascara & 0x08) )
	   { printf("  Pulse una tecla para continuar....");
	     getch();
	     printf("\n");
	     NumLineas=0;
	   }
	 pTmp=pTmp->Sig;
       }
     if( Mascara & 0x10 )
       {
	  printf("\n");
	  printf("       Total Memoria en Sistema : %13lu Bytes.\n",TotalMemoria);
	  printf("       Total Memoria Libre      : %13lu Bytes.\n",DameMemoriaDisponible( &Error ));
	  printf("       Total Memoria Ocupada    : %13lu Bytes.\n",DameMemoriaOcupada( &Error ));
	  printf("\n");
       }
  }
