#include <dos.h>
#include <stdio.h>
#include <stdarg.h>
#include "ZGT\Tipos.H"
#include "zgt\teclado.h"

/*Estas definiciones se utilizan para realizar mascaras a nivel de bit,
  Muy utiles para cuando los campos se miden a nivel de bits*/
#define BIT7    0x80
#define BIT6    0x40
#define BIT5    0x20
#define BIT4    0x10
#define BIT3    0x08
#define BIT2    0x04
#define BIT1    0x02
#define BIT0    0x01


char Ct,Cb;

void Z_printf(char far *format,...)
{
  char aux[255];
  va_list ap;

   va_start(ap,format);
   vsprintf(aux,format,ap);
   Z_puts(aux);
   va_end(ap);
}

void Z_scanf(char far *format,...)
{
  char aux[255];
  va_list ap;

   Z_gets(aux);
   va_start(ap,format);
   vsscanf(aux,format,ap);
   va_end(ap);
}


void Z_putch(char c,char p,char f)
{
  struct REGPACK regs;

  if (c=='\t')
    {
      char i;
      for(i=0;i<8;i++)
	{
	   regs.r_ax=0x0E00+' ';
	   regs.r_bx=p<<8+f;
	   intr(0x10,&regs);
	}
    } else
  {
    regs.r_ax=0x0E00+c;
    regs.r_bx=p<<8+f;
    intr(0x10,&regs);
  }
}

void Z_puts(char far *str)
{
char i;

  for(i=0;str[i]!='\0';i++)
    {
     Z_putch(str[i],0,0);
     if(str[i]=='\n') Z_putch('\r',0,0);
    }
}

void Z_GetCursor(char pag,char far *pCt,char far *pCb,char far *pfila,char far *pCol)
{
  REGPACK regs;

  regs.r_ax=0x0300;
  regs.r_bx=pag<<8;
  intr(0x10,&regs);
  *pCt=regs.r_cx>>8;
  *pCb=regs.r_cx&0xff;
  *pfila=regs.r_dx>>8;
  *pCol=regs.r_dx&0xff;
  Ct=*pCt;
  Cb=*pCb;
}

void Z_SetCursorP(char fila,char col,char pag)
{
  REGPACK regs;

  regs.r_ax=0x0200;
  regs.r_bx=pag<<8;
  regs.r_dx=(fila<<8)+col;
  intr(0x10,&regs);
}

void Z_Cursoron()
{
  REGPACK regs;

  regs.r_ax=0x0100;
  regs.r_cx=(Ct<<8)+Cb;
  intr(0x10,&regs);
}

void Z_Cursoroff()
{
  REGPACK regs;

  regs.r_ax=0x0100;
  regs.r_cx=0x2000;
  intr(0x10,&regs);
}


void Z_Setcursor(char top,char botton)
{
  REGPACK regs;

  regs.r_ax=0x0100;
  regs.r_cx=(top<<8)+botton;
  intr(0x10,&regs);
}


char Z_Setkey(char k)
{
 /*Se le introduce el caracter en Ascii
   Devuelve 00 si todo ha ido bien
   y 01 si no*/
 REGPACK regs;
 regs.r_ax=0x0500;
 regs.r_cx=k;
 intr(0x16,&regs);
 return(regs.r_ax);
}

void Z_GetState(flags far *Keyf)
{ /*Obtiene valores de teclado como las pulsaciones de las teclas
    de mayusculas, cotrol y Alteracion...*/
  Keyf->entero=*(unsigned far *)0x417;
  Keyf->kflags.RAlt=(*(char far *)0x496&BIT3)>>3;
  Keyf->kflags.RCtrl=(*(char far *)0x496&BIT2)>>2;
}

int Z_kbhit()
{
 /*comprueba si se ha pulsado una tecla, pero no tomamos su codigo.
   Otra forma de hacerlo es tomando la interrupcion 9 que esta levante un
   flag que nos indique si se ha pulsado una tecla, posibilidad que
   pudiera tomarse en implementaciones futuras con el fin de que el gestor
   pudiera mantenerse dormido hasta que se pulsase una tecla*/

      struct REGPACK regs;

  regs.r_ax=0x1100;
  intr(0x16,&regs);
  return(regs.r_flags&BIT6);
}

int Z_getch()
{
  /*Espera que se pulse una tecla y devuelve el valor ascii de esta*/

      struct REGPACK regs;

  regs.r_ax=0x1000;
  intr(0x16,&regs);
  return(regs.r_ax&0x00ff);
}


char far *Z_gets(char far *str)
{/*Simula el comportamiento de la rutina implementada en C, pero sin utilizar
  los canales de E/S*/
     int k=0,i=0;
  while(k!=13)
    {
      k=str[i]=Z_getch();
      switch(str[i]){
	case 8: /* Tecla de borrado */
	  if(i>0)
	    {
	      i--;
	      Z_puts("\b \b");
	    }
	  break;
	default:
	  Z_putch(str[i++],0,0);
      }
    }
  str[i-1]='\0';
  Z_puts("\n");

  return(str);
}