//
// Archivo    : EXEC.C
// Descripcin: Archivo de cdigo fuente que contiene las rutinas de usuario
//              que pueden ser llamadas desde el shell y que son compiladas con
//              el ncleo del sistema.
// Resp. Mant.: Javier Cuevas ( jcd@arrakis.es )
// Ult. Modif.: 23/07/97
//
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include "defines.h"	// Definiciones de 	ZEUS!
#include "tipos.h"	// Tipos de 		ZEUS!
#include "ZEUS.H"	// Servicios de 	ZEUS!
#include "memoria.h"	// Gestor de memoria.
#include "ZSF\CTRDISCO.H"
#include "ZSF\ERROR.H"
#include "ZSF\ZSF.H"
#include "ZSF\exec.h"

void far Aplic1( void );
extern void far DlxSim( void );     // Funcion que esta en "DLX/dlxsim.cpp"
extern void far Compilador( void ); // Funcion que esta en "DLX/compila.cpp"

TpAplic ListaAplicUsusario[]= { {TRUE,"Aplic1"     , Aplic1 },
				{TRUE,"DlxSim"     , DlxSim },
				{TRUE,"Compilador" , Compilador },
				{FALSE,""          , 0L     },
			      };

void FuncUsuario(int NumProg)
  {
     ((void (far *)())ListaAplicUsusario[NumProg].Aplicacion)();
  }

/* Esta aplicacion de usuario crea dos procesos que se envian 2 mensajes */
extern tpEBCP *Activo;
extern TZIP ZeusShell;

void Muestra_Lista_BCPs( void );
void PProc1( void );

void _PProc1( void ); void PProc1() { _PProc1(); }
void _PProc1( void ) {
    int Cont=0;
    tpEBCP far *Proc;

    printf("     Proceso %10s : Creado \n",Activo->BCP.Nombre);
    printf("                     %4u Mensajes recibidos.\n ",Activo->BCP.NMensajes);
    Muestra_Lista_BCPs();
    getch();
    while( Cont<2 )
      { printf("    Proceso %10s : Esperando mensaje \n",Activo->BCP.Nombre);
	Proc=(tpEBCP far *)ZEUS_recibir_mensaje();
	printf("    Proceso %10s : Mensaje recibido de [%10s]. \n",Activo->BCP.NMensajes,Proc->BCP.Nombre);
	printf("                    Enviando mensaje a %10s\n",Proc->BCP.Nombre);
	Cont++;
	if( strcmp(Activo->BCP.Nombre,"Proc2")==0 && Cont==2 )
	  ZEUS_enviar_mensaje( ZeusShell , 0 );
	 else
	  ZEUS_enviar_mensaje( Proc->BCP.ZIP , Activo );
      }
    printf("    Proceso %10s : Terminado.\n",Activo->BCP.Nombre);
    ZEUS_terminar();
 }



void far Aplic1( void )
 {
   static TZIP Proc1;
   static TZIP Proc2;

   Proc1 = ZEUS_nuevo_proceso( _CS , (unsigned)PProc1, 5000, 0 , "Proc1");
   Proc2 = ZEUS_nuevo_proceso( _CS , (unsigned)PProc1, 5000, 0 , "Proc2");

   ZEUS_enviar_mensaje( Proc1 , Proc2 );

   ZEUS_recibir_mensaje();

   Muestra_Lista_BCPs();
   getchar();
 }
