/* defines utilidados */
#define WORD   unsigned short
#define BYTE   unsigned char
#define DWORD  unsigned long
#define TRUE  1
#define FALSE 0
 /* definicion de estrupturas de datos */

 /* Entrada de particion */
 typedef struct {
    unsigned char ParticionActiva;/* 0 -> P. inactiva; 0x80 ->P. Arranque */
    unsigned char CabezaInicio;   /* Cabeza de inicio Particion */
    unsigned char SectorInicio;   /* bits 0..5 (sector inicio);
				     bits 6,7 Parte alta del numero de cilindro*/
    unsigned char CilindroInicio; /* Parte baja del numero de cilindro*/
    unsigned char TipoParticion;  /* Tipo de particion  */
    unsigned char CabezaFin;      /* Cabeza de fin Particion */
    unsigned char SectorFin;      /* bits 0..5 (sector fin);
				     bits 6,7 Parte alta del numero de cilindro*/
    unsigned char CilindroFin;    /* Parte baja del numero de cilindro */
    DWORD SectoresRelativosInicio;/* Numeros de sectores desde el inicio
				     del disco hasta el comienzo de la particion */
    DWORD LongParticionEnSectores;/* Tamao de la particion en Sectores */
 }TpEntradaParticion;

 /* Sector de arranque */

 typedef struct {
      char basura[3];          /* Informacion basura */
      BYTE IdDelSistema[8];       /* Identificacion del sistema */
      WORD BytesPorSector;     /* Bytes por sector */
      BYTE SectoresPorCluster; /* SectoresPorCluster */
      WORD SectoresReservados; /* Sectores reservados al inicio */
      BYTE CopiasFAT;          /* Numero de copias de la FAT   */
      WORD EntradasRaiz;       /* Numero de entradas en el dir. Raiz */
      WORD TotalSectores1;     /* Total sectores en disco. Si >32Mb => 0 */
      BYTE TipoDisco;          /* Tipo de disco */
      WORD SectoresPorFAT;     /* Numero de sectores ocupado por cada FAT */
      WORD SectoresPorPista;   /* Numero de sectores por pista */
      WORD Cabezas;            /* Numero de cabezas */
      DWORD SectAsumarAlDOS;   /* Numero de sectores reservados. A sumar a
				  los sectores del DOS. 0 en unidades de
				  disquete */
      DWORD TotalSectores2;    /* Total sectores en disco para >32Mb */
      BYTE NumUnidadFisica;    /* Numero de unidad fisica */
      BYTE Reservado;          /* Byte reservado */
      BYTE Validacion;         /* Byte de validacion. Vale 0x29 si los bytes
				   entre el 26 y el 61 son validos */
      DWORD NumeroSerie;       /* Numero de serie */
      BYTE TituloDisco[11];    /* Titulo del disco */
      BYTE SistemaFicheros[8];    /* Tipo de sistema de ficheros "FAT12  " o
							      "FAT16  " */
   } TpSectorArranque;

typedef struct _TpRegistroCache {
    WORD ID;                 /* Identificador de entrada en cache       */
    WORD NumCluster;         /* Numero de Cluster                       */
    WORD Pos;                /* Registro de Reubicacion                 */
    DWORD NumAccesos;        /* Numero de Acceso al Cluster             */
    BYTE Modificado;         /* Controla si se ha escrito en el Cluster */
    void far *Buffer;            /* Puntero a la Copia del Cluster en Mem */
    struct _TpRegistroCache far *Sig;  /* Puntero al Siguiente Cluster En Cache */
    struct _TpRegistroCache far *Ant;  /* Puntero al Anterior  Cluster En Cache */
  } TpRegistroCache;

 /*  Entrada en directorio */

 typedef struct {
   char     Nombre[8];      // Nombre del fichero.
   char     Extension[3];   // Extensin del fichero.
   BYTE     Atributos;      // Atributos del fichero.
   char     Reservado[10];  // 10 Bytes reservados.
   WORD     Hora;           // La hora de ltima modificacon del fichero.
   WORD     Fecha;          // La fecha de ltima modificacon del fichero.
   WORD     EntradaFAT;     // Nmero del 1 Cluster del fichero.
   DWORD    LongEnBytes;    // Tamao del fichero en Bytes.
   } TpEntradaDir;


  typedef struct {
    BYTE Unidad;                     /* Unidad BIOS */
    TpSectorArranque SectorArranque; /* Copia del Sector de Arranque */
    DWORD LongFAT;                    /* Longitud de la FAT */
    BYTE TipoFAT;                    /* TipoFat : FAT12 ; FAT16 */
    BYTE ModificadoFAT;              /* True ->Si se ha escrito en alguna FAT */
    char far *FAT1;                      /* Copia de la FAT1 */
    char far *FAT2;                      /* Copia de la FAT2 */
    BYTE ModificadoRaiz;             /* True ->Si se hubira modificado alguna */
				     /*         entrada en el Raiz */
    TpEntradaDir far *Raiz;              /* Copia del Dir Raiz */
    /* Datos sobre la unidad */
    WORD  NumCilindros;
    DWORD TotalClusters;
    DWORD TotalSectoresDeDatos;
    DWORD TotalEnBytes;
    /* Coordenadas BIOS  de inicio de los Datos */
    WORD Cilindro;
    BYTE Cabeza,Sector;
    TpRegistroCache far *Cache;          /* Puntero Base de memoria Cache */
    } TpInformacionUnidad;

/* definimos el Handle del Sistema */
typedef struct {
  TpEntradaDir             EntradaDir;         // Copia de la entrada de directorio del fichero.
  DWORD                    NumClusterEntrDir;  // Nmero del cluster donde se encuentra la entrada de directorio del fichero
  WORD                     NumEntrDir;         // Nmero de entrada de directorio dentro del cluster.
  TpInformacionUnidad far  *Unidad;            // Puntero a la unidad donde esta el fichero.
  DWORD                    BytesLeidos;        // Posicin respecto al inicio del fichero de la cabeza lectora.
  DWORD                    BytesLeidosEnClusterActual;  // Posicion dentro del cluster actual de la cabeza lectora.
  WORD                     ClusterActual;      // Cluster de donde esta leyendo la cabeza lectora.
  BYTE                     ModoDeApertura;     // Mode de apertura del fichero. De momento no se usa.
  BYTE                     Eof;                // Marca de fin de fichero. TRUE si se ha llegado y FALSE si no se ha llegado.
  } TpHandle;


/********** Implementacion del Nucleo del Sistema de Ficheros *********/

typedef struct _SistemaDeFicheros {
    char far *Ruta;                    /* Ruta Base del sistema de ficheros */
    TpInformacionUnidad Unidad;    /* Unidad Asociada                   */
    WORD HandleInicial;            /* Handle Inicial                    */
    struct _SistemaDeFicheros far *Sig;/* Puntero a la siguiente Unidad     */
   } TpSistemaDeFicheros;

typedef struct _FicherosAbiertos {
   WORD ID;                       /* Indentificador del fichero */
   char far *Ruta;                // Ruta del fichero
   TpHandle far *Handle;              /* Informacion acerca del fichero */
   struct _FicherosAbiertos far *Sig; /* Puntero al siguinte fichero */
  } TpFicherosAbiertos;

/* Estruptura de almacenamiento de errores en el shell */
typedef struct {
  WORD TipoError;              // Cdigo numrico del error.
  char far *DescripcionError;  // Descripcin del error.
 }TpError;

/* Estruptura de almacenamiento de informacin de unidades montadas en el sistema */
typedef struct {
  char Ruta[128];       // Ruta sobre la que va montada la unidad.
  WORD UnidadBIOS;      // Unidad Bios de la unidad montada.
  DWORD BytesLibres;    // Bytes libres de la unidad.  = NumClustersLibres*TamoDelClusterEnBytes.
  DWORD BytesOcupados;  // Bytes ocupados de la unidad = NumClustersUsados*TamoDelClusterEnBytes.
  DWORD BytesTotales;   // Bytes Totales = NumClustersTotales*TamoDelClusterEnBytes.
 } TpInfoUnidadesMontadas;

/****** Estruptura genrica utilizada en las llamadas al sistema ******/

typedef struct {
 int S;		// Servicio a realizar 1..21 y cdigo de respuesta.
 int I;			// Argumentos que sea int
 DWORD D;		// Argumentos que sea DWORD
 void far *A;		// Argumentos que sean int far *  char far *
 void far *B;		// Doble argumento char far *
 void far *R;		// TZIP del proceso que solicita servicio.
 char C;                // Argunentos que sea char
 char C2;               // Mas argunentos que sean char
 char C3;               // Mas argunentos que sean char
 void far *E;		// TZIP del proceso que solicita servicio.
} tpZSFA;
