.8086

SE SEGMENT PARA USE16 'CODE'
        ORG 256
        ASSUME cs:SE,ss:SE,ds:SE,es:SE
comienzo:
        ;   CABEZERA DEL BOOTSECTOR
        jmp short start
        nop
        db         'Boot-EXT'        ; Identificador
        dw         512               ; Bytes por sector
        db         1                 ; Bytes por cluster
        dw         1                 ; Sectores reservados al principio
        db         2                 ; N copias de la FAT
        dw         224               ; N de entradas al directorio raiz         
        dw         2880              ; N total de sectores
        db         240               ; Tipo de disco ( 1.44 )
        dw         9                 ; N sectores por cada FAT
        dw         18                ; N sectores por pista
        dw         2                 ; N de cabezas
        dw         0,0               ; N de sectores especiales reservados
        dw         0,0               ; N de sectores en mas de 32 Mb
        db         0                 ; N de la unidad fisica
pistas: db         ?                 ; Reservado ( n de pistas ZEUS )
        db         41                ; Marca de validacion
        dw         1234h,5678h       ; N de serie
titulo: db         'BOOT EXT..$'     ; Titulo del disco
        db         'FAT12   '        ; Sistema de ficheros
start:        
 
 ;  ----  INICIALIZA CS:IP y SS:SP ----
        push       cs
        pop        ds
        mov        ax,60h
        mov        es,ax
        push       ax
        xor        di,di
        mov        cx,512
        cld
        call near ptr start_
 start_:
        pop        si
        sub        si,256 + offset start_ - offset comienzo
        rep movsw 
        mov        ax,offset inicio
        push       ax
        retf      
 inicio:
        push       cs
        pop        ss
        mov        sp,1000           ; Poner Pila
 
 ;   ---- INICIO DEL PROGRAMA ----
        xor        ax,ax
        mov        ds,ax
        cli
        mov word ptr ds:[21h*4],offset int21h
        mov word ptr ds:2[21h*4],cs                ; Cambiar int 21h
        sti
        push       cs
        pop        ds
        mov        dx,offset titulo
        mov        ah,9
        int        21h

  ;   ---- LEER PISTAS ----        

        xor        ch,ch
        mov        cl,byte ptr cs:[pistas]     ; CL = N de pistas a leer
        mov        si,1000h
        push       si
        mov        dh,1
 otra_pista:                        ; Leer Pistas en 0x90000
        push       cx
        mov        es,si
        mov        ch,dh
        mov        di,dx
        mov        cl,1
        xor        bx,bx
        xor        dx,dx            ; Cara 0 , Unidad A
        call leer_sector
        mov        bh,24h
        mov        dh,1             ; Cara 1
        call leer_sector
        add        si,480h
        mov        dx,di
        inc        dh
        pop        cx
        loop otra_pista

    ;  ---- INICIALIZA  EXE ----

        pop        ds
        mov        dx,ds:[8]        ; DX = Tamao de la cabezera
        mov        cl,4
        shl        dx,cl
        mov        cx,ds:[6]        ; CX = N de reubicaciones
        mov        bx,ds:[24]       ; BX = Offset de Tabla de reubicaciones
        or         cx,cx
        jz         no_reubicaciones ; Hay reubicaciones?
 otra_reubicacion:
        mov        di,ds:[bx]
        mov        si,ds:2[bx]
        add        di,dx
        mov        ax,ds
        add        si,ax
        mov        es,si
        add        ax,ds:[8]
        add        es:[di],ax      ; Hacer Reubicacion
        add        bx,4
        loop       otra_reubicacion
 no_reubicaciones:
 
 ;  ---- SALTO AL PROGRAMA EXE ----
 
        mov        ax,ds
        add        ax,ds:[14]
        add        ax,ds:[8]
        mov        ss,ax               ; Calcular SS:SP
        mov        sp,ds:[16]
        mov        ax,ds:[22]
        add        ax,ds:[8]
        mov        bx,ds
        add        ax,bx
        mov        dx,ds:[20]         ; Calcular CS:IP
        mov        bx,offset salto
        mov        cs:[bx],dx         ; Preparar salto largo
        mov        cs:2[bx],ax
        jmp dword ptr cs:salto        ; Pasar el control al EXE
        
;    ---- LEER SECTORES ----    

leer_sector:        
        push       bx
        push       es
        mov        bx,09000h        ; Buffer DMA en 0x90000
        mov        es,bx
        xor        bx,bx
otra_leer_sector:                     ; CH = Cilindro
        mov        ax,0212h           ; CL = Sector
        int        13h                ; DX = Cabeza,Unidad
        jc         reinicia_disco     ; ES:BX = Registro
        pop        es                 ; AX = N de sectores
        mov        bx,di
        pop        di
        push       di        ; Meter BX
        push       bx        ; Meter DI
        push       ds        ; Meter DS
        push       cx        ; Meter CX
        push       si        ; Meter SI
        mov        bx,09000h
        mov        ds,bx
        mov        cx,4608
        xor        si,si
        cld
        rep movsw        ; Necesario si no queremos superar el DMA
        pop        si
        pop        cx
        pop        ds
        pop        di
        pop        bx
        ret                                              
 reinicia_disco:
        push       dx
 otra_reinicia_disco:       
        xor        dx,dx
        xor        ah,ah
        int        13h              ; Reinicia Disco
        jc         otra_reinicia_disco
        pop        dx
        jmp short otra_leer_sector

;    --- INT 21h ----

int21h:
        cmp        ah,4ch
        je         reboot
        cmp        ah,01h
        je         entrada_c
        cmp        ah,02h
        je         salida_c
        cmp        ah,09h
        je         salida_s
        mov        ax,0ffffh        
        iret

   ; Salida de una cadena de caracteres por pantalla

salida_s:
        push       dx
        push       si
        mov        si,dx
        cld        
 otra_salida_s:
        lodsb 
        cmp        al,'$'
        je         fin_salida_s
        mov        dl,al
        call       salida_caracter
        test       al,0ffh
        jnz        otra_salida_s
 fin_salida_s:        
        pop        si
        pop        dx
        iret        

   ; Entrada por teclado de un caracter

entrada_c:
        push       bx
        push       ax
        xor        ax,ax
        int        16h
        pop        bx
        mov        ah,bh
        pop        bx
        iret
salida_c:
         call salida_caracter
         iret

   ;  Reset en Frio

reboot:
        mov        ah,2h
        int        1ah
        mov        bh,dh
 otra_espera_segundo:        
        mov        ah,2h
        int        1ah
        cmp        bh,dh
        je         otra_espera_segundo
        mov        cx,0FFFFh
        mov        dx,0201h
 reboot_otra:
        in         al,dx
        loop       reboot_otra
        mov        ax,0F000h
        push       ax
        mov        ax,0FFF0h
        push       ax
        retf

 ; Salida de un caracter por pantalla
        
salida_caracter:
        push       ax
        push       bx
        push       cx
        push       dx
        mov        al,dl
        cmp        al,13
        je         vuelta_carro
        cmp        al,10
        je         salto_linea
        call escribe_caracter
        call calcula_posicion
        cmp        dl,79
        jl         salida_caracter1
 salida_caracter0:        
        mov        dl,0ffh
        cmp        dh,24
        jl         salida_caracter2
        call desplaza_ventana
        dec        dh
 salida_caracter2:
        inc        dh
 salida_caracter1:
        inc        dl        
        call cambia_posicion
        pop        dx
        pop        cx
        pop        bx
        pop        ax                
        ret
escribe_caracter:        
        mov        bx,0007h
        mov        cx,1
        mov        ah,09h
        int        10h
        ret
vuelta_carro:
        call calcula_posicion
        mov        dl,0ffh
        jmp short salida_caracter1

salto_linea:
        call calcula_posicion
        jmp short salida_caracter0                
        
calcula_posicion:
        mov        ah,03h
        xor        bx,bx
        int        10h
        ret
cambia_posicion:                
        mov        ah,02h
        int        10h
        ret
desplaza_ventana:                
        push       cx
        push       bx
        push       dx
        xor        cx,cx
        xor        bx,bx
        mov        dx,184Fh
        mov        ax,0601h
        int        10h
        pop        dx
        pop        bx
        pop        cx
        ret

salto:
SE ENDS

END comienzo
