.386p

 INCLUDE ..\EXTENSOR.INC

  EXTRN _Ext_IRQ6_PROC:QWORD,FDC_OPERACION:BYTE,_Ext_FDC_UNIDAD:BYTE
  EXTRN _Ext_FDC_VELOCIDAD:BYTE,_Ext_FDC_CABEZAL:BYTE,_Ext_FDC_CILINDRO:BYTE
  EXTRN _Ext_FDC_DMA:QWORD,SELECTOR_DS:ABS,SELECTOR_CS32:ABS
  EXTRN _Ext_TIMER_COUNT:DWORD,SELECTOR_DMA:ABS

  PUBLIC IRQ6_ISR,Ext_FDC_MotorON_,Ext_FDC_MotorOFF_,Ext_FDC_Select_
  PUBLIC Ext_FDC_Recalibrate_,Ext_FDC_Seek_,Ext_FDC_Read_,Ext_FDC_Write_
  PUBLIC Ext_FDC_Format_,FIN_FDC,INICIO_FDC

_TEXT SEGMENT PARA PUBLIC USE32 'CODE'

        ASSUME CS:_TEXT

 INICIO_FDC LABEL DWORD

IRQ6_ISR PROC FAR               ; Disco flexible
        push       ds
        push       eax
        mov        ax,offset SELECTOR_DS      ; IRQ6
        mov        ds,ax
        mov        eax,DWORD PTR ds:[_Ext_IRQ6_PROC]
        or         eax,DWORD PTR ds:2[_Ext_IRQ6_PROC]
        jz         IRQ6_No_Proc
        pushad
        pushfd
        push       ds
        push       es
        push       fs
        push       gs
        Llamada_DS _Ext_IRQ6_PROC
        pop        gs
        pop        fs
        pop        es
        pop        ds
        popfd
        popad
 IRQ6_No_Proc:
        mov        al,20h
        out        20h,al
        mov        al,FDC_OPERACION
        or         al,al
        jz         IRQ6_Salida
        mov        FDC_OPERACION,-1
 IRQ6_Salida:
        pop        eax
        pop        ds
        iretd
IRQ6_ISR ENDP

FDC_Out PROC FAR             ; AL = Dato a mandar
        push      dx
        push      ecx
        rol       eax,16
        xor       ecx,ecx
 FDC_Out_Otra:
        mov       dx,PFDC_STATUS
        in        al,dx
        test      al,128
        jnz       FDC_Out_Hacer
        loop      FDC_Out_Otra
        mov       eax,-1
        jmp short     FDC_Out_Error
 FDC_Out_Hacer:
        ror       eax,16
        mov       dx,PFDC_DATA
        out       dx,al
        xor       eax,eax
 FDC_Out_Error:                 ; EAX = 0 Bien , -1 Error
        pop       ecx
        pop       dx
        retf
FDC_Out ENDP

FDC_In PROC FAR
        push      dx
        push      ecx
        xor       ecx,ecx
 FDC_In_Otra:
        mov       dx,PFDC_STATUS
        in        al,dx
        test      al,128
        jnz       FDC_In_Hacer
        loop      FDC_In_Otra
        mov       eax,-1
        jmp short     FDC_In_Error
 FDC_In_Hacer:
        xor       eax,eax
        mov       dx,PFDC_DATA
        in        al,dx
 FDC_In_Error:                 ; EAX = -1 Error
        pop       ecx
        pop       dx
        retf
FDC_In ENDP

Ext_FDC_MotorON_ PROC FAR    ; EAX = Unidad ( 0 .. 3 )
        push     eax
        push     ebx
        push     ecx
        push     edx
        and      eax,3
        mov      ecx,eax
        inc      ecx
        mov      ebx,8
 Ext_FDC_MotorON__otra:
        shl      ebx,1
        loop     Ext_FDC_MotorON__otra
        add      eax,4+8
        or       eax,ebx
        mov      dx,PFDC_DIGITAL
        out      dx,al
        pop      edx
        pop      ecx
        pop      ebx
        pop      eax
        retf
Ext_FDC_MotorON_ ENDP

Ext_FDC_MotorOFF_ PROC FAR   ; EAX = Unidad ( 0 .. 3 )
        push     eax
        push     edx
        and      eax,3
        add      eax,4+8
        mov      dx,PFDC_DIGITAL
        out      dx,al
        pop      edx
        pop      eax
        retf
Ext_FDC_MotorOFF_ ENDP

FDC_DMA PROC FAR     ;EAX = Modo , EDX = Bytes , EBX = Offset
        pushad
        mov      ecx,edx
        dec      ecx
        mov      esi,eax
        mov      al,9
        mov      dx,81h
        out      dx,al
        mov      dx,0bh
        mov      eax,esi
        out      dx,al
        mov      dx,0ch
        xor      eax,eax
        out      dx,al
        mov      dx,4
        mov      al,bl
        out      dx,al
        mov      al,bh
        out      dx,al
        mov      dx,5
        mov      al,cl
        out      dx,al
        mov      al,ch
        out      dx,al
        mov      dx,0ah
        mov      al,2
        out      dx,al
        popad
        retf
FDC_DMA ENDP

FDC_DisableInt PROC FAR
        push   eax
        in     al,PICA01
        or     al,01000000b
        out    PICA01,al
        pop    eax
        retf
FDC_DisableInt ENDP

FDC_EnableInt PROC FAR
        push   eax
        in     al,PICA01
        and    al,10111111b
        out    PICA01,al
        pop    eax
        retf
FDC_EnableInt ENDP

FDC_WaitInt PROC FAR
        push    ds
        push    ecx
        push    edx
        pushfd
        Llamada32_32 SELECTOR_CS32,FDC_EnableInt
        sti
        mov      ecx,eax
        mov      ax,offset SELECTOR_DS
        mov      ds,ax
 FDC_WaitInt_Otra2:
        mov      edx,_Ext_TIMER_COUNT
 FDC_WaitInt_Otra:
        xor      eax,eax
        cmp      FDC_OPERACION,-1
        je       FDC_WaitInt_Salir
        cmp      edx,_Ext_TIMER_COUNT
        je       FDC_WaitInt_Otra
        int      30h
        loop     FDC_WaitInt_Otra2
        mov      eax,-1
 FDC_WaitInt_Salir:
        popfd
        pop      edx
        pop      ecx
        pop      ds
        retf
FDC_WaitInt ENDP


Ext_FDC_Select_ PROC FAR  ; EAX = Unidad , EDX = Velocidad
        push     ds
        push     ebx
        push     ecx
        push     edx
        mov      cx,offset SELECTOR_DS
        mov      ds,cx
        mov      cl,FDC_OPERACION
        or       cl,cl
        jnz      Ext_FDC_Select__Error2
        cli
        mov      FDC_OPERACION,1
        mov      _Ext_FDC_UNIDAD,al
        mov      _Ext_FDC_VELOCIDAD,dl
        Llamada32_32 SELECTOR_CS32,FDC_EnableInt
        sti
        mov      ecx,eax
        mov      eax,edx
        mov      dx,PFDC_CONTROL
        out      dx,al
        push     ecx
        push     ecx
        inc      ecx
        mov      dx,8
 Ext_FDC_Select__Otra:
        shl      dx,1
        loop     Ext_FDC_Select__Otra
        pop      ecx
        add      cx,dx
        mov      ax,8
        add      ax,cx
        mov      dx,PFDC_DIGITAL
        out      dx,al
        pop      ecx
        push     ecx
        inc      ecx
        mov      dx,8
 Ext_FDC_Select__Otra2:
        shl      dx,1
        loop     Ext_FDC_Select__Otra
        pop      ecx
        add      dx,cx
        mov      eax,8+4
        add      ax,dx
        mov      dx,PFDC_DIGITAL
        out      dx,al
        mov      eax,36
        Llamada32_32 SELECTOR_CS32,FDC_WaitInt
        or       eax,eax
        jnz      Ext_FDC_Select__Error
        mov      eax,8
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or       eax,eax
        jnz      Ext_FDC_Select__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        Llamada32_32 SELECTOR_CS32,FDC_In
        mov      eax,3
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or       eax,eax
        jnz      Ext_FDC_Select__Error
        mov      al,_Ext_FDC_VELOCIDAD
        or       al,al
        jnz      Ext_FDC_Select__No0
        mov      eax,0BFh
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or       al,al
        jnz      Ext_FDC_Select__Error
        jmp short    Ext_FDC_Select__Ok
 Ext_FDC_Select__No0:
        cmp      al,3
        jne      Ext_FDC_Select__Else
        mov      eax,0AFh
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or       al,al
        jnz      Ext_FDC_Select__Error
        jmp short    Ext_FDC_Select__Ok
 Ext_FDC_Select__Else:
        mov      eax,0DFh
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or       al,al
        jnz      Ext_FDC_Select__Error
 Ext_FDC_Select__Ok:
        mov      eax,2
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or       al,al
        jnz      Ext_FDC_Select__Error
        xor      eax,eax
 Ext_FDC_Select__Salir:
        mov      FDC_OPERACION,0
        mov      _Ext_FDC_CABEZAL,0
        mov      _Ext_FDC_CILINDRO,0
 Ext_FDC_Select__Salir2:
        pop      edx
        pop      ecx
        pop      ebx
        pop      ds
        retf
 Ext_FDC_Select__Error:
        mov      eax,-1
        jmp short    Ext_FDC_Select__Salir
 Ext_FDC_Select__Error2:
        mov      eax,-1
        jmp short    Ext_FDC_Select__Salir2
Ext_FDC_Select_ ENDP

Ext_FDC_Recalibrate_ PROC FAR        ; EAX= CABEZAL
        push     ds
        push     ebx
        push     ecx
        push     edx
        xor      ebx,ebx
        mov      bl,al
        shl      bl,2
        mov      ax,offset SELECTOR_DS
        mov      ds,ax
        cmp      FDC_OPERACION,0
        jne      Ext_FDC_Recalibrate__Error2
        xor      eax,eax
        mov      al,_Ext_FDC_UNIDAD
        or       bl,al
        Llamada32_32 SELECTOR_CS32,Ext_FDC_MotorON_
        mov      ecx,5
 Ext_FDC_Recalibrate__Otra:
        cli
        mov      FDC_OPERACION,1
        Llamada32_32 SELECTOR_CS32,FDC_EnableInt
        sti
        mov      eax,7
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or       eax,eax
        jnz      Ext_FDC_Recalibrate__Error
        mov      eax,ebx
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or       eax,eax
        jnz      Ext_FDC_Recalibrate__Error
        mov      eax,37
        Llamada32_32 SELECTOR_CS32,FDC_WaitInt
        or       eax,eax
        jnz      Ext_FDC_Recalibrate__Error
        mov      eax,8
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or       eax,eax
        jnz      Ext_FDC_Recalibrate__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        or       eax,eax
        js       Ext_FDC_Recalibrate__Error
        mov      dl,32
        xor      dl,al
        and      dl,0F0h
        Llamada32_32 SELECTOR_CS32,FDC_In
        or       eax,eax
        js       Ext_FDC_Recalibrate__Error
        or       dl,dl
        jz       Ext_FDC_Recalibrate__Ok
        loop     Ext_FDC_Recalibrate__Otra
 Ext_FDC_Recalibrate__Error:
        mov      FDC_OPERACION,0
        mov      al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,Ext_FDC_MotorOFF_
 Ext_FDC_Recalibrate__Error2:
        mov      eax,-1
 Ext_FDC_Recalibrate__Salir:
        pop      edx
        pop      ecx
        pop      ebx
        pop      ds
        retf
 Ext_FDC_Recalibrate__Ok:
        mov      _Ext_FDC_CILINDRO,0
        mov      FDC_OPERACION,0
        mov      al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,Ext_FDC_MotorOFF_
        xor      eax,eax
        jmp short    Ext_FDC_Recalibrate__Salir
Ext_FDC_Recalibrate_ ENDP

Ext_FDC_Seek_ PROC FAR       ; EAX = Cabezal , EDX = Cilindro
        push    ds
        push    ebx
        push    edx
        mov     bx,offset SELECTOR_DS
        mov     ds,bx
        cmp     FDC_OPERACION,0
        jnz     Ext_FDC_Seek__Error2
        cli
        mov     FDC_OPERACION,1
        mov     _Ext_FDC_CABEZAL,al
        mov     _Ext_FDC_CILINDRO,dl
        Llamada32_32 SELECTOR_CS32,FDC_EnableInt
        sti
        xor     ebx,ebx
        mov     bl,al
        shl     bl,2
        xor     eax,eax
        mov     al,_Ext_FDC_UNIDAD
        or      bl,al
        Llamada32_32 SELECTOR_CS32,Ext_FDC_MotorON_
        mov     eax,0Fh
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Seek__Error
        mov     al,bl
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Seek__Error
        mov     al,_Ext_FDC_CILINDRO
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Seek__Error
        mov     eax,37
        Llamada32_32 SELECTOR_CS32,FDC_WaitInt
        or      eax,eax
        jnz     Ext_FDC_Seek__Error
        mov     eax,8
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Seek__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Seek__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Seek__Error
        mov     al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,Ext_FDC_MotorOFF_
        xor     eax,eax
 Ext_FDC_Seek__Salir:
        mov     FDC_OPERACION,0
        pop     edx
        pop     ebx
        pop     ds
        retf
 Ext_FDC_Seek__Error:
        mov     al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,Ext_FDC_MotorOFF_
 Ext_FDC_Seek__Error2:
        mov     eax,-1
        jmp short Ext_FDC_Seek__Salir
Ext_FDC_Seek_ ENDP

Ext_FDC_Read_ PROC FAR       ; EAX = CABEZAL , EDX = CILINDRO , EBX = OFFSET
        push    ebp          ; ECX = TAMAO , SS: SECTOR , nSECTORES
        mov     ebp,esp
        push    ds
        pushad
        push    bx
        mov     bx,offset SELECTOR_DS
        mov     ds,bx
        pop     bx
        cmp     FDC_OPERACION,0
        jnz     Ext_FDC_Read__Error2
        cmp     _Ext_FDC_CABEZAL,al
        jne     Ext_FDC_Read__HacerSeek
        cmp     _Ext_FDC_CILINDRO,dl
        je      Ext_FDC_Read__NoHacerSeek
 Ext_FDC_Read__HacerSeek:
        Llamada32_32 SELECTOR_CS32,Ext_FDC_Seek_
        or      eax,eax
        jnz     Ext_FDC_Read__Error2
 Ext_FDC_Read__NoHacerSeek:
        cli
        mov     FDC_OPERACION,1
        Llamada32_32 SELECTOR_CS32,FDC_EnableInt
        sti
        mov     al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,Ext_FDC_MotorON_
        push    ebx
        xor     edx,edx
        mov     eax,ecx
        mov     ebx,ss:[ebp+16]
        or      ebx,ebx
        jz      Ext_FDC_ReadZero
        mul     ebx
Ext_FDC_ReadZero:
        mov     edx,eax
        pop     ebx
        mov     eax,46h
        Llamada32_32 SELECTOR_CS32,FDC_DMA
        mov     eax,70
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Read__Error
        mov     al,_Ext_FDC_CABEZAL
        shl     eax,2
        add     al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Read__Error
        mov     al,_Ext_FDC_CILINDRO
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Read__Error
        mov     al,_Ext_FDC_CABEZAL
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Read__Error
        mov     ax,ss:[ebp+12]
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Read__Error
        mov     ax,cx
        shr     ax,8
        mov     di,ax
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Read__Error
        mov     eax,ss:[ebp+12]
        add     eax,ss:[ebp+16]
        dec     eax
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Read__Error
        mov     eax,1
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Read__Error
        mov     eax,edx
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Read__Error
        mov     eax,50
        Llamada32_32 SELECTOR_CS32,FDC_WaitInt
        or      eax,eax
        jnz     Ext_FDC_Read__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Read__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Read__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Read__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Read__Error
        mov     edx,eax                 ; Cilindro
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Read__Error
        mov     ebx,eax                 ; Cabezal
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Read__Error
        mov     ecx,eax                 ; Sector
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Read__Error
        push    eax
        mov     FDC_OPERACION,0
        mov     al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,Ext_FDC_MotorOFF_
        pop     eax
        dec     edx
        cmp     ax,di
        jne     Ext_FDC_Read__Error
        cmp     cx,1
        jne     Ext_FDC_Read__Error
        cmp     bl,_Ext_FDC_CABEZAL
        jne     Ext_FDC_Read__Error
        cmp     dl,_Ext_FDC_CILINDRO
        jne     Ext_FDC_Read__Error
        popad
        pop     ds
        pop     ebp
        xor     eax,eax
        retf    8
 Ext_FDC_Read__Error:
        mov     FDC_OPERACION,0
        mov     al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,Ext_FDC_MotorOFF_
 Ext_FDC_Read__Error2:
        popad
        pop     ds
        pop     ebp
        mov     eax,-1
        retf    8
Ext_FDC_Read_ ENDP

Ext_FDC_Write_ PROC FAR  ; EAX = CABEZAL , EDX = CILINDRO , EBX = OFFSET
        push    ebp      ; ECX = TAMAO , SS: SECTOR,numSectores,GAP
        mov     ebp,esp
        push    ds
        pushad
        push    bx
        mov     bx,offset SELECTOR_DS
        mov     ds,bx
        pop     bx
        cmp     FDC_OPERACION,0
        jnz     Ext_FDC_Write__Error2
        cmp     _Ext_FDC_CABEZAL,al
        jne     Ext_FDC_Write__HacerSeek
        cmp     _Ext_FDC_CILINDRO,dl
        je      Ext_FDC_Write__NoHacerSeek
 Ext_FDC_Write__HacerSeek:
        Llamada32_32 SELECTOR_CS32,Ext_FDC_Seek_
        or      eax,eax
        jnz     Ext_FDC_Write__Error2
 Ext_FDC_Write__NoHacerSeek:
        cli
        mov     FDC_OPERACION,1
        Llamada32_32 SELECTOR_CS32,FDC_EnableInt
        sti
        mov     al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,Ext_FDC_MotorON_
        push    ebx
        xor     edx,edx
        mov     eax,ecx
        mov     ebx,ss:[ebp+16]
        or      ebx,ebx
        jz      Ext_FDC_WriteZero
        mul     ebx
 Ext_FDC_WriteZero:
        mov     edx,eax
        pop     ebx
        mov     eax,4Ah
        Llamada32_32 SELECTOR_CS32,FDC_DMA
        mov     eax,69
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Write__Error
        mov     al,_Ext_FDC_CABEZAL
        shl     eax,2
        add     al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Write__Error
        mov     al,_Ext_FDC_CILINDRO
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Write__Error
        mov     al,_Ext_FDC_CABEZAL
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Write__Error
        mov     eax,ss:[ebp+12]
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Write__Error
        mov     ax,cx
        shr     ax,8
        mov     di,ax
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Write__Error
        mov     eax,ss:[ebp+12]
        add     eax,ss:[ebp+16]
        dec     eax
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Write__Error
        mov     eax,ss:[ebp+20]
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Write__Error
        mov     eax,edx
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Write__Error
        mov     eax,50
        Llamada32_32 SELECTOR_CS32,FDC_WaitInt
        or      eax,eax
        jnz     Ext_FDC_Write__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Write__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Write__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Write__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Write__Error
        mov     edx,eax                 ; Cilindro
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Write__Error
        mov     ebx,eax                 ; Cabezal
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Write__Error
        mov     ecx,eax                 ; Sector
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Write__Error
        push    eax
        mov     FDC_OPERACION,0
        mov     al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,Ext_FDC_MotorOFF_
        pop     eax
        dec     edx
        cmp     ax,di
        jne     Ext_FDC_Write__Error2
        cmp     cx,1
        jne     Ext_FDC_Write__Error2
        cmp     bl,_Ext_FDC_CABEZAL
        jne     Ext_FDC_Write__Error2
        cmp     dl,_Ext_FDC_CILINDRO
        jne     Ext_FDC_Write__Error2
        popad
        pop     ds
        pop     ebp
        xor     eax,eax
        retf    12
 Ext_FDC_Write__Error:
        mov     FDC_OPERACION,0
        mov     al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,Ext_FDC_MotorOFF_
 Ext_FDC_Write__Error2:
        popad
        pop     ds
        pop     ebp
        mov     eax,-1
        retf    12
Ext_FDC_Write_ ENDP

Ext_FDC_Format_ PROC FAR       ; EAX = TAMAO , EDX = GAP , EBX = OFFSET
        push    ebp      ; ECX = TAMAO , SS: GAP,nSectores,ByteINIT
        mov     ebp,esp
        push    ds
        pushad
        push    bx
        mov     bx,offset SELECTOR_DS
        mov     ds,bx
        pop     bx
        cmp     FDC_OPERACION,0
        jnz     Ext_FDC_Format__Error2
        cli
        mov     FDC_OPERACION,1
        mov     _Ext_FDC_CABEZAL,al
        mov     _Ext_FDC_CILINDRO,dl
        Llamada32_32 SELECTOR_CS32,FDC_EnableInt
        sti
        mov     al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,Ext_FDC_MotorON_
        push    es
        push    ecx
        mov     ax,offset SELECTOR_DMA
        mov     es,ax
        mov     eax,ecx
        mov     al,1
        shl     eax,8
        mov     al,_Ext_FDC_CABEZAL
        shl     eax,8
        mov     al,_Ext_FDC_CILINDRO
        mov     ecx,ss:[ebp+16]
        mov     edi,ebx
        cld
 Ext_FDC_Format__Otra:
        stosd
        add     eax,10000h
        loop    Ext_FDC_Format__Otra
        pop     ecx
        pop     es
        mov     edx,ss:[ebp+16]
        shl     edx,2
        mov     eax,4Ah
        Llamada32_32 SELECTOR_CS32,FDC_DMA
        mov     eax,77
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Format__Error
        mov     al,_Ext_FDC_CABEZAL
        shl     eax,2
        add     al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Format__Error
        mov     eax,ecx
        shr     eax,8
        mov     edi,eax
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Format__Error
        mov     eax,ss:[ebp+16]
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Format__Error
        mov     eax,ss:[ebp+12]
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Format__Error
        mov     eax,ss:[ebp+20]
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Format__Error
        mov     eax,50
        Llamada32_32 SELECTOR_CS32,FDC_WaitInt
        or      eax,eax
        jnz     Ext_FDC_Format__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Format__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Format__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Format__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Format__Error
        mov     edx,eax                 ; Cilindro
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Format__Error
        mov     ebx,eax                 ; Cabezal
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Format__Error
        mov     ecx,eax                 ; Sector
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Format__Error
        push    eax
        mov     FDC_OPERACION,0
        mov     al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,Ext_FDC_MotorOFF_
        pop     eax
        cmp     ax,di
        jne     Ext_FDC_Format__Error2
        mov     esi,ss:[ebp+16]
        cmp     cx,si
        jne     Ext_FDC_Format__Error2
        cmp     bl,_Ext_FDC_CABEZAL
        jne     Ext_FDC_Format__Error2
        cmp     dl,_Ext_FDC_CILINDRO
        jne     Ext_FDC_Format__Error2
        popad
        pop     ds
        pop     ebp
        xor     eax,eax
        retf    12
 Ext_FDC_Format__Error:
        mov     FDC_OPERACION,0
        mov     al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,Ext_FDC_MotorOFF_
 Ext_FDC_Format__Error2:
        popad
        pop     ds
        pop     ebp
        mov     eax,-1
        retf    12
Ext_FDC_Format_ ENDP


 FIN_FDC LABEL DWORD

_TEXT ENDS

END

