VER EQU "v1.05"
;
; --- CONSTANTES ESTRUCTURAS y MACROS para EXTENSOR ---
;
;         Realizado por Daniel Lancha Garcia

;
;      //////// ESTRUCTURAS \\\\\\\
;
; stGDT                        : GDT ELIMIT, BASE ,etc..                         
; stIDT                        : Igual pero con IDT
; stTSS                        : Segmento de estado de tarea
;


;      ////////   MACROS   \\\\\\\\\
;
; IRQs_Protejido Variable_Mascara : Inicializa IRQs para modo protejido
; IRQs_Real Variable_Mascara   : Restaura IRQs en modo real
; ActivarBitProtejido          : Activa el flag de modo protejido
; DesactivarBitProtejido       : Desactiva el flag
; CargarGDT X                  : Carga el registro GDT con el FWORD X
; DescargarGDT X               : Descarga en FWORD X el registro GDT
; CargarLDT X                  
; DescargarLDT X               : Igual para LDT y IDT
; CargarIDT X                  
; DescargarIDT X               
; Poner_Base Etiqueta,Descriptor    : Construye la base en un descriptor
; Poner_Base2 Segmento,Descriptor   : Idem con una variable segmento
; Poner_Limite Limite,Descriptor    : Construye el limite
; Poner_Bits Acceso,E386,Desciptor  : Igual con los Bits de un descriptor
; Hacer_BL Etiqueta,Limite,Variable : Hace una variable stBASE_LIMIT
; Llamada32_32                 : Call desde un segmento 32 a otro 32 bit
; Llamada32_16                 : Igual pero de 32 bit a 16 bit
; Llamada16_32                 : Mas de lo mismo
; Llamada16_16
; Llamada16_TSS                : Calls hacia tarea
; Llamada32_TSS
; Salto32_32                   
; Salto32_16                   : Como Llamada pero con JMP
; Salto16_32
; Salto16_16
; Salto16_TSS
; Salto32_TSS
; Completa_TSS                 : Inicializa Segmento de estado de tarea
; RecojerRejistros             : Copiar los rejistros de la CPU

LONGITUD_PILA_REAL EQU 256     ; 256 * 4 = 1 Kbyte : Pila en Modo Real
LONGITUD_PILA   EQU  2048      ; 2048 * 8 = 16 Kbytes : Pila en Modo Protejido
LONGITUD_CAMBIO EQU  1024      ; 1024 * 2 Longitud de la tabla de tareas
LONG_TABLA_MEM EQU   4096      ; Longitud de la tabla de memoria DPMI
LONG_BASE_MEM  EQU   16        ; Longitud de la tabla de memoria Base
LONG_LDT       EQU   8         ; Longitud del LDT inicial
MAX_SEL        EQU   4095      ; Longitud del GDT

D_BIT         EQU 40h        ; Bit D o B para tipos de 32 Bit
G_BIT         EQU 80h        ; Bit G para granularidad larga ( 4 Kbytes )

E_SEG         EQU 08h        ; Solo ejecutable
EL_SEG        EQU 0Ah        ; Ejecutable y leible
EC_SEG        EQU 0Ch        ; Ejecutable conformado
ELC_SEG       EQU 0Eh        ; Ejecutable conformado y leible
L_SEG         EQU 00h        ; Solo leible
LE_SEG        EQU 02h        ; Leible y escribible
LEA_SEG       EQU 04h        ; Solo leible con expansion hacia abajo
LEEA_SEG      EQU 06h        ; Leible y escribible con expansion hacia abajo
EA_BIT        EQU 04h        ; Bit de expansion hacia abajo

PRESENT       EQU 80h        ; Segmento presente

DPL1          EQU 20h
DPL2          EQU 40h        ; Nivel de Privilegio
DPL3          EQU 60h

CALL_G_386    EQU 0Ch
INT_G_386     EQU 0Eh
TRAP_G_386    EQU 0Fh
TSS_AVAIL_386 EQU 09h        ; Mascaras para segementos de sistema 32-bit 
TSS_BUSY_386  EQU 0Bh
LDT_DESC      EQU 02h
TASK_G        EQU 05h

SEG_DESC   EQU 10h        ; Mascaras para S bit

INIT_EFLAGS EQU 4202h     ; EFLAGS iniciales para un TSS

stGDT       STRUC
        LIMIT        dw       0
        BASE_LOW     dw       0
        BASE_MED     db       0
        GDT_ACCESS   db       0
        E386         db       0
        BASE_HIGH    db       0
stGDT       ENDS



stIDT       STRUC
        OFFSET_LOW   dw       0
        SEGMENT_SEL  dw       0
        DWORD_COUNT  db       0
        IDT_ACCESS   db       0
        OFFSET_HIGH  dw       0
stIDT       ENDS

stTSS       STRUC
  RBACKLINK        DW 0        ; 0 --00h
  RES1             DW 0        ; 1 --02h
  RESP0            DD 0        ; 2 --04h
  RSS0             DW 0        ; 3 --08h
  RES2             DW 0        ; 4 --0Ah
  RESP1            DD 0        ; 5 --0Ch
  RSS1             DW 0        ; 6 --10h
  RES3             DW 0        ; 7 --12h
  RESP2            DD 0        ; 8 --14h
  RSS2             DW 0        ; 9 --18h
  RES4             DW 0        ;10 --1Ah
  RCR3             DD 0        ;11 --1Ch
  REIP             DD 0        ;12 --20h
  REFLAGS          DD 0        ;13 --24h
  REAX             DD 0        ;14 --28h
  RECX             DD 0        ;15 --2Ch
  REDX             DD 0        ;16 --30h
  REBX             DD 0        ;17 --34h
  RESP             DD 0        ;18 --38h
  REBP             DD 0        ;19 --3Ch
  RESI             DD 0        ;20 --40h
  REDI             DD 0        ;21 --44h
  RES              DW 0        ;22 --48h
  RES5             DW 0        ;23 --4Ah
  RCS              DW 0        ;24 --4Ch
  RES6             DW 0        ;25 --4Eh
  RSS              DW 0        ;26 --50h
  RES7             DW 0        ;27 --52h
  RDS              DW 0        ;28 --54h
  RES8             DW 0        ;29 --56h
  RFS              DW 0        ;30 --58h
  RES9             DW 0        ;31 --5Ah
  RGS              DW 0        ;32 --5Ch
  RES10            DW 0        ;33 --5Eh
  RLDTR            DW 0        ;34 --60h
  RES11            DW 0        ;35 --62h
  RTBIT            DW 0        ;36 --64h
  RIOBASE          DW 0        ;37 --66h
  RCOUNTDOWN       DW 0        ;38 --68h
  RBITS            DW 0        ;39 --6Ah
stTSS       ENDS

stTASK      STRUC
  TaskID           DW 0        ;0 -- 00h
  TaskL_PILA       DD 0        ;1 -- 02h
  TaskL_LDT        DD 0        ;2 -- 06h
  TaskDPL          DB 0        ;3 -- 0Ah
  TaskTSS          DP 0        ;4 -- 0Bh
  TaskLDT          DP 0        ;5 -- 0Fh
  TaskEIP          DD 0        ;6 -- 13h
stTASK      ENDS

; Puertos
PICA    EQU     020h     ; Controlador de interrupciones 0
PICA00  EQU     020h     ; Controlador de interrupciones 0 puerto 1
PICA01  EQU     021h     ; Controlador de interrupciones 0 puerto 2
PICB    EQU     0A0h     ; Controlador de interrupciones 1
PICB00  EQU     0A0h     ; Controlador de interrupciones 1 puerto 1
PICB01  EQU     0A1h     ; Controlador de interrupciones 1 puerto 2

PFDC_DATA       EQU     3f5h     ; Diskette puerto de datos
PFDC_STATUS     EQU     3f4h     ; Diskette puerto de estado
PFDC_DIGITAL    EQU     3f2h     ; Diskette puerto de salida digital
PFDC_CONTROL    EQU     3f7h     ; Diskette puerto de control

IRQs_Real MACRO PIC,Variable_Mascara,Base
        push    ax
        push    dx
        mov     al,11h
        mov     dx,PIC+00
        out     dx,al
        mov     al,Base
        mov     dx,PIC+01
        out     dx,al
        mov     al,04h           ; Restuara el vector base de interruccion
        out     dx,al            ;    para Modo Real
        mov     al,01h
        out     dx,al        ; Desmascara IRQs
        mov     al,byte ptr ds:[Variable_Mascara]
        out     dx,al
        in      al,60h
        pop     dx
        pop     ax
    ENDM

IRQs_Protejido MACRO PIC,Variable_Mascara,Move
        push    dx
        push    ax
        mov     dx,PIC+01
        in      al,dx
        mov     byte ptr ds:[Variable_Mascara],al
        mov     al,11h          ;Desactivar interrupciones
        mov     dx,PIC+00
        out     dx,al           ; Tambien mueve
        mov     al,Move         ; las IRQ a Move0-Move7
        mov     dx,PIC+01
        out     dx,al       ; para permitirlas en Modo Protejido
        mov     al,4
        out     dx,al
        mov     al,1
        out     dx,al
        mov     al,11111111b
        out     dx,al
        pop     ax
        pop     dx
     ENDM   

ActivarBitProtejido MACRO
        mov     eax,cr0     ; Activar Bit Modo Protejido
        or      eax,80000001h
        mov     cr0,eax
     ENDM

DesactivarBitProtejido MACRO
        mov     eax,cr0     ; Desactivar Bit Modo Protejido
        and     eax,07FFFFFFEh
        mov     cr0,eax
     ENDM   

CargarGDT MACRO A
        mov     esi,offset A
        db      66h,67h,0Fh,01h,16h ; lgdt FWORD PTR ds:[esi]
     ENDM

DescargarGDT MACRO A
        mov     esi,offset A
        db      66h,67h,0Fh,01h,06h ; sgdt FWORD PTR ds:[esi]
     ENDM

CargarLDT MACRO A
        mov     esi,offset A
        db      66h,67h,0Fh,00h,16h ; lldt    ds:[esi]
     ENDM

DescargarLDT MACRO A
        mov     esi,offset A
        db      66h,67h,0Fh,00h,06h; sldt    ds:[esi]
     ENDM

     
CargarIDT MACRO A
        mov     esi,offset A
        db      66h,67h,0Fh,01h,1Eh ; lidt FWORD PTR ds:[esi]
     ENDM        

DescargarIDT MACRO A
        mov     esi,offset A
        db      66h,67h,0Fh,01h,0Eh ; sidt FWORD PTR ds:[esi]
     ENDM
     
Poner_Base MACRO Etiqueta,Descriptor
        xor        eax,eax
        mov        ax,seg Etiqueta
        shl        eax,4
        mov        edi,offset Descriptor
        add        eax,offset Etiqueta
        mov        es:[edi].BASE_LOW,ax
        shr        eax,16
        mov        es:[edi].BASE_MED,al
    ENDM

Poner_Base2 MACRO Segmento,Descriptor
        xor        eax,eax
        mov        ax,ds:[Segmento]
        shl        eax,4
        mov        edi,offset Descriptor
        mov        es:[edi].BASE_LOW,ax
        shr        eax,16
        mov        es:[edi].BASE_MED,al
    ENDM

Poner_Base3 MACRO Etiqueta,Descriptor
        xor        eax,eax
        mov        ax,seg Etiqueta
        shl        eax,4
        mov        edi,offset Descriptor
        mov        es:[edi].BASE_LOW,ax
        shr        eax,16
        mov        es:[edi].BASE_MED,al
    ENDM

Poner_Base4 MACRO Suma,Descriptor
        mov        eax,Suma
        mov        edi,offset Descriptor
        mov        es:[edi].BASE_LOW,ax
        shr        eax,16
        mov        es:[edi].BASE_MED,al
    ENDM

Poner_Limite MACRO Limite,Descriptor
        mov        eax,Limite
        mov        edi,offset Descriptor
        mov        es:[edi].LIMIT,ax
        shr        eax,16
        mov        ah,es:[edi].E386
        and        ah,11110000b
        and        al,00001111b
        add        al,ah
        mov        es:[edi].E386,al
    ENDM    

Poner_Limite2 MACRO Descriptor
        mov        eax,[_Ext_MEM]
        sub        eax,100000h
        shr        eax,12
        mov        edi,offset Descriptor
        mov        es:[edi].LIMIT,ax
        shr        eax,16
        mov        ah,es:[edi].E386
        and        ah,11110000b
        and        al,00001111b
        add        al,ah
        mov        es:[edi].E386,al
    ENDM    

Poner_Limite3 MACRO Descriptor
        mov        edi,offset Descriptor
        mov        es:[edi].LIMIT,ax
        shr        eax,16
        mov        ah,es:[edi].E386
        and        ah,11110000b
        and        al,00001111b
        add        al,ah
        mov        es:[edi].E386,al
    ENDM    



PonerBits MACRO Accesso,E386,Descriptor
        mov        ah,Acceso
        mov        edi,offset Descriptor
        mov        es:[edi].GDT_ACCESS,ah
        mov        ah,E386
        and        ah,00001111b
        mov        al,es:[edi].E386
        and        al,11110000b
        add        al,ah
        mov        es:[edi].E386,al
    ENDM    

Llamada32_32 MACRO Selector,Desplazamiento
        db        9Ah
        dd        Desplazamiento
        dw        Selector
   ENDM

Llamada32_16 MACRO Selector,Desplazamiento
        db        66h
        db        9Ah
        dd        Desplazamiento
        dw        Selector
   ENDM

Llamada16_32 MACRO Selector,Desplazamiento
        db        66h
        db        9Ah
        dd        offset Desplazamiento
        dw        Selector
   ENDM

Llamada16_16 MACRO Selector,Desplazamiento
        db        09Ah
        dw        Desplazamiento
        dw        Selector
   ENDM   

Llamada16_TSS MACRO Tsr
        db        66h
        db        9Ah
        dd        0
        dw        Tsr
   ENDM

Llamada32_TSS MACRO Tsr
        db        9Ah
        dd        0
        dw        Tsr
   ENDM


Salto32_32 MACRO Selector,Desplazamiento
        db        0EAh
        dd        Desplazamiento
        dw        Selector
   ENDM
   
Salto32_16 MACRO Selector,Desplazamiento
        db        66h
        db        0EAh
        dw        Desplazamiento
        dw        Selector
   ENDM
   
Salto16_32 MACRO Selector,Desplazamiento
        db        66h
        db        0EAh
        dd        offset Desplazamiento
        dw        Selector
   ENDM
   
Salto16_16 MACRO Selector,Desplazamiento
        db        0EAh
        dw        Desplazamiento
        dw        Selector
   ENDM   

Salto16_TSS MACRO Tsr
        db        66h
        db        0EAh
        dd        0
        dw        Tsr
   ENDM

Salto32_TSS MACRO Tsr
        db        0EAh
        dd        0
        dw        Tsr
   ENDM


Salto_DS MACRO Variable_DWORD
        push      dword ptr ds:[Variable_DWORD+4]
        push      dword ptr ds:[Variabla_DWORD]
        retf
   ENDM
   
Salto_DS_EBX MACRO
        push      dword ptr ds:[ebx+4]
        push      dword ptr ds:[ebx]
        retf
   ENDM

Llamada_DS MACRO Variable_DWORD
     LOCAL Llamada_DS_vuelta
        push      cs
        push      dword ptr offset Llamada_DS_vuelta
        push      dword ptr ds:[Variable_DWORD+4]
        push      dword ptr ds:[Variable_DWORD]
        retf
 Llamada_DS_vuelta:
   ENDM
   
Llamada_DS_EBX MACRO Variable_DWORD
     LOCAL Llamada_DS_EBX_vuelta
        push      cs
        push      dword ptr offset Llamada_DS_EBX_vuelta
        push      dword ptr ds:[EBX+4]
        push      dword ptr ds:[EBX]
        retf
 Llamada_DS_EBX_vuelta:
   ENDM                
   
   
Hacer_BL MACRO Etiqueta,Limite,Variable
        mov        esi,offset Variable
        mov word ptr [esi],Limite
        xor        eax,eax
        mov        ax,seg Etiqueta
        shl        eax,4
        add        eax,offset Etiqueta
        mov dword ptr 2[esi],eax
   ENDM        

CompletaTSS MACRO Etiqueta , Selector
        push      ds
        push      ax
        push      esi
        mov       ax,seg Etiqueta
        mov       ds,ax
        mov       esi,offset Etiqueta
        mov       eax,cr3
        mov dword ptr 28[esi],eax
        mov       ax,Selector
        mov word ptr [esi],ax
        pop       esi
        pop       ax
        pop       ds
   ENDM

RecojerRejistros MACRO
        push        ds
        push        eax
        mov         ax,offset SELECTOR_DS
        mov         ds,ax
        pop         eax
        mov         REGS_EAX,eax
        pop         ax
        mov         REGS_EBX,ebx
        mov         REGS_ECX,ecx
        mov         REGS_EDX,edx
        mov         REGS_ESI,esi
        mov         REGS_EDI,edi
        mov         REGS_EBP,ebp
        mov         ebx,esp
        add         ebx,14
        mov         REGS_ESP,ebx
        mov         REGS_SS,ss
        mov         REGS_DS,ax
        mov         REGS_ES,es
        mov         REGS_FS,fs
        mov         REGS_GS,gs
        mov         ebx,ss:[esp+10]
        mov         ecx,ss:[esp+6]
        mov         edx,ss:[esp+2]
        mov         REGS_CS,cx
        mov         REGS_EIP,edx
        mov         REGS_EFLAGS,ebx
        mov         edx,cr0
        mov         REGS_CR0,edx
        mov         edx,cr2
        mov         REGS_CR2,edx
        mov         edx,cr3
        mov         REGS_CR3,edx
        mov         ds,ax
       ENDM
