//
// Archivo    : ERROR.C
// Descripcin: Archivo de cabecera donde se encuentran definidos todos los
//              errores que se pueden producir en el controlador de ficheros
// Autor      : Carlos Estan 
// Ult. Modif.: 1/12/98

  /* Atributos archivos BIOS */
  #define B_SOLO_LECTURA 0x01
  #define B_OCULTO       0x02
  #define B_SISTEMA      0x04
  #define B_VOLUMEN      0x08
  #define B_DIRECTORIO   0x10

  /* definicion de constantes de error */

  /* Errores de la BIOS */

  #define NO_ERROR   0x00   /* No error */
  #define CMD_INC    0x01   /* Comando Incorrecto */
  #define ADR_N_FD   0x02   /* Marca de direccion no encotrada */
  #define PROT_ESC   0x03   /* Intento de escritura en un dico protegido contra escritura */
  #define SECT_N_FD  0x04   /* Secto no encontrado */
  #define RST_FALL   0x05   /* Reset fallido */
  #define DISK_EXTR  0x06   /* Diskette fallido */
  #define TBL_INC    0x07   /* Tabla de parametros incorrecta */
  #define DMA_RBDA   0x08   /* DMA Rebasada */
  #define DMA_64KB   0x09   /* DMA mas alla de limite de 64Kb */
  #define SECT_INC   0x0A   /* Indicador de sector incorrecto */
  #define CIL_INC    0x0B   /* Cilindro incorrecto */
  #define MEDIA_INC  0x0C   /* Tipo de media incorrecto */
  #define ST_FMT_IN  0x0D   /* Numero de sectores no valido en formato */
  #define M_DT_CTR   0x0E   /* Detectata marca de direccion de datos de control */
  #define ARB_F_RG   0x0F   /* Nivel de arbitraje de DMA fuera de rango */
  #define CRC_INC    0x10   /* CRC o ECC incorrecto */
  #define ERR_ECC    0x11   /* Error de datos corregidos por ECC */
  #define CTR_INC    0x20   /* Fallo del controlador */
  #define BUSQ_INC   0x40   /* Fallo en la busqueda */
  #define TIMEOUT    0x80   /* Exceso de tiempo */
  #define NO_PREP    0xAA   /* Unidad no preparada */
  #define NO_DEF     0xBB   /* Error no definido */
  #define WRT_INC    0xCC   /* Fallo de escritura */
  #define ST_ERR     0xE0   /* Error de estado */
  #define DETECT_ER  0xFF   /* FAllo en operacion de deteccion */
  /* Errores ZEUS */
  #define YA_INIT    0x0100 /* Sistema de ficheros ya inicializado */
  #define NO_INIT    0x0101 /* Sistema de ficheros no inicializado */
  #define YA_MOUNT   0x0102 /* Unidad ya montada */
  #define DIR_BUSY   0x0103 /* Directorio ya ocupado */
  #define ERR_RUTA   0x0104 /* La ruta especificada no existe */
  #define ES_DIR     0x0105 /* Es un directorio */
  #define ES_FICH    0x0106 /* Es un fichero  */
  #define NO_EXIST   0x0107 /* La ruta especificada no existe */
  #define NO_ES_DIR  0x0108 /* La ruta especificada no corresponde a DIR  */
  #define NO_ES_FICH 0x0109 /* La ruta especificada no corresponde a FICH */
  #define NO_MEM     0x010A /* No hay memoria disponible */
  #define FAT12      0x0000 /* Es una FAT de 12 bits */
  #define FAT16      0x0001 /* Es una FAT de 16 bits */
  #define DISC_LLENO 0x010B /* Disco lleno */
  #define ERR_CACHE  0x010C /* Error idefinido en la cache */
  #define YA_EXIST   0x010D /* La ruta especificada ya existe */
  #define NO_EN_RAIZ 0x010E /* No hay entradas libres en el directorio Raiz */
  #define MEM_ERR    0x010F /* Error de memoria */
  #define SI_EXISTE  0x0110 /* El fichero si existe */
  #define NO_EXISTE  0x0111 /* El fichero no existe */
  #define ERR_NODEF  0x0112 /* Error indefinido */
  #define NO_VACIO   0x0113 /* Directorio no esta vacio */
  #define NO_HD      0x0114 /* La unidad no es un disco duro */
  #define NO_PART    0x0115 /* La Particion no existe */
  #define NO_LEE	 0x0116 // No puede leer del disco


  /* Llamadas a ZSF */
  #define INICIALIZA_ZSF              1
  #define CIERRA_ZSF                  2
  #define MONTAR_UNIDAD               3
  #define DESMONTAR_UNIDAD            4
  #define ABRIR_FICHERO               5
  #define CERRAR_FICHERO              6
  #define LEER_FICHERO                7
  #define ESCRIBIR_FICHERO            8
  #define SITUAR                      9
  #define LONG_FICHERO                10
  #define FIN_FICHERO                 11
  #define CREAR_FICHERO               12
  #define BORRAR_FICHERO              13
  #define CREAR_DIRECTORIO            14
  #define BORRAR_DIRECTORIO           15
  #define NUM_ENTRADAS_EN_DIRECTORIO  16
  #define LISTA_ARCHIVOS              17
  #define DAME_NOMBRE_FICHERO         18
  #define DAME_TIPO_FICHERO           19
  #define NUM_UNIDADES_MONTADAS       20
  #define DAME_UNIDADES_MONTADAS      21
