/*

        EXTENSOR.H

                    Realizado por Daniel Lancha Garcia

*/

// Definiciones basicas ...

#ifndef _SIZE_T_DEFINED_
#define _SIZE_T_DEFINED_
 typedef unsigned size_t;
#endif

#ifndef NULL
  #define NULL   0
#endif

#ifndef _EXTENSOR_H_INCLUDED
#ifdef __cplusplus

extern "C" {
#endif



//      *******************************
//      *********** GENERAL ***********
//      *******************************

// Ext_MSDOS : 0 = No MS-DOS , <> 0 Version MS-DOS
extern unsigned short Ext_MSDOS;

// Ext_CPU : 3= 386, 4= 486, 5 = 586
extern unsigned char Ext_CPU;


//      *******************************
//      *********** MEMORIA ***********
//      *******************************

// TIPO Ext_MemoriaDPMI : limit = longitud, Base = Direccion real ( paginada )
                        // handle necesario para operaciones ( liberar )
typedef struct{ unsigned int limit,base,handle;
              }Ext_MemoriaDPMI;   // Estructura de memoria DPMI

// TIPO Ext_LDT : Descriptores tanto GDT como LDT
typedef struct { unsigned short limit,base_low;
                 unsigned char base_med,access,e386,base_high;
                }Ext_LDT;

// VARIABLE Ext_DSP_DS : Segmento del DSP del programa
extern unsigned short Ext_DSP_DS;

// VARIABLE Ext_DSP : Parrafos que ocupa el programa
extern unsigned short Ext_DSP;

// VARIABLE Ext_MEM : Memoria total del sistema
extern unsigned int Ext_MEM;

// VARIABLE Ext_MemoriaVideo : Puntero a 0xA0000
extern void far* Ext_MemoriaVideo;

// PROCEDIMIENTO Ext_CopiarMemoria : Copia memoria far
extern void far Ext_CopiarMemoria(void far* fuente, void far *destino,
                                  unsigned int longitud);

// PROCEDIMIENTO Ext_BorrarMemoria : Rellena de ceros memoria far
extern void far Ext_BorrarMemoria(void far* destino, unsigned int longitud);

// PROCEDIMIENTO Ext_RellenarMemoria : Rellena de un byte memoria far
extern void far Ext_RellenarMemoria(void far* destino, unsigned int longitud,
                                    unsigned char valor );

// PROCEDIMIENTO Ext_LongitudCadena : Como strlen en memoria far
extern size_t Ext_LongitudCadena(char far* destino);

// PROCEDIMIENTO Ext_CrearAcceso : Crea el acceso de un descriptor
extern unsigned short far Ext_CrearAcceso(unsigned int tipo, unsigned int dpl,
                                          unsigned int defecto,
                                          unsigned int granularidad);

// PROCEDIMIENTO Ext_CrearSelector : Crea un selector -> <0 si error
                        // Devuelve: Selector o < 0 si error
extern unsigned short far Ext_CrearSelector(unsigned int base,
                                            unsigned int limite,
                                            unsigned short acceso);

// PROCEDIMIENTO Ext_HacerSelector : Hacer/Rehacer un selector Reservado
                        // Devuelve: Selector o < 0 si error
extern unsigned short far Ext_HacerSelector(unsigned int base,
                                 unsigned int limite,
                                 unsigned short acceso,
                                 unsigned short selector);

// PROCEDIMIENTO Ext_DestruirSelector : Libera un descriptor ( selector )
                        // Devuelve 0 si ha habido exito
extern int far Ext_DestruirSelector(unsigned short selector);

// PROCEDIMIENTO Ext_ReservarMemoriaDPMI : Por el limite de variable estruturada
                        // -1 si no ha habido exito
extern int far Ext_ReservarMemoriaDPMI(Ext_MemoriaDPMI far* memo);

// PROCEDIMIENTO Ext_LiberarMemoriaDPMI : A partir del Handle
                        // -1 si no ha habido exito
extern int far Ext_LiberarMemoriaDPMI(Ext_MemoriaDPMI far* memo);

// PROCEDIMIENTO Ext_HacerPuntero : Dando selector y desplazamiento
extern void far Ext_HacerPuntero(unsigned short selector,
                                 unsigned int desplazamiento,
                                 void far * far  *Ppuntero);

// PROCEDIMIENTO Ext_Segmento : Devuelve el selector de un puntero
extern unsigned short far Ext_Segmento( void far * puntero );

// PROCEDIMIENTO Ext_Desplazamiento : Devuelve el desplazamiento de un puntero
extern unsigned int far Ext_Desplazamiento( void far * puntero );


// PROCEDIMIENTO Ext_DescriptorLDT : Completa LDT
extern void far Ext_DescriptroLDT( unsigned int Posicion,
                                   unsigned int Base,
                                   unsigned int Limite,
                                   unsigned short Acceso,
                                   unsigned short Selector_LDT);

// PROCEDIMIENTO Ext_Copy2LDT : Copia un selector GDT a LDT
extern void far Ext_Copy2LDT( unsigned short Selector_GDT,
                              unsigned short ID_Task,
                              unsigned int Entrada_LDT,
                              unsigned int ldt);

// PROCEDIMIENTO Ext_malloc :  Necesita explicacion ?
extern void *Ext_malloc( size_t __size );

// PROCEDIMIENTO Ext_calloc : ?
extern void *Ext_calloc( size_t __n,size_t __size );

// PROCEDIMIENTO Ext_free: ?
extern void Ext_free( void *__ptr );

// PROCEDIMIENTO Ext_memcpy: ?
extern void *Ext_memcpy( void *__s1, const void *__s2, size_t __n );

// PROCEDIMIENTO Ext_memset: ?
extern void *Ext_memset( void *__s, int __c, size_t __n );

// PROCEDIMIENTO Ext_strlen: ?
extern size_t Ext_strlen( const char *__s );

// PROCEDIMIENTO Ext_strcpy: ?
extern char *Ext_strcpy( char *__s1, const char *__s2 );

// PROCEDIMIENTO Ext_strncpy: ?
extern char *Ext_strncpy( char *__s1, const char *__s2, size_t __n );

// PROCEDIMIENTO Ext_strset: ?
extern char *Ext_strset( char *__string, int __c );

// PROCEDIMIENTO Ext_strnset: ?
extern char *Ext_strnset( char *__string, int __c, size_t __len );

// PROCEDIMIENTO Ext_strcmp: ?
extern int Ext_strcmp( const char *__s1, const char *__s2 );

// PROCEDIMIENTO Ext_strncmp: ?
extern int Ext_strncmp( const char *__s1, const char *__s2, size_t __n );


//      *****************************
//      *********** TIMER ***********
//      *****************************

// TIPO Ext_TSS : Esctructura de un Estado tarea
typedef struct {
                 unsigned short backlink,reservado1; // TSS anterior
                 unsigned int esp0;             // Registros 386 ...
                 unsigned short ss0,reservado2;
                 unsigned int esp1;
                 unsigned short ss1,reservado3;
                 unsigned int esp2;
                 unsigned short ss2,reservado4;
                 unsigned int cr3;
                 unsigned int eip;
                 unsigned int eflags;
                 unsigned int eax;
                 unsigned int ecx;
                 unsigned int edx;
                 unsigned int ebx;
                 unsigned int esp;
                 unsigned int ebp;
                 unsigned int esi;
                 unsigned int edi;
                 unsigned short es,reservado5;
                 unsigned short cs,reservado6;
                 unsigned short ss,reservado7;
                 unsigned short ds,reservado8;
                 unsigned short fs,reservado9;
                 unsigned short gs,reservado10;
                 unsigned short ldtr,reservado11;
                 unsigned short tbit,iobase;
                 unsigned short countdown; // ticks en ejecuccion
                 unsigned short bits; // bits de activo, terminado y usuario
                }Ext_TSS;

// TIPO Ext_Task : Estructura de una tarea
typedef struct {
                 unsigned short ID;  // Identificador = Selector Base ( TSS )
                 unsigned int longitud_pila;    // Tamao de pila
                 unsigned int longitud_LDT;     // y LDT en bytes
                 unsigned char dpl;             // Privilegio
                 Ext_TSS far *TSS;              // Puntero al TSS
                 Ext_LDT far *LDT;              // Puntero al LDT
                 void *entrada;             // Procedimiento: tarea en si
                }Ext_Task;

// VARIABLE Ext_TIMER_COUNT : Cuenta del timer
extern unsigned int Ext_TIMER_COUNT;

// VARIABLE Ext_TIMER_OVERFLOW : Overflows de la cuenta del timer
extern unsigned int Ext_TIMER_OVERFLOW;

// VARIABLE Ext_TIMER_ACTUAL : Numero de la Tarea actual
extern unsigned short Ext_TIMER_ACTUAL;

// VARIABLE Ext_TASK_BUFFER : Puntero a el buffer de tareas
extern unsigned short far *Ext_TASK_BUFFER;

// VARIABLE Ext_TASK : ID de la Tarea actual
extern unsigned short Ext_TASK;

// VARIABLE Ext_END_TASKS : N de tareas terminadas
extern unsigned int Ext_END_TASKS;

// VARIABLE Ext_TIMER_ERROR : Procedimiento en error critico del timer
extern void far* Ext_TIMER_ERROR();

// PROCEDIMIENTO Ext_settimer : Velocidad del timer ( 0xFFFF < 0x0000 )
extern void far Ext_settimer(unsigned short velocidad);

// PROCEDIMIENTO Ext_readtimer : Leer velocidad del timer
extern unsigned short far Ext_readtimer();

// PROCEDIMIENTO Ext_ExclusionMutua : 1 : No hay cambio de tarea , 0 : Si
extern void far Ext_ExclusionMutua(int booleano);

// PROCEDIMIENTO Ext_NextTask : Pasa a la tarea siguiente en la cola
extern void far Ext_NextTask(int veces);

// PROCEDIMIENTO Ext_InicTask : Inicializa una tarea -> Selector base ( ID )
                        // Devuelve < 0xFFFF si error
extern unsigned short far Ext_InicTask(unsigned int Longitud_pila,
                                       unsigned int Longitud_LDT,
                                       unsigned short dpl);

// PROCEDIMIENTO Ext_FreeTask : Libera una tarea ( memoria y selectores )
extern void far Ext_FreeTask(unsigned short ID_o_SelectorBase);

// PROCEDIMIENTO Ext_NewTask : Completa basicamente TSS y LDT
                // Devuelve el ID de la tarea o 0 si error
extern unsigned short far Ext_NewTask( Ext_Task far *tarea );


//      *******************************
//      *********** TECLADO ***********
//      *******************************

// VARIABLE Ext_KEYBOARD_HIT : Tecla pulsada
extern unsigned char Ext_KEYBOARD_HIT;

// VARIABLE Ext_KEYBOARD_SPEC : N de teclas especiales pulsadas
extern unsigned char Ext_KEYBOARD_SPEC;

// VARIABLE Ext_KEYBOARD_KEY : Array de booleanos de teclas pulsadas
extern unsigned char Ext_KEYBOARD_KEY[256];

// VARIABLE Ext_KEYBOARD_BUFF : Buffer del teclado
extern unsigned char Ext_KEYBOARD_BUFF[1024];

// VARIABLE Ext_KEYBOARD_READ : Puntero del buffer para lectura
extern unsigned short Ext_KEYBOARD_READ;

// VARIABLE Ext_KEYOBARD_WRITE : Puntero del buffer para escritura
extern unsigned short Ext_KEYBOARD_WRITE;

// VARIABLE Ext_KEYBOARD_LEDS : Booleano -> Funcionamiento LEDs
extern unsigned char Ext_KEYBOARD_LEDS;

// VARIABLE Ext_KEYBOARD_OVERFLOW : Booleano -> Sobrecarga del buffer
extern unsigned char Ext_KEYBOARD_OVERFLOW;

// VARIABLE Ext_KEYBOARD_CAPS : Booleano -> Mayusculas
extern unsigned char Ext_KEYBOARD_CAPS;

// VARIABLE Ext_KEYBOARD_NUM : Booleano -> Teclado numerico
extern unsigned char Ext_KEYBOARD_NUM;

// VARIABLE Ext_KEYBOARD_BLOQ : Booleano -> Bloquea desplazamiento
extern unsigned char Ext_KEYBOARD_BLOQ;

// VARIABLE Ext_CTRL_ALT_DEL : Booleano -> Captura CTRL+ALT+DEL
extern unsigned char Ext_CTRL_ALT_DEL;

// VARIABLE Ext_CTRL_ALT_DEL_PROC : Procedimiento CTRL+ALT+DEL
extern void far* Ext_CTRL_ALT_DEL_PROC();

// VARIABLE Ext_KEYBOARD_MAP : Puntero hacia el mapa del teclado ( omision ESPAOL )
extern void far *Ext_KEYBOARD_MAP;

// VARIABLE KEYBOARD_CERO : Booleano de cero en Teclado ?
extern unsigned char KEYBOARD_CERO;

// PROCEDIMIENTO Ext_keyboardleds : Actualizar los LEDS ( variables )
extern void far Ext_keyboardleds();

// PROCEDIMIENTO Ext_keypressed : Booleano -> Tecla mapeada pulsada
extern unsigned int far Ext_keypressed();

// PROCEDIMIENTO Ext_map : Cambiar el mapa del teclado
extern void far Ext_map( void far* Mapa );

// PROCEDIMIENTO Ext_getch : Como getch del C ( devuelve ascii )
extern unsigned char far Ext_getch();

// PROCEDIMIENTO Ext_keyhit : Booleano -> Codigo de la tecla pulsada
extern unsigned int far Ext_keyhit();

// PROCEDIMIENTO Ext_getkey : Como getch pero con el codigo de la tecla
extern unsigned char far Ext_getkey();


//      *****************************
//      *********** DISCO ***********
//      *****************************

// VARIABLE Ext_FDC_UNIDAD : Unidad actual
extern unsigned char far Ext_FDC_UNIDAD;

// VARIABLE Ext_FDC_VELOCIDAD : Capacidad del disco ( 1.44 , 1.22 , etc.. )
extern unsigned char far Ext_FDC_VELOCIDAD;

// VARIABLE Ext_FDC_CABEZAL : Cabezal actual
extern unsigned char far Ext_FDC_CABEZAL;

// VARIABLE Ext_FDC_CILINDRO : Cilindro actual
extern unsigned char far Ext_FDC_CILINDRO;

// VARIABLE Ext_FDC_DMA : Puntero a la pagina DMA ( 64 Kbytes )
extern void far *Ext_FDC_DMA;

// PROCEDIMIENTO Ext_FDC_MotorON : Enciende el motor de una unidad
extern void far Ext_FDC_MotorON(unsigned int unidad);

// PROCEDIMIENTO Ext_FDC_MotorOFF : Apaga el motor de una unidad
extern void far Ext_FDC_MotorOFF(unsigned int unidad);

// PROCEDIMIENTO Ext_FDC_Select : Selecciona una unidad
        // Unidad : 0 = A , 1 = B ...
 // Velocidad = Densidad :  0 : 1.44 o 1.2 , 1 : 360 K , 2 : 720 , 3 : 2.88
                // Devuelve: 0 = Bien , -1 : Mal
extern int far Ext_FDC_Select(unsigned int unidad,unsigned int velocidad);

// PROCEDIMIENTO Ext_FDC_Recalibrate : Recalibra la unidad actual
        // Necesario siempre despues de Ext_FDC_Select
                // Devuelve: 0 = Bien , -1 : Mal
extern int far Ext_FDC_Recalibrate(unsigned int cabezal);

// PROCEDIMIENTO Ext_FDC_Seek : Posiciona los cabezales
                // Devuelve: 0 = Bien , -1 : Mal
extern int far Ext_FDC_Seek(unsigned int cabezal,unsigned int cilindro);

// PROCEDIMIENTO Ext_FDC_Read : Lee sectores a la pagina DMA
     // Offset : Desplazamiento en la pagina DMA donde se almacenan los datos
     // Tamanio : Tamao del sector, desde 128 hasta 4098 ( 512 = 1.44 MSDOS )
                // Devuelve: 0 = Bien , -1 : Mal
extern int far Ext_FDC_Read(unsigned int cabezal,unsigned int cilindro,
                            unsigned int offset,unsigned int tamanio,
                            unsigned int sector,unsigned int nSectores);

// PROCEDIMIENTO Ext_FDC_Write : Escribe sectores desde la pagina DMA
     // Offset : Desplazamiento en la pagina DMA donde se almacenan los datos
     // Tamanio : Tamao del sector, desde 128 hasta 4098 ( 512 = 1.44 MSDOS )
                // Gap : 1/2 del formateo ( 54 = MSDOS )
                // Devuelve: 0 = Bien , -1 : Mal
extern int far Ext_FDC_Write(unsigned int cabezal,unsigned int cilindro,
                            unsigned int offset,unsigned int tamanio,
                            unsigned int sector,unsigned int nSectores,
                            unsigned int gap);

// PROCEDIMIENTO Ext_FDC_Format : Formatea un sector en la pagina DMA
   // Offset : Desplazamiento en la pagina DMA donde se almacenan init bytes
                // Gap :  108 = MSDOS
                // ByteInicio : Byte con el que se iniciaran los sectores
                // Devuelve: 0 = Bien , -1 : Mal
extern int far Ext_FDC_Format(unsigned int cabezal,unsigned int cilindro,
                            unsigned int offset,unsigned int tamanio,
                            unsigned int gap,unsigned int nSectores,
                            unsigned int ByteInicio);

/*      ***********************************
        **********  EXCEPCIONES ***********
        ***********************************

                0  : Division por 0
                1  : Depuracion paso a paso
                2  : Interrupcion no emascarable - Fallo critico
                3  : Punto de ruptura en depuracion
                4  : Desbordamiento
                5  : Comprobacion de limites
                6  : Codigo de operacion invalido
                7  : Coprocesador no disponible
                8  : Fallo doble - En otra excepcion
                9  : Overrum de segmento de coprocesador
                10 : Segmento de estado de tarea invalido
                11 : Segmento ausente
                12 : Referencia a pila no valida
                13 : Proteccion general
                14 : Fallo de pagina
                15 : Proteccion general
                16 : Error de coprocesador
                17 : Proteccion general
*/
extern void far* Ext_EXCEPCION_0_PROC(); // Procedimiento en excepcion 0
extern void far* Ext_EXCEPCION_1_PROC(); // Procedimiento en excepcion 1
extern void far* Ext_EXCEPCION_2_PROC(); // Procedimiento en excepcion 2
extern void far* Ext_EXCEPCION_3_PROC(); // Procedimiento en excepcion 3
extern void far* Ext_EXCEPCION_4_PROC(); // Procedimiento en excepcion 4
extern void far* Ext_EXCEPCION_5_PROC(); // Procedimiento en excepcion 5
extern void far* Ext_EXCEPCION_6_PROC(); // Procedimiento en excepcion 6
extern void far* Ext_EXCEPCION_7_PROC(); // Procedimiento en excepcion 7
extern void far* Ext_EXCEPCION_8_PROC(); // Procedimiento en excepcion 8
extern void far* Ext_EXCEPCION_8_PROC(); // Procedimiento en excepcion 9
extern void far* Ext_EXCEPCION_10_PROC(); // Procedimiento en excepcion 10
extern void far* Ext_EXCEPCION_11_PROC(); // Procedimiento en excepcion 11
extern void far* Ext_EXCEPCION_12_PROC(); // Procedimiento en excepcion 12
extern void far* Ext_EXCEPCION_13_PROC(); // Procedimiento en excepcion 13
extern void far* Ext_EXCEPCION_14_PROC(); // Procedimiento en excepcion 14
extern void far* Ext_EXCEPCION_15_PROC(); // Procedimiento en excepcion 15
extern void far* Ext_EXCEPCION_16_PROC(); // Procedimiento en excepcion 16
extern void far* Ext_EXCEPCION_17_PROC(); // Procedimiento en excepcion 17

/*      **************************************
        **********  INTERRUPCIONES ***********
        **************************************

          ---- IRQs ----
                0  : Timer
                1  : Teclado
                2  : Video ?
                3  : Puerto serie 2
                4  : Puerto serie 1
                5  : Disco duro
                6  : Disco flexible
                7  : Puerto paralelo
                8  : Reloj en tiempo real
                9  : Redireccion en cascada ?
                A  : Reservado ?
                B  : Reservado ?
                C  : PS/2 Mouse ?
                D  : Excepcion de coprocesador ?
                E  : Control de disco duro
                F  : Reservado ?
         ---- TRAPs ----
               30h : Task Trap
               31h : DPMI
               32h : Disponible
               33h : Disponible
               34h : Disponible
               35h : Disponible
               36h : Disponible
               37h : Disponible
               38h : Disponible
               39h : Disponible
               3Ah : Disponible
               3Bh : Disponible
               3Ch : Disponible
               3Dh : Disponible
               3Eh : Disponible
               3Fh : Disponible
*/

// VARIABLE Ext_INT_INVALIDA_PROC: Procedimiento en interrupcion no valida.
extern void far* EXT_INT_INVALIDA_PROC();

// VARIABLE Ext_IRQ...
extern void far* Ext_IRQ0_PROC(); // Timer de usuario
extern void far* Ext_IRQ1_PROC(); // Teclado usuario
extern void far* Ext_IRQ2_PROC();
extern void far* Ext_IRQ3_PROC();
extern void far* Ext_IRQ4_PROC();
extern void far* Ext_IRQ5_PROC();
extern void far* Ext_IRQ6_PROC();
extern void far* Ext_IRQ7_PROC();
extern void far* Ext_IRQ8_PROC();
extern void far* Ext_IRQ9_PROC();
extern void far* Ext_IRQA_PROC();
extern void far* Ext_IRQB_PROC();
extern void far* Ext_IRQC_PROC();
extern void far* Ext_IRQD_PROC();
extern void far* Ext_IRQE_PROC();
extern void far* Ext_IRQF_PROC();

// VARIABLE Ext_Trap...
extern void far* Ext_TRAP32_PROC();
extern void far* Ext_TRAP33_PROC();
extern void far* Ext_TRAP34_PROC();
extern void far* Ext_TRAP35_PROC();
extern void far* Ext_TRAP36_PROC();
extern void far* Ext_TRAP37_PROC();
extern void far* Ext_TRAP38_PROC();
extern void far* Ext_TRAP39_PROC();
extern void far* Ext_TRAP3A_PROC();
extern void far* Ext_TRAP3B_PROC();
extern void far* Ext_TRAP3C_PROC();
extern void far* Ext_TRAP3D_PROC();
extern void far* Ext_TRAP3E_PROC();
extern void far* Ext_TRAP3F_PROC();

#define _EXTENSOR_H_INCLUDED
#ifdef __cplusplus
};

// En C++ se sobrecargar el operador new y delete...

void * operator new(size_t t)
{
        return Ext_malloc(t);
}
void * operator new(size_t t, int n)
{
        return Ext_malloc(t*n);
}

void operator delete(void *q)
{
        Ext_free(q);
}

#endif
#endif


