//Implementa <cMailBox>

#include <extensor.h>
#include "zeus.h"
#include "mailbox.h"

//-----PRIVADOS--------
//Busca el primo mas cercano a MAX_PROC
unsigned int cMailBox::SearchHashFactor()
{
unsigned int flag;

	for(unsigned int c1=MAX_PROCS;c1>0;c1--){
		flag=0;
		for(unsigned int c2=c1-1;c2>1;c2--)
			if((c1%c2)==0){
				flag=1;
				break;
			}else continue;
		if(flag==0) return c1;
	}
	return 0;
};

//Busca mediante una funcin hash la posicin del buzn
unsigned int cMailBox::HashFunction(unsigned int num)
{
	return num%HashFactor;
};

//-----PUBLICOS--------
//Constructores del Sistema de Buzones
cMailBox::cMailBox()
{
	Owner=this;
    ListOfDrivers=NULL;
    WriteDrivers=NULL;
	HashFactor=SearchHashFactor();
	NumBox=0;
	Ext_memset(BoxArray,0,(MAX_PROCS+1)*sizeof(RegMessageBox));
};
cMailBox::cMailBox(void *ow)
{
	Owner=ow;
// Modificado por Sergio Coscolin
	ListOfDrivers=NULL;
	WriteDrivers=NULL;
// Fin Modificado
	HashFactor=SearchHashFactor();
	NumBox=0;
	Ext_memset(BoxArray,0,(MAX_PROCS+1)*sizeof(RegMessageBox));
};

//Aade un cajn de buzn
int cMailBox::AddBox(cMessageBox *mb)
{
static int ind,boxCount;

	if(NumBox==MAX_PROCS) return bNOSPACE; //Todos los buzones llenos
	Ext_ExclusionMutua(1);
	ind=HashFunction((unsigned int)mb->ReturnOwner());//Buscar posicin propietario
	boxCount=0;
	while(BoxArray[ind].Map!=bFREE){ //mientras el buzn est ocupado
		if(++ind>MAX_PROCS) ind=0;	 //Acabo array, empiezo por 0
		if(++boxCount>NumBox){		 //Todos los buzones llenos revisados
			Ext_ExclusionMutua(0);
			return bNOFOUNDOWNER;	 //No encontrado el propietario
		}
	}
	BoxArray[ind].Map=bBLOCK;	//Bloqueo buzn
	BoxArray[ind].bBuffer=mb;	//Asigno la instanci del buzn de usuario
	BoxArray[ind].Map=bUSED;	//Desbloqueo del buzn
	++NumBox;					//Incremento de nmero de buzones
	Ext_ExclusionMutua(0);
	return bNOERROR;            //Retorno sin error
};

//Aade buzn de controlador
int cMailBox::AddDriverBox(unsigned int di,cMessageBox *mb)
{
BasicDriver *bdAux;

    Ext_ExclusionMutua(1);
    bdAux=ListOfDrivers;
    //Ver si existe el controlador
    while(bdAux!=NULL){
        if(bdAux->DriverId==di) return bDRIVEREXIST;//Si existe error
        bdAux=bdAux->next;//Sigue buscando
    }
    //Crea nodo de driver
	bdAux=(BasicDriver*)Ext_malloc(sizeof(BasicDriver));
    //Asigna valores y lo enlaza a la lista de drivers
	bdAux->DriverId=di;
    bdAux->DriverBox=mb;
    bdAux->next=NULL;
    if(ListOfDrivers==NULL)
		ListOfDrivers=bdAux;
    else
        WriteDrivers->next=bdAux;
    WriteDrivers=bdAux;
    Ext_ExclusionMutua(0);
    return AddBox(mb);
}

//Elimina buzn de controlador
int cMailBox::RemoveDriverBox(cMessageBox *mb)
{
BasicDriver *bdAux,*bdAux2;

	Ext_ExclusionMutua(1);
	bdAux=ListOfDrivers;
	bdAux2=ListOfDrivers;
	//Ver si existe el controlador
	while(bdAux!=NULL){
		if(bdAux->DriverBox==mb){//Eliminar buzn
			//Si 1er elemento
			if(ListOfDrivers==bdAux) ListOfDrivers=bdAux->next;
			//Si ltimo elemento
			if(bdAux==WriteDrivers){
				bdAux->next=NULL;
				WriteDrivers=bdAux2;
			}
			delete(bdAux);
			Ext_ExclusionMutua(0);
			return RemoveBox(mb);
		}
		bdAux2=bdAux;
		bdAux=bdAux->next;//Sigue buscando
	}
	if(bdAux==NULL){
		Ext_ExclusionMutua(0);
		return bDRIVERNOTEXIST;
	}
	return bERROR;
}

//Elimina un cajn de buzn
int cMailBox::RemoveBox(cMessageBox *mb)
{
// Modificado por Sergio Coscolin
//static int ind,pos,boxCount;
//	for(ind=0;ind<=MAX_PROCS;ind++)
//		if(BoxArray[ind].Map!=bFREE){
//			if(BoxArray[ind].Map!=bBLOCK) Ext_NextTask(1);
//			Ext_memset(&BoxArray[ind],0,sizeof(RegMessageBox));//Inicializo el registro del buzn
//		}
//	return bNOERROR;
	int ind;
	for(ind=0;ind<=MAX_PROCS;ind++)
	  if(BoxArray[ind].Map!=bFREE)
		if(BoxArray[ind].bBuffer==mb)
		{
		  while(BoxArray[ind].Map==bBLOCK) Ext_NextTask(1);//Mientras bloqueado el buzn cambio de tarea
		  Ext_memset(&BoxArray[ind],0,sizeof(RegMessageBox));//Inicializo el registro del buzn
		  return bNOERROR;
		}
	return bNOERROR;
};

int cMailBox::RemoveBox(void *ow)
{
static int ind,pos,boxCount;

	if(NumBox==0) return bNOBOXES; 	//Todo los buzones vacos
	Ext_ExclusionMutua(1);
	ind=HashFunction((unsigned int)ow); //Posicin del buzn
	boxCount=0;
	pos=0;
	while(pos++<MAX_PROCS){
		if(BoxArray[ind].Map!=bFREE){	//Si est ocupado el buzn
			if(BoxArray[ind].bBuffer->ReturnOwner()==ow) break; //Si encontrado el propietario salir
			if(++ind>MAX_PROCS) ind=0; 	//Acabo array, empiezo por 0
			if(++boxCount>NumBox){		//Revisado stodos los buzones llenos
				Ext_ExclusionMutua(0);
				return bNOFOUNDOWNER;   //No encontrado propietario
			}
		}else ind++;
	}
// Modificado por Sergio Coscolin
//	while(BoxArray[ind].Map==bBLOCK)Ext_NextTask;//Mientras bloqueado el buzn cambio de tarea
	while(BoxArray[ind].Map==bBLOCK)Ext_NextTask(1);//Mientras bloqueado el buzn cambio de tarea
	BoxArray[ind].Map=bBLOCK;		//Bloqueo el buzn
	//delete(BoxArray[ind].bBuffer);  //Elimino el buzn
	Ext_memset(&BoxArray[ind],0,sizeof(RegMessageBox));//Inicializo el registro del buzn
	--NumBox;						//Decremento n de buzones
	Ext_ExclusionMutua(0);
	return bNOERROR;				//Salida sin error
};

//Indica si existe una buzn de propietario mb
int cMailBox::ExistMessageBox(void *ow)
{
static int ind,pos,boxCount;

	if(NumBox==0) return bNOBOXES;	//No hay buzones creados
	Ext_ExclusionMutua(1);
	ind=HashFunction((unsigned int)ow);	//Buscar posicin de propietario
	boxCount=0;
	pos=0;
	while(pos++<MAX_PROCS){
		if(BoxArray[ind].Map!=bFREE){	//Mientras registro no libre
			if(BoxArray[ind].bBuffer->ReturnOwner()==ow){//Si encuentro el rpopietario
				Ext_ExclusionMutua(0);
				return bEXIST;	//Lo devuelvo
			}
			if(++ind>MAX_PROCS) ind=0;	//Acabo el array, empiezo por 0
			if(++boxCount>NumBox){		//No encontrado el propietario
				Ext_ExclusionMutua(0);
				return bNOFOUNDOWNER;
			}
		}else ind++;
	}
	Ext_ExclusionMutua(0);
	return bERROR;			//Retorno sin error
};

//Manda el mensaje al destino
int cMailBox::SendMsg(cMessage *msg)
{
static int ind,pos,boxCount;

	if(NumBox==0) return bNOBOXES;	//No hay buzones creados
	Ext_ExclusionMutua(1);
	ind=HashFunction((unsigned int)msg->ReturnDestination());//Hallar posicin de destino
	boxCount=0;
	pos=0;
	while(pos++<MAX_PROCS)
	{
		if(BoxArray[ind].Map!=bFREE)
		{//Mientras registro no libre
			//Si encuentro destino salir de bsqueda
			if(BoxArray[ind].bBuffer->ReturnOwner()==msg->ReturnDestination())
				break;
			if(++ind>MAX_PROCS) ind=0;	//Acabo el array, empiezo por 0
			if(++boxCount>NumBox)
			{		//No encontrado el propietario
				Ext_ExclusionMutua(0);
				return bNOFOUNDOWNER;
			}
		}else ind++;
	}
	while(BoxArray[ind].Map==bBLOCK)
		Ext_NextTask(1); //Cambiar de tarea mientras el buzn est bloqueado
	switch(mNOSPACE==BoxArray[ind].bBuffer->AddMsg(msg)){//Aadir buzn
	case(mNOSPACE)	:Ext_ExclusionMutua(0);
					return bNOSPACE+0xF0000000;	//No hay espacio
	case(mERROR)	:Ext_ExclusionMutua(0);
					return bERROR+0xF0000000;	//Hay error
	}
	Ext_ExclusionMutua(0);
	return bNOERROR;							//No hay error
};

int cMailBox::SendCtrl(unsigned int di,cMessage *msg)
{
BasicDriver	*bdAux;

	Ext_ExclusionMutua(1);
	bdAux=ListOfDrivers;
	while(bdAux!=NULL){
		if(bdAux->DriverId==di){
			Ext_ExclusionMutua(0);
			return (bdAux->DriverBox->AddMsg(msg));
		}
		bdAux=bdAux->next;
	}
	if(bdAux==NULL){
		Ext_ExclusionMutua(0);
		return bDRIVERNOTEXIST;
	}
	return bERROR;
}

//Devuelve la direccin del buzn de un propietario
cMessageBox *cMailBox::MyBox(void *ow)
{
static int ind,pos,boxCount;

	if(NumBox==0) return NULL;	//Si no hay buzones retorno NULL(error)
	Ext_ExclusionMutua(1);
	boxCount=0;
	pos=ind=HashFunction((unsigned int)ow);//Hallar registro del propietario
	boxCount=0;
	pos=0;
	while(pos++<MAX_PROCS){
		if(BoxArray[ind].Map!=bFREE){	//Mientras buzn ocupado
			if(BoxArray[ind].bBuffer->ReturnOwner()==ow){//Si buzn encontrado
				Ext_ExclusionMutua(0);
				return BoxArray[ind].bBuffer;//Devolver @ buzn
			}
			if(++ind>MAX_PROCS) ind=0;	//Acabo el array empiezo por 0
			if(++boxCount>NumBox){		//No encontrado el propietario
				Ext_ExclusionMutua(0);
				return NULL;			//Devuelvo NULL (error)
			}
		}else ind++;
	}
	Ext_ExclusionMutua(0);
	return NULL;					//Devuelvo NULL (error)
}

//Devuelve el propietario del cajn de buzn
void *cMailBox::ReturnOwner()
{
	return Owner;					//Devuelvo propietario
};



//Destructor del Sistema de Buzones
cMailBox::~cMailBox()
{
};



