//Implementa <cMessageBox>

#include <extensor.h>
#include "zeus.h"
#include "messbox.h"

//Constructores
cMessageBox::cMessageBox()
{
	Owner=this;
    BoxFlags.Wait=0x0;
    BoxFlags.New=0x0;
    BoxFlags.OverMsg=0x0;
    BoxFlags.MsgMask=0x0;
    ReadMsg=NULL;
    WriteMsg=NULL;
    ListMsg=NULL;
	NumMsg=0;
	error=0;
};
cMessageBox::cMessageBox(void *ow)
{
	Owner=ow;
    BoxFlags.Wait=0x0;
    BoxFlags.New=0x0;
    BoxFlags.OverMsg=0x0;
	BoxFlags.MsgMask=0x0;
	ReadMsg=NULL;
	WriteMsg=NULL;
	ListMsg=NULL;
	NumMsg=0;
	error=0;
};

//Aade un mensaje dentro del cajn
int cMessageBox::AddMsg(cMessage *mess)
{
	//Tratar mensaje mascarado si procede
	if(BoxFlags.MsgMask==0x1){
		if((mess->ReturnFlagDriver()==WaitMask.FlagDriver)&&
		   (mess->ReturnFlagFunction()==WaitMask.FlagFunction)){
			MsgMasked=new cMessage(mess);
			BoxFlags.MsgMask=0x0;
			// Modificado por Sergio Coscolin
			if(this->ReturnOwner()!=Sche->MB->ReturnOwner())
			{
				Sche->Whois(this->ReturnOwner())->BitMsg(0);// Bit mensaje a 0 => No Espera msg
				Sche->Whois(this->ReturnOwner())->Activar();
			}
			return mNOERROR;
		}
	}

	//Preparo nodo auxiliar
	AuxMsgNode=(MessageNode*)Ext_malloc(sizeof(MessageNode));
	AuxMsgNode->Map=mBLOCK;
	AuxMsgNode->mBuffer=new cMessage(mess);
	AuxMsgNode->next=NULL;

	//Si no hay mensajes al ppio
	if(ListMsg==NULL){
		ReadMsg=AuxMsgNode;  //
		WriteMsg=AuxMsgNode; // Primer elemento, todos le apuntan
		ListMsg=AuxMsgNode;  //
	}else{
	//Sino al final
		WriteMsg->next=AuxMsgNode;
		WriteMsg=AuxMsgNode;
	}
	WriteMsg->Map=mUSED;//Desbloqueo del registro
	++NumMsg;
	BoxFlags.New=0x1;
	BoxFlags.Wait=0x1;
	// Modificado por Sergio Coscolin
	if(this->ReturnOwner()!=Sche->MB->ReturnOwner())
	{
		Sche->Whois(this->ReturnOwner())->BitMsg(0);// Bit mensaje a 0 => No Espera msg
		Sche->Whois(this->ReturnOwner())->Activar();
	}
	return mNOERROR;
};

//Devuelve el propietario del mensaje
void *cMessageBox::ReturnOwner()
{
	return Owner;
};

//Devuelve el estado el cajn
tFlagMsgBox cMessageBox::ReturnStatus()
{
	return BoxFlags;
};
unsigned int cMessageBox::ReturnOverMsg()
{
	return BoxFlags.OverMsg;
};
unsigned int cMessageBox::ReturnNew()
{
	return BoxFlags.New;
};
unsigned int cMessageBox::ReturnWait()
{
	return BoxFlags.Wait;
};
void cMessageBox::SetOverMsg(unsigned int v)
{
	BoxFlags.OverMsg=v;
};
void cMessageBox::SetNew(unsigned int v)
{
    BoxFlags.New=v;
};
void cMessageBox::SetWait(unsigned int v)
{
    BoxFlags.Wait=v;
};

//Elimina los mensajes ledos
void cMessageBox::PurgueMsg(){};

//Devuelve primer mensaje en lista y lo marca como ledo
int cMessageBox::ReturnMsg(cMessage *msg, int r)
{
	if(ListMsg==NULL) return mNOMESSAGES;
	ReadMsg->mBuffer->SetRead(1);//ledo
	switch(r){
	case(_REMOVE):
		//Al leer desactivo nuevos
		BoxFlags.New=0x0;

		//Valores del mensaje
		msg->SetAdrSource(ReadMsg->mBuffer->ReturnSource());
		msg->SetAdrDest(ReadMsg->mBuffer->ReturnDestination());
		msg->SetFunction(ReadMsg->mBuffer->ReturnFunction());
		msg->SetInfo(ReadMsg->mBuffer->ReturnInfo(),ReadMsg->mBuffer->ReturnInfoSize());
		ListMsg=ReadMsg->next;//Avanzo puntero de lectura
		delete(ReadMsg->mBuffer); //Elimino mensaje de lectura
		Ext_free(ReadMsg);//Elimino nodo de lectura
		ReadMsg=ListMsg;//Actualizo puntero de lectura
		--NumMsg;
		break;

	case(_NOREMOVE):
		BoxFlags.New=0x0;
		msg->SetAdrSource(ReadMsg->mBuffer->ReturnSource());
		msg->SetAdrDest(ReadMsg->mBuffer->ReturnDestination());
		msg->SetFunction(ReadMsg->mBuffer->ReturnFunction());
		msg->SetInfo(ReadMsg->mBuffer->ReturnInfo(),ReadMsg->mBuffer->ReturnInfoSize());
		break;
	}
	//Si no hay elementos iniciar punteros a NULL y borrar flag de espera
	if(NumMsg==0){
		ListMsg=NULL;
		ReadMsg=NULL;
		WriteMsg=NULL;
		BoxFlags.Wait=0x0;
	}
	return mNOERROR;
};

void cMessageBox::WaitForMsg()
{
	while(BoxFlags.Wait==0x0)
	// Modificado por Sergio Coscolin
	{
        Sche->Actual()->BitMsg(1);	// Bit mensaje del TSS a 1 => Espera msg
		Sche->Actual()->Desactivar();
		Ext_NextTask(1);
	}
};


void cMessageBox::WaitForMask(tFunctionMsg m,cMessage *msg)
{
	//Guardo mscara y activo flag de espera de mensaje
	WaitMask=m;
	BoxFlags.MsgMask=0x1;
	//Espera mientras no se ha encontrado mensaje
	while(BoxFlags.MsgMask)
		// Modificado por Sergio Coscolin
	{
		Sche->Actual()->BitMsg(1);	// Bit mensaje del TSS a 1 => Espera msg
		Sche->Actual()->Desactivar();
		Ext_NextTask(1);
	}
	msg->SetAdrSource(MsgMasked->ReturnSource());
	msg->SetAdrDest(MsgMasked->ReturnDestination());
	msg->SetFunction(MsgMasked->ReturnFunction());
	msg->SetInfo(MsgMasked->ReturnInfo(),MsgMasked->ReturnInfoSize());
	delete(MsgMasked);
}
int cMessageBox::WaitAndReturn(cMessage *msg,int r)
{
	WaitForMsg();
	return ReturnMsg(msg,r);
};

//Destructor de cajones
cMessageBox::~cMessageBox()
{
	while(ListMsg!=(MessageNode *)0){
		ReadMsg=ReadMsg->next;
		while(ListMsg->Map==mBLOCK) Ext_NextTask(1);
		delete ListMsg->mBuffer;
		Ext_free(ListMsg);
		ListMsg=ReadMsg;
	}
};
