/*
	DEFINICION DE LAS CLASES:
		Task
		BTASK
		BufferTeclado
		BufferPantalla
		Teclado
		Plan
	DEFINICION DE LAS ESTRUCTURAS:
		LBTask
		LTask
	DEFINICION DE LAS FUNCIONES:
		TRACE
		TRECEN
		number
		outb
	DEFINICION DE LAS CONSTANTES:
		de color
		de puertos del cursor

	REALIZADO POR:
		Sergio Coscolin Navarro
*/

#include "mailbox.h"

#ifndef ZEUS_H
#define ZEUS_H

typedef unsigned short ushort;
typedef unsigned char  uchar;
typedef unsigned int   uint;

void TRACE(char *a,int x=0, int y=0);
void TRACEN(uint n,int x=0, int y=0);
static char * number(char * str, int num, int base, int size, int precision
	,int type);

#define CRTC_COMMAND	0x3D4
#define CRTC_DATA	0x3D5
#define CRTC_CURLO	0x0F
#define CRTC_CURHI	0x0E

// Constantes de la funcion number
#define ZEROPAD	1		/* pad with zero */
#define SIGN	2		/* unsigned/signed long */
#define PLUS	4		/* show plus */
#define SPACE	8		/* space if plus */
#define LEFT	16		/* left justified */
#define SPECIAL	32		/* 0x */
#define SMALL	64		/* use 'abcdef' instead of 'ABCDEF' */

/* we use this so that we can do without the ctype library */
#define is_digit(c)	((c) >= '0' && (c) <= '9')

extern void outb(ushort port, uchar val);
#pragma aux outb = "out dx,al" parm [dx] [ax];

/***************************************************************************
			DEFINICION DE LA CLASE TAREA BASICA
***************************************************************************/
class Task
{
 private:
	ushort tid;		// Identificador de tarea = selector TSS
	ushort tpid;	// Identificador de tarea padre
	Ext_Task tarea;	// Estructura tarea del Extensor
 protected:
	ushort tipo;	// Identifica el tipo de la tarea: Task, BTask, Teclado, etc.
	void setState(ushort t);	// Modifica bits activo, terminado, etc.
	void Activar();				// Modifica el bit activo para activar la tarea
	void Desactivar();			// Modifica el bit activo para desactivar la tarea
	void setCount(ushort c);	// Modifica countdown
	void BitMsg(ushort c);		// Modifica el bit de mensaje. 1=Espera Msg
 public:
	class cMessage *Me, *Mr;
	class cMessageBox *MB;
	friend class Plan;		// Para que el planificador pueda acceder a protected
	friend class cMessageBox;// Para que el buzon pueda activar y desactivar tareas
	ushort getState(void);	// Devuelve bits activo, terminado, etc.
	ushort getTid(void);	// Devuelve identificador de tarea
	ushort getTpid(void);	// Devuelve identificador de tarea padre
	ushort Terminada(void);	// Devuelve <>0 si terminado=1
	ushort BitMsg();		// Devuelve el bit de mensaje
	ushort getCount(void);	// Devuelve CoutnDown
	ushort getStack(void);	// Devuelve tamao pila
	void * Inicio();			// Devuelve el punto de entrada de la tarea
	char * Nombre();			// Devuelve el nombre de la tarea
	char *nombre;

	void exit();
	Task (  void *inicio,   // Constructor
			char name[]="Tarea",
			uint pila=4096,
			uint ldt=128,
			uchar dpl=0);
	~Task();				// Destructor de la clase
};


/***************************************************************************
			DEFINICION DE LA CLASE BUFFER DE TECLADO
***************************************************************************/
class BufferTeclado
{
 private:
	char pila[512];			//la pila de las teclas pulsadas
	ushort inicio, fin;		//Donde tenemos que apilar
 protected:
	friend class Teclado;
	char cadena[5];			// cadena temporal para getch y getche
	ushort pos;				// posicion de la cadena temporal en gets
	void  apila   (char c); // Pretty obvious.
	char desapila(void);	// Idem
 public:
   BufferTeclado (void); 	// Constructor
   ~BufferTeclado(void); 	// Destructor
};


/***************************************************************************
		DEFINICION DE LA CLASE BUFFER DE PANTALLA
***************************************************************************/
class BufferPantalla
{
 private:
	ushort atrib;					// atributos de color de la pantalla
	ushort *pantalla;  				// pantalla virtual del foco
	ushort far *memvideo;
	uchar xmin, ymin, xmax, ymax; 	// coordenadas de la pantalla
	uchar NR_COL, NR_LIN;			// Numero de columnas y de lineas
	uint TAM;						// tamao de la pantalla
	uchar x, y;						// posiciones dentro del foco
	void cargar_pantalla();			// carga en pantalla lo que hay en memvideo
 protected:
	friend class Teclado;
	uchar on;						// on=1 puede escribir en pantalla
	uchar ON;						// ON=1 la tarea tiene el foco y puede
	void subir_linea(void);			// modificar la posicion del cursor
	void volcar_pantalla(void);
	void SetCursor(uchar posx, uchar posy);
 public:
	BufferPantalla(	uchar Xmin=1,  uchar Ymin=1,
					uchar Xmax=80, uchar Ymax=25);
	~BufferPantalla(); 			// destructor del foco
	void textcolor(int color); 	// color del texto
	void textfondo(int color); 	// color de fondo
	void textatrib(int color);	// color de texto y fondo
	void clrscr(void);
	void ir_xy (uchar posx, uchar posy);
	void puts  (const char *s);
	void putn  (uint n);
	void putc  (char c);
//	int  printk(const char *fmt, ...);
};

#define BLACK          0
#define NEGRO          0
#define BLUE           1
#define AZUL           1
#define GREEN          2
#define VERDE          2
#define CYAN           3
#define CIELO          3
#define RED            4
#define ROJO           4
#define MAGENTA        5
#define MORADO         5
#define BROWN          6
#define MARRON         6
#define LIGHTGRAY      7
#define GRISCLARO      7
#define DARKGRAY       8
#define GRISOSCURO     8
#define LIGHTBLUE      9
#define AZULCLARO      9
#define LIGHTGREEN    10
#define VERDECLARO    10
#define LIGHTCYAN     11
#define CIELOCLARO    11
#define LIGHTRED      12
#define ROJOCLARO     12
#define LIGHTMAGENTA  13
#define MORADOCLARO   13
#define YELLOW        14
#define AMARILLO      14
#define WHITE         15
#define BLANCO        15
#define BLINK        128
#define PARPADEO     128


/***************************************************************************
	DEFINICION DE LA CLASE TAREA CON BUFFER DE TECLADO Y PANTALLA
***************************************************************************/
class BTask:public Task, public BufferPantalla, public BufferTeclado
{
	friend class Teclado;
 public:
	BTask(void *inicio, char name[], uchar x, uchar y, uchar X, uchar Y);
	char getch();
	char getche();
	void  gets(char *string);
};


/***************************************************************************
			DEFINICION DE LA CLASE GESTOR DE TECLADO
***************************************************************************/
struct LBTask
{
	BTask *tarea;
	LBTask *sig;
};

class Teclado
{
 private:
	LBTask *primero;		// Puntero al primer nodo de la lista circular
	LBTask *ultimo;			// Puntero al ultimo nodo.
	LBTask *actual;			// Puntero al nodo que tiene el foco activo
	void Permisos();		// Actualiza los permisos de escritura segun si
 protected:					//  la ventana solapa a la que tiene el foco
	void AddFoco(BTask *f); // Aade la tarea a la lista de focos
	void DelFoco(BTask *f);	// Elimina la tarea de la Lista
	char Dispatch();		// Distribuye las teclas pulsadas
	void NextFoco();		// Cambia el foco a la siguiente tarea
 public:
	Teclado();
};


/***************************************************************************
	ESTRUCTURA DE LISTAS DE TAREAS Y SU POSICION ACTUAL EN EL BUFFER
***************************************************************************/
struct LTask		// Sirve para la creacion de listas de tareas
{					//  para el planificador.
	Task *tarea;	// Puntero a la tarea.
	ushort PlanID;	// Posicion actual en el Buffer.
	struct LTask *sig;
};

/***************************************************************************
			DEFINICION DE LA CLASE PLANIFICADOR
***************************************************************************/
class Plan:public Teclado
{
 private:
	struct LTask *Lista;		// Lista de Tareas en Planificador
 protected:
	ushort numtareas;			// Numero de tareas en planificador
 public:
	class cMessage *Me,*Mr;
	class cMessageBox *MB;
	class cMailBox *MS;
	Plan( ushort velocidad=0x2000 );	// Constructor (velocidad timer)
	~Plan(void);						// Destructor
	void add(Task *Tar ,ushort ticks=2);// Aade un tarea al planificador
	void del(Task *Tar);				// Elimina una tarea.
	void EliminaTerminadas();			// Elimina tareas terminadas.
	void planifica();
	ushort getnumtareas();		// Devuelve las tareas aadidas.
	void TrataMens();
	Task *Actual();
	Task *Whois(void *ini);
	void Top();
};

extern class Plan *Sche;

#endif
